package org.planx.msd.list;

import java.util.Collection;
import java.util.List;
import org.planx.msd.*;
import org.planx.msd.util.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset of
 * <code>List</code>s considered as sets. That is, two lists are considered
 * equivalent if they contain the same elements in any order and any number.
 * <p>
 * <b>Note that this implementation is not synchronized.</b> If multiple
 * threads access an instance of this class concurrently, it must be
 * synchronized externally.
 *
 * @author Thomas Ambus
 */
public class SetDiscriminator<T> extends AbstractDiscriminator<List<T>> {
    private Discriminator<List<T>> bagDisc;

    /**
     * Constructs a new <code>SetDiscriminator</code> where the specified
     * <code>Discriminator</code> is capable of discriminating the elements
     * contained in the sets.
     * The instance will reuse the memory of the specified <code>Memory</code>.
     */
    public SetDiscriminator(Discriminator<T> d, Memory memory) {
        bagDisc = new BagDiscriminator<T>(d, memory, true);
    }

    public <U,S> Collection<List<S>> discriminate(List<? extends U> values,
                                        Extractor<U,? extends List<T>,S> e) {
        return bagDisc.discriminate(values, e);
    }
}
