/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ExceptionCollection
extends Exception {
    private static final long serialVersionUID = -3032674811026089923L;
    private static final String MSG = "One or more exceptions occurred during analysis:";
    private final List<Throwable> exceptions;
    private boolean fatal = false;

    public ExceptionCollection(List<Throwable> exceptions) {
        super(MSG);
        this.exceptions = exceptions;
    }

    public ExceptionCollection(List<Throwable> exceptions, boolean fatal) {
        super(MSG);
        this.exceptions = exceptions;
        this.fatal = fatal;
    }

    public ExceptionCollection(Throwable exception, boolean fatal) {
        super(MSG);
        if (exception instanceof ExceptionCollection) {
            ExceptionCollection other = (ExceptionCollection)exception;
            this.exceptions = other.getExceptions();
            this.fatal = other.isFatal();
        } else {
            this.exceptions = new ArrayList<Throwable>();
            this.exceptions.add(exception);
            this.fatal = fatal;
        }
    }

    public ExceptionCollection(Throwable exception) {
        super(MSG);
        if (exception instanceof ExceptionCollection) {
            ExceptionCollection other = (ExceptionCollection)exception;
            this.exceptions = other.getExceptions();
            this.fatal = other.isFatal();
        } else {
            this.exceptions = new ArrayList<Throwable>();
            this.exceptions.add(exception);
            this.fatal = false;
        }
    }

    public ExceptionCollection() {
        super(MSG);
        this.exceptions = new ArrayList<Throwable>();
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    public void addException(Throwable ex) {
        this.exceptions.add(ex);
    }

    public void addException(Throwable ex, boolean fatal) {
        this.addException(ex);
        this.fatal = fatal;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public void setFatal(boolean fatal) {
        this.fatal = fatal;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.println(MSG);
        super.printStackTrace(s);
        this.exceptions.forEach(t -> {
            s.println("Next Exception:");
            t.printStackTrace(s);
        });
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.println(MSG);
        super.printStackTrace(s);
        this.exceptions.forEach(t -> {
            s.println("Next Exception:");
            t.printStackTrace(s);
        });
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(MSG);
        this.exceptions.forEach(t -> sb.append("\n\t").append(t.getMessage()));
        return sb.toString();
    }
}

