/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nodeaudit;

import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

@ThreadSafe
public final class SanitizePackage {
    private SanitizePackage() {
    }

    public static JsonObject sanitize(JsonObject packageJson) {
        JsonValue jsonValue;
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder();
        String projectName = packageJson.getString("name", "");
        String projectVersion = packageJson.getString("version", "");
        if (!projectName.isEmpty()) {
            payloadBuilder.add("name", projectName);
        }
        if (!projectVersion.isEmpty()) {
            payloadBuilder.add("version", projectVersion);
        }
        if ((jsonValue = (JsonValue)packageJson.get((Object)"requires")) == null || jsonValue.getValueType() != JsonValue.ValueType.OBJECT) {
            JsonObjectBuilder requiresBuilder = Json.createObjectBuilder();
            JsonObject dependencies = packageJson.getJsonObject("dependencies");
            for (Map.Entry entry : dependencies.entrySet()) {
                String tmp;
                String version = ((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.OBJECT ? ((JsonObject)entry.getValue()).getString("version") : ((tmp = ((JsonValue)entry.getValue()).toString()).startsWith("\"") ? tmp.substring(1, tmp.length() - 1) : tmp);
                requiresBuilder.add((String)entry.getKey(), version);
            }
            payloadBuilder.add("requires", (JsonValue)requiresBuilder.build());
        }
        payloadBuilder.add("dependencies", (JsonValue)packageJson.getJsonObject("dependencies"));
        payloadBuilder.add("install", (JsonValue)Json.createArrayBuilder().build());
        payloadBuilder.add("remove", (JsonValue)Json.createArrayBuilder().build());
        payloadBuilder.add("metadata", Json.createObjectBuilder().add("npm_version", "6.1.0").add("node_version", "v10.5.0").add("platform", "linux"));
        return payloadBuilder.build();
    }
}

