/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.suppression;

import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PropertyType {
    private String value;
    private boolean regex = false;
    private boolean caseSensitive = false;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean value) {
        this.regex = value;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean value) {
        this.caseSensitive = value;
    }

    public boolean matches(String text) {
        if (text == null) {
            return false;
        }
        if (this.regex) {
            Pattern rx = this.caseSensitive ? Pattern.compile(this.value) : Pattern.compile(this.value, 2);
            return rx.matcher(text).matches();
        }
        if (this.caseSensitive) {
            return this.value.equals(text);
        }
        return this.value.equalsIgnoreCase(text);
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 59 * hash + (this.regex ? 1 : 0);
        hash = 59 * hash + (this.caseSensitive ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyType)) {
            return false;
        }
        PropertyType other = (PropertyType)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.regex != other.regex) {
            return false;
        }
        return this.caseSensitive == other.caseSensitive;
    }

    public String toString() {
        return "PropertyType{value=" + this.value + ", regex=" + this.regex + ", caseSensitive=" + this.caseSensitive + '}';
    }
}

