/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cpe;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.owasp.dependencycheck.data.cpe.IndexException;
import org.owasp.dependencycheck.data.lucene.SearchFieldAnalyzer;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CpeMemoryIndex
implements AutoCloseable {
    private static final CpeMemoryIndex INSTANCE = new CpeMemoryIndex();
    private static final Logger LOGGER = LoggerFactory.getLogger(CpeMemoryIndex.class);
    private RAMDirectory index;
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private Analyzer searchingAnalyzer;
    private QueryParser queryParser;
    private SearchFieldAnalyzer productFieldAnalyzer;
    private SearchFieldAnalyzer vendorFieldAnalyzer;
    private final AtomicInteger usageCount = new AtomicInteger(0);

    private CpeMemoryIndex() {
    }

    public static CpeMemoryIndex getInstance() {
        return INSTANCE;
    }

    public synchronized void open(CveDB cve) throws IndexException {
        if (CpeMemoryIndex.INSTANCE.usageCount.addAndGet(1) == 1) {
            this.index = new RAMDirectory();
            this.buildIndex(cve);
            try {
                this.indexReader = DirectoryReader.open((Directory)this.index);
            }
            catch (IOException ex) {
                throw new IndexException(ex);
            }
            this.indexSearcher = new IndexSearcher(this.indexReader);
            this.searchingAnalyzer = this.createSearchingAnalyzer();
            this.queryParser = new QueryParser("id", this.searchingAnalyzer);
        }
    }

    public synchronized boolean isOpen() {
        return CpeMemoryIndex.INSTANCE.usageCount.get() > 0;
    }

    private Analyzer createSearchingAnalyzer() {
        HashMap<String, Object> fieldAnalyzers = new HashMap<String, Object>();
        fieldAnalyzers.put("id", new KeywordAnalyzer());
        this.productFieldAnalyzer = new SearchFieldAnalyzer();
        this.vendorFieldAnalyzer = new SearchFieldAnalyzer();
        fieldAnalyzers.put("product", (Object)this.productFieldAnalyzer);
        fieldAnalyzers.put("vendor", (Object)this.vendorFieldAnalyzer);
        return new PerFieldAnalyzerWrapper((Analyzer)new KeywordAnalyzer(), fieldAnalyzers);
    }

    @Override
    public synchronized void close() {
        int count = CpeMemoryIndex.INSTANCE.usageCount.get() - 1;
        if (count <= 0) {
            CpeMemoryIndex.INSTANCE.usageCount.set(0);
            if (this.searchingAnalyzer != null) {
                this.searchingAnalyzer.close();
                this.searchingAnalyzer = null;
            }
            if (this.indexReader != null) {
                try {
                    this.indexReader.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("", (Throwable)ex);
                }
                this.indexReader = null;
            }
            this.queryParser = null;
            this.indexSearcher = null;
            if (this.index != null) {
                this.index.close();
                this.index = null;
            }
        }
    }

    private void buildIndex(CveDB cve) throws IndexException {
        try (Analyzer analyzer = this.createSearchingAnalyzer();
             IndexWriter indexWriter = new IndexWriter((Directory)this.index, new IndexWriterConfig(analyzer));){
            Document doc = new Document();
            TextField v = new TextField("vendor", "vendor", Field.Store.YES);
            TextField p = new TextField("product", "product", Field.Store.YES);
            doc.add((IndexableField)v);
            doc.add((IndexableField)p);
            Set<Pair<String, String>> data = cve.getVendorProductList();
            for (Pair<String, String> pair : data) {
                if (pair.getLeft() == null || pair.getRight() == null) continue;
                v.setStringValue(pair.getLeft());
                p.setStringValue(pair.getRight());
                indexWriter.addDocument((Iterable)doc);
                this.productFieldAnalyzer.reset();
                this.vendorFieldAnalyzer.reset();
            }
            indexWriter.commit();
        }
        catch (DatabaseException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new IndexException("Error reading CPE data", ex);
        }
        catch (IOException ex) {
            throw new IndexException("Unable to close an in-memory index", ex);
        }
    }

    public synchronized TopDocs search(String searchString, int maxQueryResults) throws ParseException, IOException {
        Query query = this.parseQuery(searchString);
        this.productFieldAnalyzer.reset();
        this.vendorFieldAnalyzer.reset();
        return this.search(query, maxQueryResults);
    }

    protected Query parseQuery(String searchString) throws ParseException {
        if (searchString == null || searchString.trim().isEmpty()) {
            throw new ParseException("Query is null or empty");
        }
        LOGGER.debug(searchString);
        Query query = this.queryParser.parse(searchString);
        return query;
    }

    public synchronized TopDocs search(Query query, int maxQueryResults) throws CorruptIndexException, IOException {
        return this.indexSearcher.search(query, maxQueryResults);
    }

    public synchronized Document getDocument(int documentId) throws IOException {
        return this.indexSearcher.doc(documentId);
    }

    public synchronized int numDocs() {
        if (this.indexReader == null) {
            return -1;
        }
        return this.indexReader.numDocs();
    }
}

