/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.utils.FileFilterBuilder;

@Experimental
@ThreadSafe
public class SwiftPackageManagerAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "Swift.PM";
    private static final String ANALYZER_NAME = "SWIFT Package Manager Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String SPM_FILE_NAME = "Package.swift";
    private static final FileFilter SPM_FILE_FILTER = FileFilterBuilder.newInstance().addFilenames("Package.swift").build();
    private static final Pattern SPM_BLOCK_PATTERN = Pattern.compile("let[^=]+=\\s*Package\\s*\\(\\s*([^)]*)\\s*\\)", 32);

    @Override
    protected FileFilter getFileFilter() {
        return SPM_FILE_FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.swift.package.manager.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        String contents;
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        try {
            contents = FileUtils.readFileToString((File)dependency.getActualFile(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        Matcher matcher = SPM_BLOCK_PATTERN.matcher(contents);
        if (matcher.find()) {
            String packageDescription = matcher.group(1);
            if (packageDescription.isEmpty()) {
                return;
            }
            String name = this.addStringEvidence(dependency, EvidenceType.PRODUCT, packageDescription, "name", "name", Confidence.HIGHEST);
            if (name != null && !name.isEmpty()) {
                dependency.addEvidence(EvidenceType.VENDOR, SPM_FILE_NAME, "name_project", name, Confidence.HIGHEST);
                dependency.setName(name);
            } else {
                dependency.setName(dependency.getActualFile().getParentFile().getName());
            }
            if (dependency.getVersion() != null && !dependency.getVersion().isEmpty()) {
                dependency.setDisplayFileName(String.format("%s:%s", dependency.getName(), dependency.getVersion()));
            } else {
                dependency.setDisplayFileName(dependency.getName());
            }
        }
        this.setPackagePath(dependency);
    }

    private String addStringEvidence(Dependency dependency, EvidenceType type, String packageDescription, String field, String fieldPattern, Confidence confidence) {
        String value = "";
        Matcher matcher = Pattern.compile(String.format("%s *:\\s*\"([^\"]*)", fieldPattern), 32).matcher(packageDescription);
        if (matcher.find()) {
            value = matcher.group(1);
        }
        if (value != null && (value = value.trim()).length() > 0) {
            dependency.addEvidence(type, SPM_FILE_NAME, field, value, confidence);
        }
        return value;
    }

    private void setPackagePath(Dependency dep) {
        File file = new File(dep.getFilePath());
        String parent = file.getParent();
        if (parent != null) {
            dep.setPackagePath(parent);
        }
    }
}

