/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.util.Set;
import org.owasp.dependencycheck.analyzer.AbstractDependencyComparingAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyMergingAnalyzer
extends AbstractDependencyComparingAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyMergingAnalyzer.class);
    private static final String ANALYZER_NAME = "Dependency Merging Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_INFORMATION_COLLECTION;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.dependencymerging.enabled";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean evaluateDependencies(Dependency dependency, Dependency nextDependency, Set<Dependency> dependenciesToRemove) {
        Dependency main = this.getMainGemspecDependency(dependency, nextDependency);
        if (main != null) {
            if (main == dependency) {
                DependencyMergingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                return false;
            }
            DependencyMergingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
            return true;
        }
        main = this.getMainSwiftDependency(dependency, nextDependency);
        if (main != null) {
            if (main == dependency) {
                DependencyMergingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                return false;
            }
            DependencyMergingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
            return true;
        }
        main = this.getMainAndroidDependency(dependency, nextDependency);
        if (main == null) return false;
        if (main == dependency) {
            DependencyMergingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
            return false;
        }
        DependencyMergingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
        return true;
    }

    public static void mergeDependencies(Dependency dependency, Dependency relatedDependency, Set<Dependency> dependenciesToRemove) {
        LOGGER.debug("Merging '{}' into '{}'", (Object)relatedDependency.getFilePath(), (Object)dependency.getFilePath());
        dependency.addRelatedDependency(relatedDependency);
        for (Evidence e : relatedDependency.getEvidence(EvidenceType.VENDOR)) {
            dependency.addEvidence(EvidenceType.VENDOR, e);
        }
        for (Evidence e : relatedDependency.getEvidence(EvidenceType.PRODUCT)) {
            dependency.addEvidence(EvidenceType.PRODUCT, e);
        }
        for (Evidence e : relatedDependency.getEvidence(EvidenceType.VERSION)) {
            dependency.addEvidence(EvidenceType.VERSION, e);
        }
        for (Dependency d : relatedDependency.getRelatedDependencies()) {
            dependency.addRelatedDependency(d);
            relatedDependency.removeRelatedDependencies(d);
        }
        dependency.addAllProjectReferences(relatedDependency.getProjectReferences());
        if (dependenciesToRemove != null) {
            dependenciesToRemove.add(relatedDependency);
        }
    }

    private boolean isSameRubyGem(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null || !dependency1.getFileName().endsWith(".gemspec") || !dependency2.getFileName().endsWith(".gemspec") || dependency1.getPackagePath() == null || dependency2.getPackagePath() == null) {
            return false;
        }
        return dependency1.getPackagePath().equalsIgnoreCase(dependency2.getPackagePath());
    }

    private Dependency getMainGemspecDependency(Dependency dependency1, Dependency dependency2) {
        if (this.isSameRubyGem(dependency1, dependency2)) {
            File lFile = dependency1.getActualFile();
            File left = lFile.getParentFile();
            if (left != null && left.getName().equalsIgnoreCase("specifications")) {
                return dependency1;
            }
            return dependency2;
        }
        return null;
    }

    private boolean isSameSwiftPackage(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null || !dependency1.getFileName().endsWith(".podspec") && !dependency1.getFileName().equals("Package.swift") || !dependency2.getFileName().endsWith(".podspec") && !dependency2.getFileName().equals("Package.swift") || dependency1.getPackagePath() == null || dependency2.getPackagePath() == null) {
            return false;
        }
        return dependency1.getPackagePath().equalsIgnoreCase(dependency2.getPackagePath());
    }

    private Dependency getMainSwiftDependency(Dependency dependency1, Dependency dependency2) {
        if (this.isSameSwiftPackage(dependency1, dependency2)) {
            if (dependency1.getFileName().endsWith(".podspec")) {
                return dependency1;
            }
            return dependency2;
        }
        return null;
    }

    private Dependency getMainAndroidDependency(Dependency dependency1, Dependency dependency2) {
        if (dependency1.isVirtual() || dependency2.isVirtual()) {
            return null;
        }
        if ("classes.jar".equals(dependency2.getActualFile().getName()) && "aar".equals(FileUtils.getFileExtension((String)dependency1.getActualFile().getName())) && dependency2.getActualFilePath().contains(dependency1.getActualFile().getName())) {
            return dependency1;
        }
        if ("classes.jar".equals(dependency1.getActualFile().getName()) && "aar".equals(FileUtils.getFileExtension((String)dependency2.getActualFile().getName())) && dependency1.getActualFilePath().contains(dependency2.getActualFile().getName())) {
            return dependency2;
        }
        return null;
    }
}

