/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.ExtractionException;
import org.owasp.dependencycheck.utils.ExtractionUtil;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.UrlStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class PythonDistributionAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "Python.Dist";
    private static final String PKG_INFO = "PKG-INFO";
    private static final String METADATA = "METADATA";
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonDistributionAnalyzer.class);
    private static final AtomicInteger DIR_COUNT = new AtomicInteger(0);
    private static final String ANALYZER_NAME = "Python Distribution Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String[] EXTENSIONS = new String[]{"whl", "egg", "zip"};
    private static final FileFilter EGG_OR_ZIP = FileFilterBuilder.newInstance().addExtensions("egg", "zip").build();
    private static final FileFilter WHL_FILTER = FileFilterBuilder.newInstance().addExtensions("whl").build();
    private File tempFileLocation;
    private static final FilenameFilter DIST_INFO_FILTER = new SuffixFileFilter(".dist-info");
    private static final FilenameFilter EGG_INFO_FILTER = new NameFileFilter("EGG-INFO");
    private static final NameFileFilter METADATA_FILTER = new NameFileFilter("METADATA");
    private static final NameFileFilter PKG_INFO_FILTER = new NameFileFilter("PKG-INFO");
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addFileFilters(new IOFileFilter[]{METADATA_FILTER, PKG_INFO_FILTER}).addExtensions(EXTENSIONS).build();

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.python.distribution.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        File actualFile = dependency.getActualFile();
        if (WHL_FILTER.accept(actualFile)) {
            this.collectMetadataFromArchiveFormat(dependency, DIST_INFO_FILTER, (FilenameFilter)METADATA_FILTER);
        } else if (EGG_OR_ZIP.accept(actualFile)) {
            this.collectMetadataFromArchiveFormat(dependency, EGG_INFO_FILTER, (FilenameFilter)PKG_INFO_FILTER);
        } else {
            String name = actualFile.getName();
            boolean metadata = METADATA.equals(name);
            if (metadata || PKG_INFO.equals(name)) {
                File parent = actualFile.getParentFile();
                String parentName = parent.getName();
                if (parent.isDirectory() && (metadata && parentName.endsWith(".dist-info") || parentName.endsWith(".egg-info") || "EGG-INFO".equals(parentName))) {
                    PythonDistributionAnalyzer.collectWheelMetadata(dependency, actualFile);
                }
            }
        }
    }

    private void collectMetadataFromArchiveFormat(Dependency dependency, FilenameFilter folderFilter, FilenameFilter metadataFilter) throws AnalysisException {
        File temp = this.getNextTempDirectory();
        LOGGER.debug("{} exists? {}", (Object)temp, (Object)temp.exists());
        try {
            ExtractionUtil.extractFilesUsingFilter(new File(dependency.getActualFilePath()), temp, metadataFilter);
        }
        catch (ExtractionException ex) {
            throw new AnalysisException(ex);
        }
        File matchingFile = PythonDistributionAnalyzer.getMatchingFile(temp, folderFilter);
        if (matchingFile != null && (matchingFile = PythonDistributionAnalyzer.getMatchingFile(matchingFile, metadataFilter)) != null) {
            PythonDistributionAnalyzer.collectWheelMetadata(dependency, matchingFile);
        }
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        try {
            File baseDir = this.getSettings().getTempDirectory();
            this.tempFileLocation = File.createTempFile("check", "tmp", baseDir);
            if (!this.tempFileLocation.delete()) {
                this.setEnabled(false);
                String msg = String.format("Unable to delete temporary file '%s'.", this.tempFileLocation.getAbsolutePath());
                throw new InitializationException(msg);
            }
            if (!this.tempFileLocation.mkdirs()) {
                this.setEnabled(false);
                String msg = String.format("Unable to create directory '%s'.", this.tempFileLocation.getAbsolutePath());
                throw new InitializationException(msg);
            }
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unable to create a temporary file", ex);
        }
    }

    @Override
    public void closeAnalyzer() {
        if (this.tempFileLocation != null && this.tempFileLocation.exists()) {
            String[] l;
            LOGGER.debug("Attempting to delete temporary files");
            boolean success = FileUtils.delete((File)this.tempFileLocation);
            if (!success && this.tempFileLocation.exists() && (l = this.tempFileLocation.list()) != null && l.length > 0) {
                LOGGER.warn("Failed to delete some temporary files, see the log for more details");
            }
        }
    }

    private static void collectWheelMetadata(Dependency dependency, File file) {
        InternetHeaders headers = PythonDistributionAnalyzer.getManifestProperties(file);
        PythonDistributionAnalyzer.addPropertyToEvidence(dependency, EvidenceType.VERSION, Confidence.HIGHEST, headers, "Version");
        PythonDistributionAnalyzer.addPropertyToEvidence(dependency, EvidenceType.PRODUCT, Confidence.HIGHEST, headers, "Name");
        PythonDistributionAnalyzer.addPropertyToEvidence(dependency, EvidenceType.PRODUCT, Confidence.MEDIUM, headers, "Name");
        dependency.setName(headers.getHeader("Name", null));
        dependency.setVersion(headers.getHeader("Version", null));
        String url = headers.getHeader("Home-page", null);
        if (StringUtils.isNotBlank((CharSequence)url) && UrlStringUtils.isUrl(url)) {
            dependency.addEvidence(EvidenceType.VENDOR, METADATA, "vendor", url, Confidence.MEDIUM);
        }
        PythonDistributionAnalyzer.addPropertyToEvidence(dependency, EvidenceType.VENDOR, Confidence.LOW, headers, "Author");
        String summary = headers.getHeader("Summary", null);
        if (StringUtils.isNotBlank((CharSequence)summary)) {
            JarAnalyzer.addDescription(dependency, summary, METADATA, "summary");
        }
    }

    private static void addPropertyToEvidence(Dependency dependency, EvidenceType type, Confidence confidence, InternetHeaders headers, String property) {
        String value = headers.getHeader(property, null);
        LOGGER.debug("Property: {}, Value: {}", (Object)property, (Object)value);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            dependency.addEvidence(type, METADATA, property, value, confidence);
        }
    }

    private static File getMatchingFile(File folder, FilenameFilter filter) {
        File result = null;
        File[] matches = folder.listFiles(filter);
        if (null != matches && 1 == matches.length) {
            result = matches[0];
        }
        return result;
    }

    private static InternetHeaders getManifestProperties(File manifest) {
        InternetHeaders result = new InternetHeaders();
        if (null == manifest) {
            LOGGER.debug("Manifest file not found.");
        } else {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(manifest));){
                result.load((InputStream)in);
            }
            catch (FileNotFoundException | MessagingException e) {
                LOGGER.warn(e.getMessage(), e);
            }
            catch (IOException ex) {
                LOGGER.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    private File getNextTempDirectory() throws AnalysisException {
        int dirCount;
        File directory;
        while ((directory = new File(this.tempFileLocation, String.valueOf(dirCount = DIR_COUNT.incrementAndGet()))).exists()) {
        }
        if (!directory.mkdirs()) {
            throw new AnalysisException(String.format("Unable to create temp directory '%s'.", directory.getAbsolutePath()));
        }
        return directory;
    }
}

