/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.BondRef;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.stereo.Atropisomeric;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.stereo.Octahedral;
import org.openscience.cdk.stereo.SquarePlanar;
import org.openscience.cdk.stereo.TrigonalBipyramidal;
import org.openscience.cdk.tools.LoggingToolFactory;

final class NonplanarBonds {
    private final IAtomContainer container;
    private final int[][] graph;
    private final RingSearch ringSearch;
    private final ITetrahedralChirality[] tetrahedralElements;
    private final IDoubleBondStereochemistry[] doubleBondElements;
    private final Map<IAtom, Integer> atomToIndex;
    private final GraphUtil.EdgeToBondMap edgeToBond;
    private static int SPIRO_REJECT = 0;
    private static int SPIRO_ACCEPT = 1;
    private static int SPIRO_MIRROR = 2;

    public static IAtomContainer assign(IAtomContainer container) {
        GraphUtil.EdgeToBondMap edgeToBond = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)container);
        new NonplanarBonds(container, GraphUtil.toAdjList((IAtomContainer)container, (GraphUtil.EdgeToBondMap)edgeToBond), edgeToBond);
        return container;
    }

    NonplanarBonds(IAtomContainer container, int[][] g, GraphUtil.EdgeToBondMap edgeToBond) {
        this.container = container;
        this.tetrahedralElements = new ITetrahedralChirality[container.getAtomCount()];
        this.doubleBondElements = new IDoubleBondStereochemistry[container.getAtomCount()];
        this.graph = g;
        this.atomToIndex = new HashMap<IAtom, Integer>(2 * container.getAtomCount());
        this.edgeToBond = edgeToBond;
        this.ringSearch = new RingSearch(container, this.graph);
        for (IBond bond : container.bonds()) {
            switch (bond.getStereo()) {
                case UP: 
                case UP_INVERTED: 
                case DOWN: 
                case DOWN_INVERTED: {
                    bond.setStereo(IBond.Stereo.NONE);
                }
            }
        }
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            this.atomToIndex.put(atom, i);
            if (atom.getPoint2d() != null) continue;
            throw new IllegalArgumentException("atom " + i + " had unset coordinates");
        }
        Integer[] foci = new Integer[container.getAtomCount()];
        int n = 0;
        for (IStereoElement element : container.stereoElements()) {
            if (element instanceof ITetrahedralChirality) {
                ITetrahedralChirality tc = (ITetrahedralChirality)element;
                int focus = this.atomToIndex.get(tc.getChiralAtom());
                this.tetrahedralElements[focus] = tc;
                foci[n++] = focus;
                continue;
            }
            if (!(element instanceof IDoubleBondStereochemistry)) continue;
            IBond doubleBond = ((IDoubleBondStereochemistry)element).getStereoBond();
            IDoubleBondStereochemistry iDoubleBondStereochemistry = (IDoubleBondStereochemistry)element;
            this.doubleBondElements[this.atomToIndex.get((Object)doubleBond.getEnd()).intValue()] = iDoubleBondStereochemistry;
            this.doubleBondElements[this.atomToIndex.get((Object)doubleBond.getBegin()).intValue()] = iDoubleBondStereochemistry;
        }
        Arrays.sort(foci, 0, n, new Comparator<Integer>(){

            @Override
            public int compare(Integer i, Integer j) {
                return -Integer.compare(NonplanarBonds.this.nAdjacentCentres(i), NonplanarBonds.this.nAdjacentCentres(j));
            }
        });
        for (int i = 0; i < n; ++i) {
            this.label(this.tetrahedralElements[foci[i]]);
        }
        for (IStereoElement se : container.stereoElements()) {
            if (se instanceof ExtendedTetrahedral) {
                this.label((ExtendedTetrahedral)se);
                continue;
            }
            if (se instanceof Atropisomeric) {
                this.label((Atropisomeric)se);
                continue;
            }
            if (se instanceof SquarePlanar) {
                this.modifyAndLabel((SquarePlanar)se);
                continue;
            }
            if (se instanceof TrigonalBipyramidal) {
                this.modifyAndLabel((TrigonalBipyramidal)se);
                continue;
            }
            if (!(se instanceof Octahedral)) continue;
            this.modifyAndLabel((Octahedral)se);
        }
        for (IBond bond : this.findUnspecifiedDoubleBonds(g)) {
            this.labelUnspecified(bond);
        }
    }

    private void rotate(Point2d p, Point2d pivot, double cos, double sin) {
        double x = p.x - pivot.x;
        double y = p.y - pivot.y;
        double nx = x * cos + y * sin;
        double ny = -x * sin + y * cos;
        p.x = nx + pivot.x;
        p.y = ny + pivot.y;
    }

    private Point2d getRotated(Point2d org, Point2d piviot, double theta) {
        Point2d cpy = new Point2d(org);
        this.rotate(cpy, piviot, Math.cos(theta), Math.sin(theta));
        return cpy;
    }

    private boolean snapBondsToPosition(IAtom beg, List<IBond> bonds, double ... angles) {
        Point2d p = beg.getPoint2d();
        Point2d ref = new Point2d(p.x, p.y + 1.0);
        if (angles.length != bonds.size()) {
            throw new IllegalArgumentException();
        }
        boolean res = true;
        for (int i = 0; i < bonds.size(); ++i) {
            if (this.snapBondToPosition(beg, bonds.get(i), this.getRotated(ref, p, Math.toRadians(angles[i])))) continue;
            res = false;
        }
        return res;
    }

    private boolean snapBondToPosition(IAtom beg, IBond bond, Point2d tP) {
        IAtom end = bond.getOther(beg);
        Point2d bP = beg.getPoint2d();
        Point2d eP = end.getPoint2d();
        Vector2d curr = new Vector2d(eP.x - bP.x, eP.y - bP.y);
        Vector2d dest = new Vector2d(tP.x - bP.x, tP.y - bP.y);
        double theta = Math.atan2(curr.y, curr.x) - Math.atan2(dest.y, dest.x);
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        if (bond.getFlag(16)) {
            boolean okay;
            curr.normalize();
            dest.normalize();
            double dot = curr.dot(dest);
            if (dot >= 0.97) {
                this.rotate(end.getPoint2d(), bP, cos, sin);
                return true;
            }
            HashMap<IAtom, Integer> visit = new HashMap<IAtom, Integer>();
            visit.put(beg, 1);
            this.floodFill(visit, end, 1);
            IBond reflectBond = null;
            for (IAtom atom : visit.keySet()) {
                IBond tmp = atom.getBond(beg);
                if (tmp == null || BondRef.deref((IBond)tmp) == BondRef.deref((IBond)bond)) continue;
                if (reflectBond != null) {
                    return false;
                }
                reflectBond = tmp;
            }
            if (reflectBond == null) {
                return false;
            }
            GeometryUtil.reflect(visit.keySet(), (Point2d)reflectBond.getBegin().getPoint2d(), (Point2d)reflectBond.getEnd().getPoint2d());
            curr = new Vector2d(eP.x - bP.x, eP.y - bP.y);
            curr.normalize();
            double newdot = curr.dot(dest);
            boolean bl = okay = newdot >= 0.97;
            if (newdot > dot) {
                theta = Math.atan2(curr.y, curr.x) - Math.atan2(dest.y, dest.x);
                this.rotate(end.getPoint2d(), bP, Math.cos(theta), Math.sin(theta));
            } else if (newdot < dot) {
                GeometryUtil.reflect(visit.keySet(), (Point2d)reflectBond.getBegin().getPoint2d(), (Point2d)reflectBond.getEnd().getPoint2d());
                this.rotate(end.getPoint2d(), bP, Math.cos(theta), Math.sin(theta));
            }
            return okay;
        }
        beg.setFlag(16, true);
        bond.setFlag(16, true);
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        queue.add(end);
        while (!queue.isEmpty()) {
            IAtom atom = (IAtom)queue.poll();
            if (atom.getFlag(16)) continue;
            this.rotate(atom.getPoint2d(), bP, cos, sin);
            atom.setFlag(16, true);
            for (IBond b : this.container.getConnectedBondsList(atom)) {
                if (b.getFlag(16)) continue;
                queue.add(b.getOther(atom));
                b.setFlag(16, true);
            }
        }
        return true;
    }

    private void floodFill(Map<IAtom, Integer> visit, IAtom beg, int num) {
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        visit.put(beg, num);
        queue.add(beg);
        while (!queue.isEmpty()) {
            IAtom atm = (IAtom)queue.poll();
            visit.put(atm, num);
            for (IBond bnd : atm.bonds()) {
                IAtom nbr = bnd.getOther(atm);
                if (visit.get(nbr) != null) continue;
                queue.add(nbr);
            }
        }
    }

    private void modifyAndLabel(SquarePlanar se) {
        IAtom focus = (IAtom)se.getFocus();
        List atoms = se.normalize().getCarriers();
        ArrayList<IBond> bonds = new ArrayList<IBond>(4);
        int rcount = 0;
        HashMap<IAtom, Integer> rmap = new HashMap<IAtom, Integer>();
        ArrayList<Integer> rnums = new ArrayList<Integer>(4);
        rmap.put(focus, 0);
        for (IAtom atom : atoms) {
            IBond bond = this.container.getBond((IAtom)se.getFocus(), atom);
            if (bond.isInRing()) {
                if (!rmap.containsKey(atom)) {
                    this.floodFill(rmap, atom, ++rcount);
                }
                rnums.add((Integer)rmap.get(atom));
            } else {
                rnums.add(0);
            }
            bonds.add(bond);
        }
        if (rcount > 0 && this.checkAndHandleRingSystems(bonds, rnums) == SPIRO_REJECT) {
            return;
        }
        for (IAtom atom : this.container.atoms()) {
            atom.setFlag(16, false);
        }
        for (IBond bond : this.container.bonds()) {
            bond.setFlag(16, false);
        }
        this.snapBondsToPosition(focus, bonds, -60.0, 60.0, 120.0, -120.0);
        this.setBondDisplay((IBond)bonds.get(0), focus, IBond.Stereo.DOWN);
        this.setBondDisplay((IBond)bonds.get(1), focus, IBond.Stereo.DOWN);
        this.setBondDisplay((IBond)bonds.get(2), focus, IBond.Stereo.UP);
        this.setBondDisplay((IBond)bonds.get(3), focus, IBond.Stereo.UP);
    }

    private boolean doMirror(List<IAtom> atoms) {
        int p = 1;
        for (int i = 0; i < atoms.size(); ++i) {
            IAtom a = atoms.get(i);
            for (int j = i + 1; j < atoms.size(); ++j) {
                IAtom b = atoms.get(j);
                if (a.getAtomicNumber() <= b.getAtomicNumber()) continue;
                p *= -1;
            }
        }
        return p < 0;
    }

    private void modifyAndLabel(TrigonalBipyramidal se) {
        boolean mirror;
        IAtom focus = (IAtom)se.getFocus();
        List atoms = se.normalize().getCarriers();
        ArrayList<IBond> bonds = new ArrayList<IBond>(5);
        int rcount = 0;
        HashMap<IAtom, Integer> rmap = new HashMap<IAtom, Integer>();
        ArrayList<Integer> rnums = new ArrayList<Integer>(4);
        rmap.put(focus, 0);
        for (Object atom : atoms) {
            IBond bond = this.container.getBond((IAtom)se.getFocus(), (IAtom)atom);
            if (bond.isInRing()) {
                if (!rmap.containsKey(atom)) {
                    this.floodFill(rmap, (IAtom)atom, ++rcount);
                }
                rnums.add((Integer)rmap.get(atom));
            } else {
                rnums.add(0);
            }
            bonds.add(bond);
        }
        int res = SPIRO_ACCEPT;
        if (rcount > 0 && (res = this.checkAndHandleRingSystems(bonds, rnums)) == SPIRO_REJECT) {
            return;
        }
        for (IAtom atom : this.container.atoms()) {
            atom.setFlag(16, false);
        }
        for (IBond bond : this.container.bonds()) {
            bond.setFlag(16, false);
        }
        boolean bl = mirror = res == SPIRO_MIRROR || rcount == 0 && this.doMirror(atoms.subList(1, 4));
        if (mirror) {
            this.snapBondsToPosition(focus, bonds, 0.0, -60.0, 90.0, -120.0, 180.0);
        } else {
            this.snapBondsToPosition(focus, bonds, 0.0, 60.0, -90.0, 120.0, 180.0);
        }
        this.setBondDisplay((IBond)bonds.get(1), focus, IBond.Stereo.DOWN);
        this.setBondDisplay((IBond)bonds.get(3), focus, IBond.Stereo.UP);
    }

    private void modifyAndLabel(Octahedral oc) {
        IAtom focus = (IAtom)oc.getFocus();
        List atoms = oc.normalize().getCarriers();
        ArrayList<IBond> bonds = new ArrayList<IBond>(6);
        int rcount = 0;
        HashMap<IAtom, Integer> rmap = new HashMap<IAtom, Integer>();
        rmap.put(focus, 0);
        ArrayList<Integer> rnums = new ArrayList<Integer>(6);
        double blen = 0.0;
        for (IAtom atom : atoms) {
            IBond bond = this.container.getBond((IAtom)oc.getFocus(), atom);
            if (bond.isInRing()) {
                if (!rmap.containsKey(atom)) {
                    this.floodFill(rmap, atom, ++rcount);
                }
                rnums.add((Integer)rmap.get(atom));
            } else {
                rnums.add(0);
            }
            bonds.add(bond);
            blen += GeometryUtil.getLength2D((IBond)bond);
        }
        int res = SPIRO_ACCEPT;
        if (rcount > 0 && (res = this.checkAndHandleRingSystems(bonds, rnums)) == SPIRO_REJECT) {
            return;
        }
        for (IAtom atom : this.container.atoms()) {
            atom.setFlag(16, false);
        }
        for (IBond bond : this.container.bonds()) {
            bond.setFlag(16, false);
        }
        if (res == SPIRO_MIRROR) {
            this.snapBondsToPosition(focus, bonds, 0.0, -60.0, 60.0, 120.0, -120.0, 180.0);
        } else {
            this.snapBondsToPosition(focus, bonds, 0.0, 60.0, -60.0, -120.0, 120.0, 180.0);
        }
        this.setBondDisplay((IBond)bonds.get(1), focus, IBond.Stereo.DOWN);
        this.setBondDisplay((IBond)bonds.get(2), focus, IBond.Stereo.DOWN);
        this.setBondDisplay((IBond)bonds.get(3), focus, IBond.Stereo.UP);
        this.setBondDisplay((IBond)bonds.get(4), focus, IBond.Stereo.UP);
    }

    private int checkAndHandleRingSystems(List<IBond> bonds, List<Integer> rnums) {
        int i;
        int rotate;
        if (!this.isSpiro(rnums)) {
            return SPIRO_REJECT;
        }
        if (bonds.size() == 4) {
            if (rnums.get(0).equals(rnums.get(2)) || rnums.get(1).equals(rnums.get(3))) {
                return SPIRO_REJECT;
            }
            rotate = rnums.get(1).equals(rnums.get(2)) ? 0 : (rnums.get(2).equals(rnums.get(3)) ? 1 : (rnums.get(3).equals(rnums.get(0)) ? 2 : 0));
            for (i = 0; i < rotate; ++i) {
                this.rotate(bonds, 0, 4);
                this.rotate(rnums, 0, 4);
            }
        }
        if (bonds.size() == 5) {
            if (rnums.get(0) != 0 && rnums.get(0).equals(rnums.get(4))) {
                return SPIRO_REJECT;
            }
            rotate = rnums.get(1) != 0 && rnums.get(1).equals(rnums.get(3)) || rnums.get(2) == 0 && !rnums.get(1).equals(rnums.get(3)) ? 0 : (rnums.get(2) != 0 && rnums.get(2).equals(rnums.get(1)) || rnums.get(3) == 0 && !rnums.get(2).equals(rnums.get(1)) ? 1 : (rnums.get(3) != 0 && rnums.get(3).equals(rnums.get(2)) || rnums.get(1) == 0 && !rnums.get(3).equals(rnums.get(2)) ? 2 : 0));
            for (i = 0; i < rotate; ++i) {
                this.rotate(bonds, 1, 3);
                this.rotate(rnums, 1, 3);
            }
            if (!rnums.get(0).equals(0) && rnums.get(0).equals(rnums.get(3)) || !rnums.get(1).equals(0) && rnums.get(1).equals(rnums.get(4))) {
                this.swap(bonds, 1, 3);
                this.swap(rnums, 1, 3);
                return SPIRO_MIRROR;
            }
        }
        if (bonds.size() == 6) {
            if (rnums.get(0) != 0 && rnums.get(0).equals(rnums.get(5)) || rnums.get(1) != 0 && rnums.get(1).equals(rnums.get(3)) || rnums.get(2) != 0 && rnums.get(2).equals(rnums.get(4))) {
                return SPIRO_REJECT;
            }
            if (rnums.get(2).equals(rnums.get(3))) {
                rotate = 0;
            } else if (rnums.get(3).equals(rnums.get(4))) {
                rotate = 1;
            } else if (rnums.get(4).equals(rnums.get(1))) {
                rotate = 2;
            } else if (rnums.get(1).equals(rnums.get(2))) {
                rotate = 3;
            } else {
                return SPIRO_REJECT;
            }
            for (i = 0; i < rotate; ++i) {
                this.rotate(bonds, 1, 4);
                this.rotate(rnums, 1, 4);
            }
            if (!rnums.get(0).equals(0) && rnums.get(0).equals(rnums.get(4)) || !rnums.get(1).equals(0) && rnums.get(1).equals(rnums.get(5))) {
                this.swap(bonds, 1, 4);
                this.swap(rnums, 1, 4);
                return SPIRO_MIRROR;
            }
            return SPIRO_ACCEPT;
        }
        return SPIRO_ACCEPT;
    }

    private boolean isSpiro(List<Integer> rnums) {
        int[] counts = new int[1 + rnums.size()];
        for (Integer rnum : rnums) {
            if (rnum == 0) continue;
            int n = rnum;
            counts[n] = counts[n] + 1;
            if (counts[n] <= 2) continue;
            return false;
        }
        return true;
    }

    private <T> void rotate(List<T> l, int off, int len) {
        for (int i = 0; i < len - 1; ++i) {
            this.swap(l, off + i, off + (i + 1) % 4);
        }
    }

    private <T> void swap(List<T> l, int i, int j) {
        T tmp = l.get(i);
        l.set(i, l.get(j));
        l.set(j, tmp);
    }

    private IBond.Stereo flip(IBond.Stereo disp) {
        switch (disp) {
            case UP: {
                return IBond.Stereo.UP_INVERTED;
            }
            case UP_INVERTED: {
                return IBond.Stereo.UP;
            }
            case DOWN: {
                return IBond.Stereo.DOWN_INVERTED;
            }
            case DOWN_INVERTED: {
                return IBond.Stereo.DOWN;
            }
            case UP_OR_DOWN: {
                return IBond.Stereo.UP_OR_DOWN_INVERTED;
            }
            case UP_OR_DOWN_INVERTED: {
                return IBond.Stereo.UP_OR_DOWN;
            }
        }
        return disp;
    }

    private void setBondDisplay(IBond bond, IAtom focus, IBond.Stereo display) {
        if (bond.getBegin().equals(focus)) {
            bond.setStereo(display);
        } else {
            bond.setStereo(this.flip(display));
        }
    }

    private IBond findBond(IAtom beg1, IAtom beg2, IAtom end) {
        IBond bond = this.container.getBond(beg1, end);
        if (bond != null) {
            return bond;
        }
        return this.container.getBond(beg2, end);
    }

    private void setWedge(IBond bond, IAtom end, IBond.Stereo style) {
        if (!bond.getEnd().equals(end)) {
            bond.setAtoms(new IAtom[]{bond.getEnd(), bond.getBegin()});
        }
        bond.setStereo(style);
    }

    private void label(ExtendedTetrahedral element) {
        IAtom focus = element.focus();
        IAtom[] atoms = element.peripherals();
        IBond[] bonds = new IBond[4];
        int p = this.parity(element.winding());
        List focusBonds = this.container.getConnectedBondsList(focus);
        if (focusBonds.size() != 2) {
            LoggingToolFactory.createLoggingTool(this.getClass()).warn((Object)"Non-cumulated carbon presented as the focus of extended tetrahedral stereo configuration");
            return;
        }
        IAtom[] terminals = element.findTerminalAtoms(this.container);
        IAtom left = terminals[0];
        IAtom right = terminals[1];
        for (int i = 0; i < 4; ++i) {
            bonds[i] = this.findBond(left, right, atoms[i]);
        }
        int[] rank = new int[4];
        for (int i = 0; i < 4; ++i) {
            rank[i] = i;
        }
        p *= this.sortClockwise(rank, focus, atoms, 4);
        IBond.Stereo[] labels = new IBond.Stereo[4];
        for (int i = 0; i < 4; ++i) {
            int v = rank[i];
            labels[v] = (p *= -1) > 0 ? IBond.Stereo.UP : IBond.Stereo.DOWN;
        }
        int[] priority = new int[]{5, 5, 5, 5};
        int i = 0;
        for (int v : this.priority(this.atomToIndex.get(focus), atoms, 4)) {
            IBond bond = bonds[v];
            if (bond == null || bond.getStereo() != IBond.Stereo.NONE || bond.getOrder() != IBond.Order.SINGLE) continue;
            priority[v] = i++;
        }
        if (priority[0] + priority[1] < priority[2] + priority[3]) {
            if (priority[0] < 5) {
                this.setWedge(bonds[0], atoms[0], labels[0]);
            }
            if (priority[1] < 5) {
                this.setWedge(bonds[1], atoms[1], labels[1]);
            }
        } else {
            if (priority[2] < 5) {
                this.setWedge(bonds[2], atoms[2], labels[2]);
            }
            if (priority[3] < 5) {
                this.setWedge(bonds[3], atoms[3], labels[3]);
            }
        }
    }

    private void label(Atropisomeric element) {
        IBond focus = (IBond)element.getFocus();
        IAtom beg = focus.getBegin();
        IAtom end = focus.getEnd();
        IAtom[] atoms = element.getCarriers().toArray(new IAtom[0]);
        IBond[] bonds = new IBond[4];
        int p = 0;
        switch (element.getConfigOrder()) {
            case 1: {
                p = 1;
                break;
            }
            case 2: {
                p = -1;
            }
        }
        bonds[0] = this.container.getBond(beg, atoms[0]);
        bonds[1] = this.container.getBond(beg, atoms[1]);
        bonds[2] = this.container.getBond(end, atoms[2]);
        bonds[3] = this.container.getBond(end, atoms[3]);
        if (bonds[0] == null || bonds[1] == null || bonds[2] == null || bonds[3] == null) {
            throw new IllegalStateException("Unexpected configuration ordering, beg/end bonds should be in that order.");
        }
        int[] rank = new int[4];
        for (int i = 0; i < 4; ++i) {
            rank[i] = i;
        }
        IAtom phantom = beg.getBuilder().newAtom();
        phantom.setPoint2d(new Point2d((beg.getPoint2d().x + end.getPoint2d().x) / 2.0, (beg.getPoint2d().y + end.getPoint2d().y) / 2.0));
        p *= this.sortClockwise(rank, phantom, atoms, 4);
        IBond.Stereo[] labels = new IBond.Stereo[4];
        for (int i = 0; i < 4; ++i) {
            int v = rank[i];
            labels[v] = (p *= -1) > 0 ? IBond.Stereo.UP : IBond.Stereo.DOWN;
        }
        int[] priority = new int[]{5, 5, 5, 5};
        int i = 0;
        for (int v : new int[]{0, 1, 2, 3}) {
            IBond bond = bonds[v];
            if (bond == null || bond.getStereo() != IBond.Stereo.NONE || bond.getOrder() != IBond.Order.SINGLE) continue;
            priority[v] = i++;
        }
        if (priority[0] + priority[1] < priority[2] + priority[3]) {
            if (priority[0] < 5) {
                bonds[0].setAtoms(new IAtom[]{beg, atoms[0]});
                bonds[0].setStereo(labels[0]);
            }
            if (priority[1] < 5) {
                bonds[1].setAtoms(new IAtom[]{beg, atoms[1]});
                bonds[1].setStereo(labels[1]);
            }
        } else {
            if (priority[2] < 5) {
                bonds[2].setAtoms(new IAtom[]{end, atoms[2]});
                bonds[2].setStereo(labels[2]);
            }
            if (priority[3] < 5) {
                bonds[3].setAtoms(new IAtom[]{end, atoms[3]});
                bonds[3].setStereo(labels[3]);
            }
        }
    }

    private void label(ITetrahedralChirality element) {
        IAtom focus = element.getChiralAtom();
        IAtom[] atoms = element.getLigands();
        IBond[] bonds = new IBond[4];
        int p = this.parity(element.getStereo());
        int n = 0;
        if (p == 0) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (atoms[i].equals(focus)) {
                p *= this.indexParity(i);
                continue;
            }
            bonds[n] = this.container.getBond(focus, atoms[i]);
            if (bonds[n] == null) {
                throw new IllegalArgumentException("Inconsistent stereo, tetrahedral centre contained atom not stored in molecule");
            }
            atoms[n] = atoms[i];
            ++n;
        }
        int[] rank = new int[n];
        for (int i = 0; i < n; ++i) {
            rank[i] = i;
        }
        p *= this.sortClockwise(rank, focus, atoms, n);
        int invert = -1;
        if (n == 3) {
            for (int i = 0; i < n; ++i) {
                Point2d a = atoms[rank[i]].getPoint2d();
                Point2d b = focus.getPoint2d();
                Point2d c = atoms[rank[(i + 2) % n]].getPoint2d();
                double det = (a.x - c.x) * (b.y - c.y) - (a.y - c.y) * (b.x - c.x);
                if (!(det > 0.0)) continue;
                invert = rank[(i + 1) % n];
                break;
            }
        }
        IBond.Stereo[] labels = new IBond.Stereo[n];
        for (int i = 0; i < n; ++i) {
            int v = rank[i];
            if (n == 4) {
                p *= -1;
            }
            labels[v] = invert == v ? (p > 0 ? IBond.Stereo.DOWN : IBond.Stereo.UP) : (p > 0 ? IBond.Stereo.UP : IBond.Stereo.DOWN);
        }
        IBond.Stereo firstlabel = null;
        boolean assignTwoLabels = this.assignTwoLabels(bonds, labels);
        for (int v : this.priority(this.atomToIndex.get(focus), atoms, n)) {
            IBond bond = bonds[v];
            if (bond.getStereo() != IBond.Stereo.NONE || bond.getOrder() != IBond.Order.SINGLE) continue;
            if (firstlabel == null) {
                bond.setAtoms(new IAtom[]{focus, atoms[v]});
                bond.setStereo(labels[v]);
                firstlabel = labels[v];
                if (assignTwoLabels) continue;
                break;
            }
            if (labels[v] == firstlabel) continue;
            if (this.isSp3Carbon(atoms[v], this.graph[this.container.indexOf(atoms[v])].length)) break;
            bond.setAtoms(new IAtom[]{focus, atoms[v]});
            bond.setStereo(labels[v]);
            break;
        }
        if (firstlabel == null) {
            throw new IllegalArgumentException("could not assign non-planar (up/down) labels");
        }
    }

    private boolean assignTwoLabels(IBond[] bonds, IBond.Stereo[] labels) {
        return labels.length == 4 && this.countRingBonds(bonds) != 3;
    }

    private int countRingBonds(IBond[] bonds) {
        int rbonds = 0;
        for (IBond bond : bonds) {
            if (bond == null || !bond.isInRing()) continue;
            ++rbonds;
        }
        return rbonds;
    }

    private int indexParity(int x) {
        return (x & 1) == 1 ? -1 : 1;
    }

    private int parity(ITetrahedralChirality.Stereo stereo) {
        switch (stereo) {
            case CLOCKWISE: {
                return -1;
            }
            case ANTI_CLOCKWISE: {
                return 1;
            }
        }
        return 0;
    }

    private int nAdjacentCentres(int i) {
        int n = 0;
        for (IAtom atom : this.tetrahedralElements[i].getLigands()) {
            if (this.tetrahedralElements[this.atomToIndex.get(atom)] == null) continue;
            ++n;
        }
        return n;
    }

    private int[] priority(int focus, IAtom[] atoms, int n) {
        int[] rank = new int[n];
        for (int i = 0; i < n; ++i) {
            rank[i] = i;
        }
        for (int j = 1; j < n; ++j) {
            int v = rank[j];
            int i = j - 1;
            while (i >= 0 && this.hasPriority(focus, this.atomToIndex.get(atoms[v]), this.atomToIndex.get(atoms[rank[i]]))) {
                rank[i + 1] = rank[i--];
            }
            rank[i + 1] = v;
        }
        return rank;
    }

    private boolean isSp3Carbon(IAtom atom, int deg) {
        Integer elem = atom.getAtomicNumber();
        Integer hcnt = atom.getImplicitHydrogenCount();
        if (elem == null || hcnt == null) {
            return false;
        }
        if (elem == 6 && hcnt <= 1 && deg + hcnt == 4) {
            ArrayList<IAtom> terminals = new ArrayList<IAtom>();
            for (IBond bond : this.container.getConnectedBondsList(atom)) {
                IAtom nbr = bond.getOther(atom);
                if (this.container.getConnectedBondsCount(nbr) != 1) continue;
                for (IAtom terminal : terminals) {
                    if (!Objects.equals(terminal.getAtomicNumber(), nbr.getAtomicNumber()) || !Objects.equals(terminal.getMassNumber(), nbr.getMassNumber()) || !Objects.equals(terminal.getFormalCharge(), nbr.getFormalCharge()) || !Objects.equals(terminal.getImplicitHydrogenCount(), nbr.getImplicitHydrogenCount())) continue;
                    return false;
                }
                terminals.add(nbr);
            }
            return true;
        }
        return false;
    }

    boolean hasPriority(int focus, int i, int j) {
        boolean jCyclic;
        boolean jIsSp3;
        if (this.tetrahedralElements[i] == null && this.tetrahedralElements[j] != null) {
            return true;
        }
        if (this.tetrahedralElements[i] != null && this.tetrahedralElements[j] == null) {
            return false;
        }
        if (this.doubleBondElements[i] == null && this.doubleBondElements[j] != null) {
            return true;
        }
        if (this.doubleBondElements[i] != null && this.doubleBondElements[j] == null) {
            return false;
        }
        IAtom iAtom = this.container.getAtom(i);
        IAtom jAtom = this.container.getAtom(j);
        boolean iIsSp3 = this.isSp3Carbon(iAtom, this.graph[i].length);
        if (iIsSp3 != (jIsSp3 = this.isSp3Carbon(jAtom, this.graph[j].length))) {
            return !iIsSp3;
        }
        if (this.tetrahedralElements[i] == null && this.tetrahedralElements[j] != null) {
            return true;
        }
        if (this.tetrahedralElements[i] != null && this.tetrahedralElements[j] == null) {
            return false;
        }
        boolean iCyclic = focus >= 0 ? this.ringSearch.cyclic(focus, i) : this.ringSearch.cyclic(i);
        boolean bl = jCyclic = focus >= 0 ? this.ringSearch.cyclic(focus, j) : this.ringSearch.cyclic(j);
        if (!iCyclic && jCyclic) {
            return true;
        }
        if (iCyclic && !jCyclic) {
            return false;
        }
        if (iAtom.getAtomicNumber() > 0 && jAtom.getAtomicNumber() == 0) {
            return true;
        }
        if (iAtom.getAtomicNumber() == 0 && jAtom.getAtomicNumber() > 0) {
            return false;
        }
        int iDegree = this.graph[i].length;
        int iElem = iAtom.getAtomicNumber();
        int jDegree = this.graph[j].length;
        int jElem = jAtom.getAtomicNumber();
        if (iElem == 6) {
            iElem = 256;
        }
        if (jElem == 6) {
            jElem = 256;
        }
        if (iDegree == 1 && jDegree > 1) {
            return true;
        }
        if (jDegree == 1 && iDegree > 1) {
            return false;
        }
        if (iElem < jElem) {
            return true;
        }
        if (iElem > jElem) {
            return false;
        }
        if (iDegree < jDegree) {
            return true;
        }
        if (iDegree > jDegree) {
            return false;
        }
        return false;
    }

    private int sortClockwise(int[] indices, IAtom focus, IAtom[] atoms, int n) {
        int x = 0;
        for (int j = 1; j < n; ++j) {
            int v = indices[j];
            int i = j - 1;
            while (i >= 0 && NonplanarBonds.less(v, indices[i], atoms, focus.getPoint2d())) {
                indices[i + 1] = indices[i--];
                ++x;
            }
            indices[i + 1] = v;
        }
        return this.indexParity(x);
    }

    static boolean less(int i, int j, IAtom[] atoms, Point2d center) {
        Point2d a = atoms[i].getPoint2d();
        Point2d b = atoms[j].getPoint2d();
        if (a.x - center.x >= 0.0 && b.x - center.x < 0.0) {
            return true;
        }
        if (a.x - center.x < 0.0 && b.x - center.x >= 0.0) {
            return false;
        }
        if (a.x - center.x == 0.0 && b.x - center.x == 0.0) {
            if (a.y - center.y >= 0.0 || b.y - center.y >= 0.0) {
                return a.y > b.y;
            }
            return b.y > a.y;
        }
        double det = (a.x - center.x) * (b.y - center.y) - (b.x - center.x) * (a.y - center.y);
        if (det < 0.0) {
            return true;
        }
        if (det > 0.0) {
            return false;
        }
        double d1 = (a.x - center.x) * (a.x - center.x) + (a.y - center.y) * (a.y - center.y);
        double d2 = (b.x - center.x) * (b.x - center.x) + (b.y - center.y) * (b.y - center.y);
        return d1 > d2;
    }

    private void labelUnspecified(IBond doubleBond) {
        IBond bond;
        IAtom aBeg = doubleBond.getBegin();
        IAtom aEnd = doubleBond.getEnd();
        int beg = this.atomToIndex.get(aBeg);
        int end = this.atomToIndex.get(aEnd);
        int nAdj = 0;
        IAtom[] focus = new IAtom[4];
        IAtom[] adj = new IAtom[4];
        for (int neighbor : this.graph[beg]) {
            bond = this.edgeToBond.get(beg, neighbor);
            if (bond.getOrder() == IBond.Order.SINGLE) {
                if (nAdj == 4) {
                    return;
                }
                focus[nAdj] = aBeg;
                adj[nAdj++] = this.container.getAtom(neighbor);
            }
            if (bond.getStereo() != IBond.Stereo.UP_OR_DOWN && bond.getStereo() != IBond.Stereo.UP_OR_DOWN_INVERTED) continue;
            return;
        }
        for (int neighbor : this.graph[end]) {
            bond = this.edgeToBond.get(end, neighbor);
            if (bond.getOrder() == IBond.Order.SINGLE) {
                if (nAdj == 4) {
                    return;
                }
                focus[nAdj] = aEnd;
                adj[nAdj++] = this.container.getAtom(neighbor);
            }
            if (bond.getStereo() != IBond.Stereo.UP_OR_DOWN && bond.getStereo() != IBond.Stereo.UP_OR_DOWN_INVERTED) continue;
            return;
        }
        int[] rank = this.priority(-1, adj, nAdj);
        for (int i = 0; i < nAdj; ++i) {
            if (this.doubleBondElements[this.atomToIndex.get(adj[rank[i]])] != null || this.tetrahedralElements[this.atomToIndex.get(adj[rank[i]])] != null) continue;
            this.edgeToBond.get(this.atomToIndex.get(focus[rank[i]]).intValue(), this.atomToIndex.get(adj[rank[i]]).intValue()).setStereo(IBond.Stereo.UP_OR_DOWN);
            return;
        }
        doubleBond.setStereo(IBond.Stereo.E_OR_Z);
    }

    private boolean isCisTransEndPoint(int idx) {
        IAtom atom = this.container.getAtom(idx);
        if (atom.getAtomicNumber() == null || atom.getFormalCharge() == null || atom.getImplicitHydrogenCount() == null) {
            return false;
        }
        int chg = atom.getFormalCharge();
        int btypes = this.getBondTypes(idx);
        switch (atom.getAtomicNumber()) {
            case 6: 
            case 14: 
            case 32: {
                return chg == 0 && btypes == 258;
            }
            case 7: {
                if (chg == 0) {
                    return btypes == 257;
                }
                if (chg != 1) break;
                return btypes == 258;
            }
        }
        return false;
    }

    private int getBondTypes(int idx) {
        int btypes = this.container.getAtom(idx).getImplicitHydrogenCount();
        for (int end : this.graph[idx]) {
            IBond bond = this.edgeToBond.get(idx, end);
            if (bond.getOrder() == IBond.Order.SINGLE) {
                ++btypes;
                continue;
            }
            if (bond.getOrder() == IBond.Order.DOUBLE) {
                btypes += 256;
                continue;
            }
            btypes += 65536;
        }
        return btypes;
    }

    private List<IBond> findUnspecifiedDoubleBonds(int[][] adjList) {
        ArrayList<IBond> unspecifiedDoubleBonds = new ArrayList<IBond>();
        for (IBond bond : this.container.bonds()) {
            int end;
            if (bond.getOrder() != IBond.Order.DOUBLE) continue;
            IAtom aBeg = bond.getBegin();
            IAtom aEnd = bond.getEnd();
            int beg = this.atomToIndex.get(aBeg);
            if (this.ringSearch.cyclic(beg, end = this.atomToIndex.get(aEnd).intValue()) || this.doubleBondElements[beg] != null && this.doubleBondElements[beg].getStereoBond().equals(bond) || this.doubleBondElements[end] != null && this.doubleBondElements[end].getStereoBond().equals(bond) || this.tetrahedralElements[beg] != null || this.tetrahedralElements[end] != null || !this.isCisTransEndPoint(beg) || !this.isCisTransEndPoint(end) || !this.hasOnlyPlainBonds(beg, bond) || !this.hasOnlyPlainBonds(end, bond) || this.hasLinearEqualPaths(adjList, beg, end) || this.hasLinearEqualPaths(adjList, end, beg)) continue;
            unspecifiedDoubleBonds.add(bond);
        }
        return unspecifiedDoubleBonds;
    }

    private boolean hasLinearEqualPaths(int[][] adjList, int start, int prev) {
        int a = -1;
        int b = -1;
        for (int w : adjList[start]) {
            if (w == prev) continue;
            if (a == -1) {
                a = w;
                continue;
            }
            if (b == -1) {
                b = w;
                continue;
            }
            return false;
        }
        if (b < 0) {
            return false;
        }
        HashSet<IAtom> visit = new HashSet<IAtom>();
        IAtom aAtom = this.container.getAtom(a);
        IAtom bAtom = this.container.getAtom(b);
        visit.add(this.container.getAtom(start));
        if (aAtom.isInRing() || bAtom.isInRing()) {
            return false;
        }
        IAtom aNext = aAtom;
        IAtom bNext = bAtom;
        while (aNext != null && bNext != null) {
            IAtom atom;
            aAtom = aNext;
            bAtom = bNext;
            visit.add(aAtom);
            visit.add(bAtom);
            aNext = null;
            bNext = null;
            if (this.notEqual(aAtom.getAtomicNumber(), bAtom.getAtomicNumber())) {
                return false;
            }
            if (this.notEqual(aAtom.getFormalCharge(), bAtom.getFormalCharge())) {
                return false;
            }
            if (this.notEqual(aAtom.getMassNumber(), bAtom.getMassNumber())) {
                return false;
            }
            int hCntA = aAtom.getImplicitHydrogenCount();
            int hCntB = bAtom.getImplicitHydrogenCount();
            int cntA = 0;
            int cntB = 0;
            for (int w : adjList[this.atomToIndex.get(aAtom)]) {
                atom = this.container.getAtom(w);
                if (visit.contains(atom)) continue;
                if (atom.getAtomicNumber() == 1 && adjList[w].length == 1) {
                    ++hCntA;
                    continue;
                }
                aNext = cntA == 0 ? atom : null;
                ++cntA;
            }
            for (int w : adjList[this.atomToIndex.get(bAtom)]) {
                atom = this.container.getAtom(w);
                if (visit.contains(atom)) continue;
                if (atom.getAtomicNumber() == 1 && adjList[w].length == 1) {
                    ++hCntB;
                    continue;
                }
                bNext = cntB == 0 ? atom : null;
                ++cntB;
            }
            if (hCntA != hCntB) {
                return false;
            }
            if (cntA == cntB && (cntA <= 1 || cntB <= 1)) continue;
            return false;
        }
        return aNext == null && bNext == null;
    }

    private boolean notEqual(Integer a, Integer b) {
        return a == null ? b != null : !a.equals(b);
    }

    private boolean hasOnlyPlainBonds(int v, IBond allowedDoubleBond) {
        int count = 0;
        for (int neighbor : this.graph[v]) {
            IBond adjBond = this.edgeToBond.get(v, neighbor);
            if (adjBond.getOrder().numeric() > 1) {
                if (allowedDoubleBond.equals(adjBond)) continue;
                return false;
            }
            if (adjBond.getStereo() == IBond.Stereo.UP_OR_DOWN || adjBond.getStereo() == IBond.Stereo.UP_OR_DOWN_INVERTED) {
                return false;
            }
            ++count;
        }
        return count > 0;
    }
}

