/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.vecmath.Point2d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

final class IdentityTemplateLibrary {
    private final Multimap<String, Point2d[]> templateMap = LinkedListMultimap.create();
    private final SmilesGenerator smigen = SmilesGenerator.unique();
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(this.getClass());

    private IdentityTemplateLibrary() {
    }

    public IdentityTemplateLibrary add(IdentityTemplateLibrary library) {
        this.templateMap.putAll(library.templateMap);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cansmi(IAtomContainer mol, int[] ordering) throws CDKException {
        int i;
        Integer[] hcntBackup = new Integer[mol.getAtomCount()];
        HashMap<IAtom, Integer> idxs = new HashMap<IAtom, Integer>();
        for (int i2 = 0; i2 < mol.getAtomCount(); ++i2) {
            hcntBackup[i2] = mol.getAtom(i2).getImplicitHydrogenCount();
            idxs.put(mol.getAtom(i2), i2);
        }
        int[] bondedValence = new int[mol.getAtomCount()];
        for (i = 0; i < mol.getBondCount(); ++i) {
            IBond bond = mol.getBond(i);
            int n = (Integer)idxs.get(bond.getBegin());
            bondedValence[n] = bondedValence[n] + bond.getOrder().numeric();
            int n2 = (Integer)idxs.get(bond.getEnd());
            bondedValence[n2] = bondedValence[n2] + bond.getOrder().numeric();
        }
        block13: for (i = 0; i < mol.getAtomCount(); ++i) {
            IAtom atom = mol.getAtom(i);
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
            switch (atom.getAtomicNumber()) {
                case 5: {
                    if (bondedValence[i] > 3) continue block13;
                    atom.setImplicitHydrogenCount(Integer.valueOf(3 - bondedValence[i]));
                    continue block13;
                }
                case 6: {
                    if (bondedValence[i] > 4) continue block13;
                    atom.setImplicitHydrogenCount(Integer.valueOf(4 - bondedValence[i]));
                    continue block13;
                }
                case 7: 
                case 15: {
                    if (bondedValence[i] <= 3) {
                        atom.setImplicitHydrogenCount(Integer.valueOf(3 - bondedValence[i]));
                        continue block13;
                    }
                    if (bondedValence[i] > 5) continue block13;
                    atom.setImplicitHydrogenCount(Integer.valueOf(5 - bondedValence[i]));
                    continue block13;
                }
                case 8: {
                    if (bondedValence[i] > 2) continue block13;
                    atom.setImplicitHydrogenCount(Integer.valueOf(2 - bondedValence[i]));
                    continue block13;
                }
                case 16: {
                    if (bondedValence[i] <= 2) {
                        atom.setImplicitHydrogenCount(Integer.valueOf(2 - bondedValence[i]));
                        continue block13;
                    }
                    if (bondedValence[i] <= 4) {
                        atom.setImplicitHydrogenCount(Integer.valueOf(4 - bondedValence[i]));
                        continue block13;
                    }
                    if (bondedValence[i] > 6) continue block13;
                    atom.setImplicitHydrogenCount(Integer.valueOf(6 - bondedValence[i]));
                    continue block13;
                }
                case 9: 
                case 17: 
                case 35: 
                case 53: {
                    if (bondedValence[i] > 1) continue block13;
                    atom.setImplicitHydrogenCount(Integer.valueOf(1 - bondedValence[i]));
                    continue block13;
                }
                default: {
                    atom.setImplicitHydrogenCount(Integer.valueOf(0));
                }
            }
        }
        String smi = null;
        try {
            smi = this.smigen.create(mol, ordering);
        }
        finally {
            for (int i3 = 0; i3 < mol.getAtomCount(); ++i3) {
                mol.getAtom(i3).setImplicitHydrogenCount(hcntBackup[i3]);
            }
        }
        return smi;
    }

    Map.Entry<String, Point2d[]> createEntry(IAtomContainer container) {
        try {
            int n = container.getAtomCount();
            int[] ordering = new int[n];
            String smiles = this.cansmi(container, ordering);
            Point2d[] points = new Point2d[n];
            for (int i = 0; i < n; ++i) {
                Point2d point = container.getAtom(i).getPoint2d();
                if (point == null) {
                    this.logger.warn((Object)"Atom at index ", new Object[]{i, " did not have coordinates."});
                    return null;
                }
                points[ordering[i]] = point;
            }
            return new AbstractMap.SimpleEntry<String, Point2d[]>(smiles, points);
        }
        catch (CDKException e) {
            this.logger.warn((Object)"Could not encode container as SMILES: ", new Object[]{e});
            return null;
        }
    }

    static Map.Entry<String, Point2d[]> decodeEntry(String str) {
        int i = str.indexOf(32);
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        return new AbstractMap.SimpleEntry<String, Point2d[]>(str.substring(0, i), IdentityTemplateLibrary.decodeCoordinates(str.substring(i + 1)));
    }

    static Point2d[] decodeCoordinates(String str) {
        if (str.startsWith("|(")) {
            int end = str.indexOf(41, 2);
            if (end < 0) {
                return new Point2d[0];
            }
            String[] strs = str.substring(2, end).split(";");
            Point2d[] points = new Point2d[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                String coord = strs[i];
                int first = coord.indexOf(44);
                int second = coord.indexOf(44, first + 1);
                String x = coord.substring(0, first);
                String y = coord.substring(first + 1, second);
                if (x.isEmpty()) {
                    x = "0";
                }
                if (y.isEmpty()) {
                    y = "0";
                }
                points[i] = new Point2d(Double.parseDouble(x), Double.parseDouble(y));
            }
            return points;
        }
        String[] strs = str.split(", ");
        Point2d[] points = new Point2d[strs.length / 2];
        for (int i = 0; i < strs.length; i += 2) {
            points[i / 2] = new Point2d(Double.parseDouble(strs[i]), Double.parseDouble(strs[i + 1]));
        }
        return points;
    }

    static String encodeEntry(Map.Entry<String, Point2d[]> entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(entry.getKey());
        sb.append(' ');
        sb.append(IdentityTemplateLibrary.encodeCoordinates(entry.getValue()));
        return sb.toString();
    }

    static String encodeCoordinates(Point2d[] points) {
        DecimalFormat fmt = new DecimalFormat(".##", DecimalFormatSymbols.getInstance(Locale.ROOT));
        StringBuilder sb = new StringBuilder();
        sb.append("|(");
        for (Point2d point : points) {
            if (sb.length() > 2) {
                sb.append(";");
            }
            sb.append(fmt.format(point.x));
            sb.append(',');
            sb.append(fmt.format(point.y));
            sb.append(',');
        }
        sb.append(")|");
        return sb.toString();
    }

    void add(Map.Entry<String, Point2d[]> entry) {
        if (entry != null) {
            this.templateMap.put((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    void add(IAtomContainer container) {
        this.add(this.createEntry(container));
    }

    boolean assignLayout(IAtomContainer container) {
        try {
            int n = container.getAtomCount();
            int[] ordering = new int[n];
            String smiles = this.cansmi(container, ordering);
            Iterator iterator = this.templateMap.get((Object)smiles).iterator();
            if (iterator.hasNext()) {
                Point2d[] points = (Point2d[])iterator.next();
                for (int i = 0; i < n; ++i) {
                    container.getAtom(i).setPoint2d(new Point2d(points[ordering[i]]));
                }
                return true;
            }
        }
        catch (CDKException cDKException) {
            // empty catch block
        }
        return false;
    }

    Collection<Point2d[]> getCoordinates(IAtomContainer mol) {
        try {
            int n = mol.getAtomCount();
            int[] ordering = new int[n];
            String smiles = this.cansmi(mol, ordering);
            Collection coordSet = this.templateMap.get((Object)smiles);
            ArrayList<Point2d[]> orderedCoordSet = new ArrayList<Point2d[]>(coordSet.size());
            for (Point2d[] coords : coordSet) {
                Point2d[] orderedCoords = new Point2d[coords.length];
                for (int i = 0; i < n; ++i) {
                    orderedCoords[i] = new Point2d(coords[ordering[i]]);
                }
                orderedCoordSet.add(orderedCoords);
            }
            return Collections.unmodifiableList(orderedCoordSet);
        }
        catch (CDKException e) {
            return Collections.emptyList();
        }
    }

    static IdentityTemplateLibrary empty() {
        return new IdentityTemplateLibrary();
    }

    static IdentityTemplateLibrary loadFromResource(String resource) {
        InputStream in = IdentityTemplateLibrary.class.getResourceAsStream(resource);
        try {
            IdentityTemplateLibrary identityTemplateLibrary = IdentityTemplateLibrary.load(in);
            return identityTemplateLibrary;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not load template library from resource " + resource, e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static IdentityTemplateLibrary load(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = null;
        IdentityTemplateLibrary library = new IdentityTemplateLibrary();
        while ((line = br.readLine()) != null) {
            if (line.charAt(0) == '#') continue;
            library.add(IdentityTemplateLibrary.decodeEntry(line));
        }
        return library;
    }

    static Point2d[] reorderCoords(Point2d[] coords, int[] order) {
        Point2d[] neworder = new Point2d[coords.length];
        for (int i = 0; i < order.length; ++i) {
            neworder[order[i]] = coords[i];
        }
        return neworder;
    }

    void update(IChemObjectBuilder bldr) {
        SmilesParser smipar = new SmilesParser(bldr);
        LinkedListMultimap updated = LinkedListMultimap.create();
        for (Map.Entry e : this.templateMap.asMap().entrySet()) {
            try {
                IAtomContainer mol = smipar.parseSmiles((String)e.getKey());
                int[] order = new int[mol.getAtomCount()];
                String key = this.cansmi(mol, order);
                for (Point2d[] coords : (Collection)e.getValue()) {
                    updated.put((Object)key, (Object)IdentityTemplateLibrary.reorderCoords(coords, order));
                }
            }
            catch (CDKException ex) {
                System.err.println((String)e.getKey() + " could not be updated: " + ex.getMessage());
            }
        }
        this.templateMap.clear();
        this.templateMap.putAll((Multimap)updated);
    }

    void store(OutputStream out) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry e : this.templateMap.entries()) {
            bw.write(IdentityTemplateLibrary.encodeEntry(e));
            bw.write(10);
        }
        bw.close();
    }
}

