/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.depict.Depiction;
import org.openscience.cdk.depict.DepictionGenerator;
import org.openscience.cdk.depict.Dimensions;
import org.openscience.cdk.depict.FreeHepWrapper;
import org.openscience.cdk.depict.SvgDrawVisitor;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.visitor.AWTDrawVisitor;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

final class MolGridDepiction
extends Depiction {
    private final RendererModel model;
    private final Dimensions dimensions;
    private final int nCol;
    private final int nRow;
    private final List<Bounds> elements;

    public MolGridDepiction(RendererModel model, List<Bounds> molecules, List<Bounds> titles, Dimensions dimensions, int nRow, int nCol) {
        super(model);
        this.model = model;
        this.dimensions = dimensions;
        this.elements = new ArrayList<Bounds>();
        if (titles.isEmpty()) {
            this.elements.addAll(molecules);
        } else {
            int toIndex;
            int fromIndex;
            assert (molecules.size() == titles.size());
            for (int r = 0; r < nRow && (fromIndex = r * nCol) < (toIndex = Math.min(molecules.size(), (r + 1) * nCol)); ++r) {
                List<Bounds> molsublist = molecules.subList(fromIndex, toIndex);
                while (molsublist.size() < nCol) {
                    molsublist.add(new Bounds());
                }
                this.elements.addAll(molsublist);
                this.elements.addAll(titles.subList(fromIndex, toIndex));
            }
            nRow *= 2;
        }
        this.nCol = nCol;
        this.nRow = nRow;
    }

    @Override
    public BufferedImage toImg() {
        double margin = this.getMarginValue(DepictionGenerator.DEFAULT_PX_MARGIN);
        double padding = this.getPaddingValue(2.0 * margin);
        double scale = (Double)this.model.get(BasicSceneGenerator.Scale.class);
        double zoom = (Double)this.model.get(BasicSceneGenerator.ZoomFactor.class);
        double[] yOffset = new double[this.nRow + 1];
        double[] xOffset = new double[this.nCol + 1];
        Dimensions required = Dimensions.ofGrid(this.elements, yOffset, xOffset).scale(scale * zoom);
        Dimensions total = this.calcTotalDimensions(margin, padding, required, null);
        double fitting = this.calcFitting(margin, padding, required, null);
        BufferedImage img = new BufferedImage((int)Math.ceil(total.w), (int)Math.ceil(total.h), 6);
        Graphics2D g2 = img.createGraphics();
        AWTDrawVisitor visitor = AWTDrawVisitor.forVectorGraphics((Graphics2D)g2);
        visitor.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        visitor.visit((IRenderingElement)new RectangleElement(0.0, (double)(-((int)Math.ceil(total.h))), (double)((int)Math.ceil(total.w)), (double)((int)Math.ceil(total.h)), true, (Color)this.model.get(BasicSceneGenerator.BackgroundColor.class)));
        double rescale = zoom * fitting * scale;
        double xBase = margin + (total.w - 2.0 * margin - (double)(this.nCol - 1) * padding - rescale * xOffset[this.nCol]) / 2.0;
        double yBase = margin + (total.h - 2.0 * margin - (double)(this.nRow - 1) * padding - rescale * yOffset[this.nRow]) / 2.0;
        for (int i = 0; i < this.elements.size(); ++i) {
            int row = i / this.nCol;
            int col = i % this.nCol;
            Bounds bounds = this.elements.get(i);
            if (bounds.isEmpty()) continue;
            double x = xBase + (double)col * padding + rescale * xOffset[col];
            double y = yBase + (double)row * padding + rescale * yOffset[row];
            double w = rescale * (xOffset[col + 1] - xOffset[col]);
            double h = rescale * (yOffset[row + 1] - yOffset[row]);
            this.draw((IDrawVisitor)visitor, zoom, bounds, this.rect(x, y, w, h));
        }
        g2.dispose();
        return img;
    }

    private double calcFitting(double margin, double padding, Dimensions required, String fmt) {
        if (this.dimensions == Dimensions.AUTOMATIC) {
            return 1.0;
        }
        Dimensions targetDim = this.dimensions;
        if ("pdf".equals(fmt) || "ps".equals(fmt) || "eps".equals(fmt)) {
            targetDim = targetDim.scale(2.83464566751);
        }
        targetDim = targetDim.add(-2.0 * margin, -2.0 * margin).add(-((double)(this.nCol - 1) * padding), -((double)(this.nRow - 1) * padding));
        double resize = Math.min(targetDim.w / required.w, targetDim.h / required.h);
        if (resize > 1.0 && !((Boolean)this.model.get(BasicSceneGenerator.FitToScreen.class)).booleanValue()) {
            resize = 1.0;
        }
        return resize;
    }

    private Dimensions calcTotalDimensions(double margin, double padding, Dimensions required, String fmt) {
        if (this.dimensions == Dimensions.AUTOMATIC) {
            return required.add(2.0 * margin, 2.0 * margin).add((double)(this.nCol - 1) * padding, (double)(this.nRow - 1) * padding);
        }
        if ("pdf".equals(fmt) || "ps".equals(fmt) || "eps".equals(fmt)) {
            return this.dimensions.scale(2.83464566751);
        }
        return this.dimensions;
    }

    @Override
    String toVecStr(String fmt, String units) {
        SvgDrawVisitor visitor;
        double margin = this.getMarginValue(units.equals("mm") ? DepictionGenerator.DEFAULT_MM_MARGIN : DepictionGenerator.DEFAULT_PX_MARGIN);
        double padding = this.getPaddingValue(2.0 * margin);
        double scale = (Double)this.model.get(BasicSceneGenerator.Scale.class);
        double zoom = (Double)this.model.get(BasicSceneGenerator.ZoomFactor.class);
        if (units.equals("mm")) {
            zoom *= this.rescaleForBondLength(5.08);
        }
        if (fmt.equals("pdf") || fmt.equals("ps") || fmt.equals("eps")) {
            zoom *= 2.83464566751;
            margin *= 2.83464566751;
            padding *= 2.83464566751;
        }
        double[] yOffset = new double[this.nRow + 1];
        double[] xOffset = new double[this.nCol + 1];
        Dimensions required = Dimensions.ofGrid(this.elements, yOffset, xOffset).scale(zoom * scale);
        Dimensions total = this.calcTotalDimensions(margin, padding, required, fmt);
        double fitting = this.calcFitting(margin, padding, required, fmt);
        FreeHepWrapper wrapper = null;
        if (!fmt.equals("svg")) {
            wrapper = new FreeHepWrapper(fmt, total.w, total.h);
        }
        SvgDrawVisitor svgDrawVisitor = visitor = fmt.equals("svg") ? new SvgDrawVisitor(total.w, total.h, units) : AWTDrawVisitor.forVectorGraphics((Graphics2D)wrapper.g2);
        if (fmt.equals("svg")) {
            this.svgPrevisit(fmt, scale * zoom * fitting, visitor, this.elements);
        } else {
            ((AWTDrawVisitor)visitor).setRounding(false);
        }
        visitor.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        visitor.visit((IRenderingElement)new RectangleElement(0.0, (double)(-((int)Math.ceil(total.h))), (double)((int)Math.ceil(total.w)), (double)((int)Math.ceil(total.h)), true, (Color)this.model.get(BasicSceneGenerator.BackgroundColor.class)));
        double rescale = zoom * fitting * scale;
        double xBase = margin + (total.w - 2.0 * margin - (double)(this.nCol - 1) * padding - rescale * xOffset[this.nCol]) / 2.0;
        double yBase = margin + (total.h - 2.0 * margin - (double)(this.nRow - 1) * padding - rescale * yOffset[this.nRow]) / 2.0;
        for (int i = 0; i < this.elements.size(); ++i) {
            int row = i / this.nCol;
            int col = i % this.nCol;
            double x = xBase + (double)col * padding + rescale * xOffset[col];
            double y = yBase + (double)row * padding + rescale * yOffset[row];
            double w = rescale * (xOffset[col + 1] - xOffset[col]);
            double h = rescale * (yOffset[row + 1] - yOffset[row]);
            this.draw(visitor, zoom, this.elements.get(i), this.rect(x, y, w, h));
        }
        if (wrapper != null) {
            wrapper.dispose();
            return wrapper.toString();
        }
        return ((Object)visitor).toString();
    }

    private Rectangle2D.Double rect(double x, double y, double w, double h) {
        return new Rectangle2D.Double(x, y, w, h);
    }
}

