/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MDLRXNWriter
extends DefaultChemObjectWriter {
    private BufferedWriter writer;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLRXNWriter.class);
    private int reactionNumber;
    public Map<String, Object> rdFields = null;

    public MDLRXNWriter(Writer out) {
        try {
            this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reactionNumber = 1;
    }

    public MDLRXNWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public MDLRXNWriter() {
        this(new StringWriter());
    }

    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    public void setRdFields(Map<String, Object> map) {
        this.rdFields = map;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IReaction.class.equals(classObject)) {
            return true;
        }
        if (IReactionSet.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IReaction.class.equals(anInterface)) {
                return true;
            }
            if (!IReactionSet.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        if (object instanceof IReactionSet) {
            this.writeReactionSet((IReactionSet)object);
        } else if (object instanceof IReaction) {
            this.writeReaction((IReaction)object);
        } else {
            throw new CDKException("Only supported is writing ReactionSet, Reaction objects.");
        }
    }

    private void writeReactionSet(IReactionSet reactions) throws CDKException {
        for (IReaction iReaction : reactions.reactions()) {
            this.writeReaction(iReaction);
        }
    }

    private void writeReaction(IReaction reaction) throws CDKException {
        int reactantCount = reaction.getReactantCount();
        int productCount = reaction.getProductCount();
        if (reactantCount <= 0 || productCount <= 0) {
            throw new CDKException("Either no reactants or no products present.");
        }
        try {
            if (this.reactionNumber == 2) {
                this.writer.write("$$$$");
                this.writer.write(10);
            }
            this.writer.write("$RXN");
            this.writer.write(10);
            String line = (String)reaction.getProperty((Object)"cdk:Title");
            if (line == null) {
                line = "";
            }
            if (line.length() > 80) {
                line = line.substring(0, 80);
            }
            this.writer.write(line);
            this.writer.write(10);
            this.writer.write(10);
            line = (String)reaction.getProperty((Object)"cdk:Remark");
            if (line == null) {
                line = "";
            }
            if (line.length() > 80) {
                line = line.substring(0, 80);
            }
            this.writer.write(line);
            this.writer.write(10);
            line = "";
            line = line + this.formatMDLInt(reactantCount, 3);
            line = line + this.formatMDLInt(productCount, 3);
            this.writer.write(line);
            this.writer.write(10);
            int i = 0;
            for (IMapping mapping : reaction.mappings()) {
                Iterator it = mapping.relatedChemObjects().iterator();
                ((IChemObject)it.next()).setProperty((Object)"cdk:AtomAtomMapping", (Object)(i + 1));
                ((IChemObject)it.next()).setProperty((Object)"cdk:AtomAtomMapping", (Object)(i + 1));
                ++i;
            }
            this.writeAtomContainerSet(reaction.getReactants());
            this.writeAtomContainerSet(reaction.getProducts());
            if (this.rdFields != null) {
                Set<String> set = this.rdFields.keySet();
                for (String element : set) {
                    this.writer.write("> <" + element + ">");
                    this.writer.write(10);
                    this.writer.write(this.rdFields.get(element).toString());
                    this.writer.write(10);
                    this.writer.write(10);
                }
            }
            if (this.reactionNumber != 1) {
                this.writer.write("$$$$");
                this.writer.write(10);
            }
            ++this.reactionNumber;
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
            logger.debug((Object)ex);
            throw new CDKException("Exception while writing MDL file: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void writeAtomContainerSet(IAtomContainerSet som) throws IOException, CDKException {
        for (int i = 0; i < som.getAtomContainerCount(); ++i) {
            IAtomContainer mol = som.getAtomContainer(i);
            int j = 0;
            while ((double)j < som.getMultiplier(i)) {
                StringWriter sw = new StringWriter();
                this.writer.write("$MOL");
                this.writer.write(10);
                MDLV2000Writer mdlwriter = null;
                try {
                    mdlwriter = new MDLV2000Writer(sw);
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage());
                    logger.debug((Object)ex);
                    throw new CDKException("Exception while creating MDLWriter: " + ex.getMessage(), (Throwable)ex);
                }
                mdlwriter.write((IChemObject)mol);
                mdlwriter.close();
                this.writer.write(sw.toString());
                ++j;
            }
        }
    }

    private String formatMDLInt(int i, int l) {
        String s = "";
        String fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setParseIntegerOnly(true);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(l);
        nf.setGroupingUsed(false);
        s = nf.format(i);
        l -= s.length();
        for (int f = 0; f < l; ++f) {
            fs = fs + " ";
        }
        fs = fs + s;
        return fs;
    }
}

