/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.treewalk;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.openrewrite.jgit.annotations.Nullable;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.attributes.Attribute;
import org.openrewrite.jgit.attributes.Attributes;
import org.openrewrite.jgit.attributes.AttributesHandler;
import org.openrewrite.jgit.attributes.AttributesNodeProvider;
import org.openrewrite.jgit.attributes.AttributesProvider;
import org.openrewrite.jgit.attributes.FilterCommandRegistry;
import org.openrewrite.jgit.errors.CorruptObjectException;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.errors.StopWalkException;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.Config;
import org.openrewrite.jgit.lib.CoreConfig;
import org.openrewrite.jgit.lib.FileMode;
import org.openrewrite.jgit.lib.MutableObjectId;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectReader;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.revwalk.RevTree;
import org.openrewrite.jgit.treewalk.AbstractTreeIterator;
import org.openrewrite.jgit.treewalk.CanonicalTreeParser;
import org.openrewrite.jgit.treewalk.WorkingTreeOptions;
import org.openrewrite.jgit.treewalk.filter.PathFilter;
import org.openrewrite.jgit.treewalk.filter.TreeFilter;
import org.openrewrite.jgit.util.QuotedString;
import org.openrewrite.jgit.util.RawParseUtils;
import org.openrewrite.jgit.util.io.EolStreamTypeUtil;

public class TreeWalk
implements AutoCloseable,
AttributesProvider {
    private static final AbstractTreeIterator[] NO_TREES = new AbstractTreeIterator[0];
    private OperationType operationType = OperationType.CHECKOUT_OP;
    private Map<String, String> filterCommandsByNameDotType = new HashMap<String, String>();
    private final ObjectReader reader;
    private final boolean closeReader;
    private final MutableObjectId idBuffer = new MutableObjectId();
    private TreeFilter filter;
    AbstractTreeIterator[] trees;
    private boolean recursive;
    private boolean postOrderTraversal;
    int depth;
    private boolean advance;
    private boolean postChildren;
    private AttributesNodeProvider attributesNodeProvider;
    AbstractTreeIterator currentHead;
    private Attributes attrs = null;
    private AttributesHandler attributesHandler;
    private Config config;
    private Set<String> filterCommands;

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public static TreeWalk forPath(ObjectReader reader, String path, AnyObjectId ... trees) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return TreeWalk.forPath(null, reader, path, trees);
    }

    public static TreeWalk forPath(@Nullable Repository repo, ObjectReader reader, String path, AnyObjectId ... trees) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        TreeWalk tw = new TreeWalk(repo, reader);
        PathFilter f = PathFilter.create(path);
        tw.setFilter(f);
        tw.reset(trees);
        tw.setRecursive(false);
        while (tw.next()) {
            if (f.isDone(tw)) {
                return tw;
            }
            if (!tw.isSubtree()) continue;
            tw.enterSubtree();
        }
        return null;
    }

    public static TreeWalk forPath(Repository db, String path, AnyObjectId ... trees) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        try (ObjectReader reader = db.newObjectReader();){
            TreeWalk treeWalk = TreeWalk.forPath(db, reader, path, trees);
            return treeWalk;
        }
    }

    public static TreeWalk forPath(Repository db, String path, RevTree tree) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return TreeWalk.forPath(db, path, (AnyObjectId[])new ObjectId[]{tree});
    }

    public TreeWalk(Repository repo) {
        this(repo, repo.newObjectReader(), true);
    }

    public TreeWalk(@Nullable Repository repo, ObjectReader or) {
        this(repo, or, false);
    }

    public TreeWalk(ObjectReader or) {
        this(null, or, false);
    }

    private TreeWalk(@Nullable Repository repo, ObjectReader or, boolean closeReader) {
        if (repo != null) {
            this.config = repo.getConfig();
            this.attributesNodeProvider = repo.createAttributesNodeProvider();
            this.filterCommands = FilterCommandRegistry.getRegisteredFilterCommands();
        } else {
            this.config = null;
            this.attributesNodeProvider = null;
        }
        this.reader = or;
        this.filter = TreeFilter.ALL;
        this.trees = NO_TREES;
        this.closeReader = closeReader;
    }

    public ObjectReader getObjectReader() {
        return this.reader;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    @Override
    public void close() {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public TreeFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TreeFilter newFilter) {
        this.filter = newFilter != null ? newFilter : TreeFilter.ALL;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean b) {
        this.recursive = b;
    }

    public boolean isPostOrderTraversal() {
        return this.postOrderTraversal;
    }

    public void setPostOrderTraversal(boolean b) {
        this.postOrderTraversal = b;
    }

    public void setAttributesNodeProvider(AttributesNodeProvider provider) {
        this.attributesNodeProvider = provider;
    }

    public AttributesNodeProvider getAttributesNodeProvider() {
        return this.attributesNodeProvider;
    }

    @Override
    public Attributes getAttributes() {
        if (this.attrs != null) {
            return this.attrs;
        }
        if (this.attributesNodeProvider == null) {
            throw new IllegalStateException("The tree walk should have one AttributesNodeProvider set in order to compute the git attributes.");
        }
        try {
            if (this.attributesHandler == null) {
                this.attributesHandler = new AttributesHandler(this);
            }
            this.attrs = this.attributesHandler.getAttributes();
            return this.attrs;
        }
        catch (IOException e) {
            throw new JGitInternalException("Error while parsing attributes", e);
        }
    }

    @Nullable
    public CoreConfig.EolStreamType getEolStreamType(OperationType opType) {
        if (this.attributesNodeProvider == null || this.config == null) {
            return null;
        }
        return EolStreamTypeUtil.detectStreamType(opType != null ? opType : this.operationType, this.config.get(WorkingTreeOptions.KEY), this.getAttributes());
    }

    public void reset() {
        this.attrs = null;
        this.attributesHandler = null;
        this.trees = NO_TREES;
        this.advance = false;
        this.depth = 0;
    }

    public void reset(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        if (this.trees.length == 1) {
            AbstractTreeIterator o = this.trees[0];
            while (o.parent != null) {
                o = o.parent;
            }
            if (o instanceof CanonicalTreeParser) {
                o.matches = null;
                o.matchShift = 0;
                ((CanonicalTreeParser)o).reset(this.reader, id);
                this.trees[0] = o;
            } else {
                this.trees[0] = this.parserFor(id);
            }
        } else {
            this.trees = new AbstractTreeIterator[]{this.parserFor(id)};
        }
        this.advance = false;
        this.depth = 0;
        this.attrs = null;
    }

    public void reset(AnyObjectId ... ids) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        int newLen = ids.length;
        int oldLen = this.trees.length;
        AbstractTreeIterator[] r = newLen == oldLen ? this.trees : new AbstractTreeIterator[newLen];
        for (int i = 0; i < newLen; ++i) {
            AbstractTreeIterator o;
            if (i < oldLen) {
                o = this.trees[i];
                while (o.parent != null) {
                    o = o.parent;
                }
                if (o instanceof CanonicalTreeParser && o.pathOffset == 0) {
                    o.matches = null;
                    o.matchShift = 0;
                    ((CanonicalTreeParser)o).reset(this.reader, ids[i]);
                    r[i] = o;
                    continue;
                }
            }
            r[i] = o = this.parserFor(ids[i]);
        }
        this.trees = r;
        this.advance = false;
        this.depth = 0;
        this.attrs = null;
    }

    public int addTree(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return this.addTree(this.parserFor(id));
    }

    public int addTree(AbstractTreeIterator p) {
        int n = this.trees.length;
        AbstractTreeIterator[] newTrees = new AbstractTreeIterator[n + 1];
        System.arraycopy(this.trees, 0, newTrees, 0, n);
        newTrees[n] = p;
        p.matches = null;
        p.matchShift = 0;
        this.trees = newTrees;
        return n;
    }

    public int getTreeCount() {
        return this.trees.length;
    }

    public boolean next() throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        try {
            if (this.advance) {
                this.advance = false;
                this.postChildren = false;
                this.popEntriesEqual();
            }
            while (true) {
                this.attrs = null;
                AbstractTreeIterator t = this.min();
                if (t.eof()) {
                    if (this.depth > 0) {
                        this.exitSubtree();
                        if (this.postOrderTraversal) {
                            this.advance = true;
                            this.postChildren = true;
                            return true;
                        }
                        this.popEntriesEqual();
                        continue;
                    }
                    return false;
                }
                this.currentHead = t;
                if (this.filter.matchFilter(this) == 1) {
                    this.skipEntriesEqual();
                    continue;
                }
                if (!this.recursive || !FileMode.TREE.equals(t.mode)) break;
                this.enterSubtree();
            }
            this.advance = true;
            return true;
        }
        catch (StopWalkException stop) {
            this.stopWalk();
            return false;
        }
    }

    void stopWalk() throws IOException {
        for (AbstractTreeIterator t : this.trees) {
            t.stopWalk();
        }
    }

    public <T extends AbstractTreeIterator> T getTree(int nth, Class<T> clazz) {
        AbstractTreeIterator t = this.trees[nth];
        return (T)(t.matches == this.currentHead ? t : null);
    }

    public int getRawMode(int nth) {
        AbstractTreeIterator t = this.trees[nth];
        return t.matches == this.currentHead ? t.mode : 0;
    }

    public FileMode getFileMode(int nth) {
        return FileMode.fromBits(this.getRawMode(nth));
    }

    public FileMode getFileMode() {
        return FileMode.fromBits(this.currentHead.mode);
    }

    public ObjectId getObjectId(int nth) {
        AbstractTreeIterator t = this.trees[nth];
        return t.matches == this.currentHead ? t.getEntryObjectId() : ObjectId.zeroId();
    }

    public void getObjectId(MutableObjectId out, int nth) {
        AbstractTreeIterator t = this.trees[nth];
        if (t.matches == this.currentHead) {
            t.getEntryObjectId(out);
        } else {
            out.clear();
        }
    }

    public boolean idEqual(int nthA, int nthB) {
        AbstractTreeIterator ch = this.currentHead;
        AbstractTreeIterator a = this.trees[nthA];
        AbstractTreeIterator b = this.trees[nthB];
        if (a.matches != ch && b.matches != ch) {
            return true;
        }
        if (!a.hasId() || !b.hasId()) {
            return false;
        }
        if (a.matches == ch && b.matches == ch) {
            return a.idEqual(b);
        }
        return false;
    }

    public String getNameString() {
        AbstractTreeIterator t = this.currentHead;
        int off = t.pathOffset;
        int end = t.pathLen;
        return RawParseUtils.decode(StandardCharsets.UTF_8, t.path, off, end);
    }

    public String getPathString() {
        return TreeWalk.pathOf(this.currentHead);
    }

    public byte[] getRawPath() {
        AbstractTreeIterator t = this.currentHead;
        int n = t.pathLen;
        byte[] r = new byte[n];
        System.arraycopy(t.path, 0, r, 0, n);
        return r;
    }

    public int getPathLength() {
        return this.currentHead.pathLen;
    }

    public int isPathMatch(byte[] p, int pLen) {
        int ci;
        AbstractTreeIterator t = this.currentHead;
        byte[] c = t.path;
        int cLen = t.pathLen;
        for (ci = 0; ci < cLen && ci < pLen; ++ci) {
            int c_value = (c[ci] & 0xFF) - (p[ci] & 0xFF);
            if (c_value == 0) continue;
            return 1;
        }
        if (ci < cLen) {
            return c[ci] == 47 ? 0 : 1;
        }
        if (ci < pLen) {
            return p[ci] == 47 && FileMode.TREE.equals(t.mode) ? -1 : 1;
        }
        return 0;
    }

    public int isPathPrefix(byte[] p, int pLen) {
        int ci;
        AbstractTreeIterator t = this.currentHead;
        byte[] c = t.path;
        int cLen = t.pathLen;
        for (ci = 0; ci < cLen && ci < pLen; ++ci) {
            int c_value = (c[ci] & 0xFF) - (p[ci] & 0xFF);
            if (c_value == 0) continue;
            return c_value;
        }
        if (ci < cLen) {
            return c[ci] == 47 ? 0 : -1;
        }
        if (ci < pLen) {
            return p[ci] == 47 && FileMode.TREE.equals(t.mode) ? 0 : -1;
        }
        return 0;
    }

    public boolean isPathSuffix(byte[] p, int pLen) {
        AbstractTreeIterator t = this.currentHead;
        byte[] c = t.path;
        int cLen = t.pathLen;
        for (int i = 1; i <= pLen; ++i) {
            if (i > cLen) {
                return false;
            }
            if (c[cLen - i] == p[pLen - i]) continue;
            return false;
        }
        return true;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isSubtree() {
        return FileMode.TREE.equals(this.currentHead.mode);
    }

    public boolean isPostChildren() {
        return this.postChildren && this.isSubtree();
    }

    public void enterSubtree() throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        this.attrs = null;
        AbstractTreeIterator ch = this.currentHead;
        AbstractTreeIterator[] tmp = new AbstractTreeIterator[this.trees.length];
        for (int i = 0; i < this.trees.length; ++i) {
            AbstractTreeIterator t = this.trees[i];
            AbstractTreeIterator n = t.matches == ch && !t.eof() && (FileMode.TREE.equals(t.mode) || FileMode.GITLINK.equals(t.mode) && t.isWorkTree()) ? t.createSubtreeIterator(this.reader, this.idBuffer) : t.createEmptyTreeIterator();
            tmp[i] = n;
        }
        ++this.depth;
        this.advance = false;
        System.arraycopy(tmp, 0, this.trees, 0, this.trees.length);
    }

    AbstractTreeIterator min() throws CorruptObjectException {
        int i = 0;
        AbstractTreeIterator minRef = this.trees[i];
        while (minRef.eof() && ++i < this.trees.length) {
            minRef = this.trees[i];
        }
        if (minRef.eof()) {
            return minRef;
        }
        minRef.matches = minRef;
        while (++i < this.trees.length) {
            AbstractTreeIterator t = this.trees[i];
            if (t.eof()) continue;
            int cmp = t.pathCompare(minRef);
            if (cmp < 0) {
                t.matches = t;
                minRef = t;
                continue;
            }
            if (cmp != 0) continue;
            t.matches = minRef;
        }
        return minRef;
    }

    void popEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        for (AbstractTreeIterator t : this.trees) {
            if (t.matches != ch) continue;
            t.next(1);
            t.matches = null;
        }
    }

    void skipEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        for (AbstractTreeIterator t : this.trees) {
            if (t.matches != ch) continue;
            t.skip();
            t.matches = null;
        }
    }

    void exitSubtree() {
        --this.depth;
        for (int i = 0; i < this.trees.length; ++i) {
            this.trees[i] = this.trees[i].parent;
        }
        AbstractTreeIterator minRef = null;
        for (AbstractTreeIterator t : this.trees) {
            if (t.matches != t || minRef != null && t.pathCompare(minRef) >= 0) continue;
            minRef = t;
        }
        this.currentHead = minRef;
    }

    private CanonicalTreeParser parserFor(AnyObjectId id) throws IncorrectObjectTypeException, IOException {
        CanonicalTreeParser p = new CanonicalTreeParser();
        p.reset(this.reader, id);
        return p;
    }

    static String pathOf(AbstractTreeIterator t) {
        return RawParseUtils.decode(StandardCharsets.UTF_8, t.path, 0, t.pathLen);
    }

    static String pathOf(byte[] buf, int pos, int end) {
        return RawParseUtils.decode(StandardCharsets.UTF_8, buf, pos, end);
    }

    public <T extends AbstractTreeIterator> T getTree(Class<T> type) {
        for (AbstractTreeIterator tree : this.trees) {
            if (!type.isInstance(tree)) continue;
            return (T)((AbstractTreeIterator)type.cast(tree));
        }
        return null;
    }

    public String getFilterCommand(String filterCommandType) throws IOException {
        Attributes attributes = this.getAttributes();
        Attribute f = attributes.get("filter");
        if (f == null) {
            return null;
        }
        String filterValue = f.getValue();
        if (filterValue == null) {
            return null;
        }
        String filterCommand = this.getFilterCommandDefinition(filterValue, filterCommandType);
        if (filterCommand == null) {
            return null;
        }
        return filterCommand.replaceAll("%f", Matcher.quoteReplacement(QuotedString.BOURNE.quote(this.getPathString())));
    }

    private String getFilterCommandDefinition(String filterDriverName, String filterCommandType) {
        String key = filterDriverName + "." + filterCommandType;
        String filterCommand = this.filterCommandsByNameDotType.get(key);
        if (filterCommand != null) {
            return filterCommand;
        }
        filterCommand = this.config.getString("filter", filterDriverName, filterCommandType);
        boolean useBuiltin = this.config.getBoolean("filter", filterDriverName, "useJGitBuiltin", false);
        if (useBuiltin) {
            String builtinFilterCommand = "jgit://builtin/" + filterDriverName + '/' + filterCommandType;
            if (this.filterCommands != null && this.filterCommands.contains(builtinFilterCommand)) {
                filterCommand = builtinFilterCommand;
            }
        }
        if (filterCommand != null) {
            this.filterCommandsByNameDotType.put(key, filterCommand);
        }
        return filterCommand;
    }

    public static enum OperationType {
        CHECKOUT_OP,
        CHECKIN_OP;

    }
}

