/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.sizes;

import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;

@FileStatefulCheck
public class OuterTypeNumberCheck
extends AbstractCheck {
    public static final String MSG_KEY = "maxOuterTypes";
    private int max = 1;
    private int currentDepth;
    private int outerNum;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 15, 154, 157, 199};
    }

    @Override
    public void beginTree(DetailAST ast) {
        this.currentDepth = 0;
        this.outerNum = 0;
    }

    @Override
    public void finishTree(DetailAST ast) {
        if (this.max < this.outerNum) {
            this.log(ast, MSG_KEY, this.outerNum, this.max);
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.currentDepth == 0) {
            ++this.outerNum;
        }
        ++this.currentDepth;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        --this.currentDepth;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

