/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;

public class EncodingDetectingInputStream
extends InputStream {
    private static final Charset WINDOWS_1252 = Charset.forName("Windows-1252");
    private static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    private final InputStream inputStream;
    private @Nullable Charset charset;
    private boolean bomChecked;
    private boolean charsetBomMarked;
    private int prev;
    private int prev2;
    boolean maybeTwoByteSequence = false;
    boolean maybeThreeByteSequence = false;
    boolean maybeFourByteSequence = false;

    public EncodingDetectingInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public EncodingDetectingInputStream(InputStream inputStream, @Nullable Charset charset) {
        this.inputStream = inputStream;
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset == null ? StandardCharsets.UTF_8 : this.charset;
    }

    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @Override
    public int read() throws IOException {
        int read;
        if (!this.bomChecked) {
            if (this.charset == null || this.charset == StandardCharsets.UTF_8) {
                read = this.checkAndSkipUtf8Bom();
                if (this.charsetBomMarked) {
                    read = this.inputStream.read();
                }
            } else {
                this.bomChecked = true;
                read = this.inputStream.read();
            }
        } else {
            read = this.inputStream.read();
        }
        if (read == -1) {
            if (this.charset == null) {
                this.charset = this.maybeTwoByteSequence || this.maybeThreeByteSequence || this.maybeFourByteSequence ? WINDOWS_1252 : StandardCharsets.UTF_8;
            }
        } else if (this.charset == null) {
            this.guessCharset(read);
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.charset == null) {
            return super.read(b, off, len);
        }
        if (this.charset == StandardCharsets.UTF_8 && !this.bomChecked) {
            int read = this.checkAndSkipUtf8Bom();
            if (read == -1) {
                return -1;
            }
            if (!this.charsetBomMarked) {
                b[off++] = (byte)read;
            }
            return (read = this.inputStream.read(b, off, len - 1)) == -1 ? (this.charsetBomMarked ? -1 : 1) : (this.charsetBomMarked ? 0 : 1) + read;
        }
        return this.inputStream.read(b, off, len);
    }

    private void guessCharset(int aByte) {
        if (this.utf8TwoByteSequence(aByte)) {
            this.maybeTwoByteSequence = true;
        } else if (this.utf8ThreeByteSequence(aByte)) {
            this.maybeThreeByteSequence = true;
        } else if (this.utf8FourByteSequence(aByte)) {
            this.maybeFourByteSequence = true;
        } else if (this.maybeTwoByteSequence) {
            if (!this.utf8SequenceEnd(aByte)) {
                this.charset = WINDOWS_1252;
            } else {
                this.maybeTwoByteSequence = false;
                this.prev = -1;
            }
        } else if (this.maybeThreeByteSequence) {
            if (!this.utf8SequenceEnd(aByte)) {
                this.charset = WINDOWS_1252;
            }
            if (this.utf8SequenceEnd(this.prev) && this.utf8SequenceEnd(aByte)) {
                this.maybeThreeByteSequence = false;
                this.prev = -1;
            }
        } else if (this.maybeFourByteSequence) {
            if (this.utf8SequenceEnd(this.prev2) && this.utf8SequenceEnd(this.prev) && !this.utf8SequenceEnd(aByte) || this.utf8SequenceEnd(this.prev) && !this.utf8SequenceEnd(aByte) || !this.utf8SequenceEnd(aByte)) {
                this.charset = WINDOWS_1252;
            }
            if (this.utf8SequenceEnd(this.prev2) && this.utf8SequenceEnd(this.prev) && this.utf8SequenceEnd(aByte)) {
                this.maybeFourByteSequence = false;
                this.prev = -1;
            }
        } else if (this.utf8SequenceEnd(aByte)) {
            this.charset = WINDOWS_1252;
        }
        this.prev2 = this.prev;
        this.prev = aByte;
    }

    public String readFully() {
        String string;
        block9: {
            EncodingDetectingInputStream is = this;
            try {
                int n;
                ByteArrayOutputStream bos = new ByteArrayOutputStream(){

                    @Override
                    public synchronized String toString() {
                        return new String(this.buf, 0, this.count, EncodingDetectingInputStream.this.getCharset());
                    }
                };
                byte[] buffer = new byte[4096];
                while ((n = ((InputStream)is).read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, n);
                }
                string = bos.toString();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ((InputStream)is).close();
        }
        return string;
    }

    private int checkAndSkipUtf8Bom() throws IOException {
        this.bomChecked = true;
        int read = this.inputStream.read();
        if ((byte)read != UTF8_BOM[0]) {
            return read;
        }
        read = this.inputStream.read();
        if ((byte)read != UTF8_BOM[1]) {
            return read;
        }
        read = this.inputStream.read();
        if ((byte)read != UTF8_BOM[2]) {
            return read;
        }
        this.charsetBomMarked = true;
        this.charset = StandardCharsets.UTF_8;
        return -2;
    }

    private boolean utf8TwoByteSequence(int b) {
        return 192 <= b && b <= 223;
    }

    private boolean utf8ThreeByteSequence(int b) {
        return 224 <= b && b <= 239;
    }

    private boolean utf8FourByteSequence(int b) {
        return 240 <= b && b <= 247;
    }

    private boolean utf8SequenceEnd(int b) {
        return 128 <= b && b <= 191;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.inputStream.close();
        }
    }
}

