/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public class EndOfLineAtEndOfFile
extends Recipe {
    @Override
    public String getDisplayName() {
        return "End of Line @ End of File (EOL @ EOF)";
    }

    @Override
    public String getDescription() {
        return "Ensure that the file ends with the newline character.\n\n*Note*: If this recipe modifies a file, it converts the file into plain text. As such, this recipe should be run after any recipe that modifies the language-specific LST.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                PlainText plainText = PlainTextParser.convert(sourceFile);
                boolean whitespaceContainsCRLF = plainText.getText().contains("\r\n");
                if (!plainText.getText().endsWith("\n")) {
                    if (whitespaceContainsCRLF) {
                        return plainText.withText(plainText.getText() + "\r\n");
                    }
                    return plainText.withText(plainText.getText() + '\n');
                }
                return sourceFile;
            }
        };
    }
}

