/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.oldgroupids;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvFactory;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.java.dependencies.oldgroupids.DefinitionMigration;
import org.openrewrite.java.dependencies.oldgroupids.Definitions;
import org.openrewrite.java.dependencies.oldgroupids.Migration;
import org.openrewrite.java.dependencies.oldgroupids.ProposedMigration;
import org.openrewrite.java.dependencies.oldgroupids.UnofficialDefinitions;

public class ParseDefinitionMigrations {
    public static void main(String[] args) throws IOException {
        File csv;
        File repo;
        if (args.length != 2) {
            System.err.println("Usage: ParseDefinitionMigrations <oga-maven-plugin-repo> <migrations-csv>");
            System.exit(1);
        }
        if (!(repo = new File(args[0])).isDirectory() || !repo.canRead()) {
            System.err.println("oga-maven-plugin repo " + repo + " not readable");
            System.exit(1);
        }
        if (!(csv = new File(args[1])).createNewFile() && !csv.canWrite()) {
            System.err.println("CSV " + csv + " not writable");
            System.exit(1);
        }
        ParseDefinitionMigrations.parseDefinitionMigrations(repo, csv);
    }

    static void parseDefinitionMigrations(File repo, File csv) throws IOException {
        ObjectMapper objectMapper = ParseDefinitionMigrations.getObjectMapper();
        Path uc = repo.toPath().resolve("uc");
        File official = uc.resolve("og-definitions.json").toFile();
        File unofficial = uc.resolve("og-unofficial-definitions.json").toFile();
        List<DefinitionMigration> definitions = ((Definitions)objectMapper.readValue(official, Definitions.class)).getMigration();
        List<ProposedMigration> proposed = ((UnofficialDefinitions)objectMapper.readValue(unofficial, UnofficialDefinitions.class)).getMigration();
        ArrayList<Migration> migrations = new ArrayList<Migration>(definitions.size() + proposed.size());
        for (DefinitionMigration d : definitions) {
            migrations.add(ParseDefinitionMigrations.getMigration(d.getOldGav(), d.getNewGav(), d.getContext()));
        }
        for (ProposedMigration p : proposed) {
            migrations.add(ParseDefinitionMigrations.getMigration(p.getOldGav(), p.getProposal().get(0), p.getContext()));
        }
        ObjectWriter objectWriter = ParseDefinitionMigrations.getObjectWriter();
        objectWriter.writeValue(csv, migrations);
    }

    private static Migration getMigration(String oldGav1, String newGav1, String context) {
        String[] oldGav = oldGav1.split(":");
        String[] newGav = newGav1.split(":");
        return new Migration(oldGav[0], oldGav.length > 1 ? oldGav[1] : null, newGav[0], newGav.length > 1 ? newGav[1] : null, context);
    }

    private static ObjectMapper getObjectMapper() {
        return new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule((Module)new JavaTimeModule());
    }

    private static ObjectWriter getObjectWriter() {
        CsvFactory factory = new CsvFactory();
        factory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        CsvMapper csvMapper = (CsvMapper)((CsvMapper.Builder)CsvMapper.builder((CsvFactory)factory).disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).build();
        return csvMapper.writer((FormatSchema)csvMapper.schemaFor(Migration.class));
    }
}

