/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class SetupNodeUpgradeNodeVersion
extends Recipe {
    @Option(displayName="Minimum major Node.js version (defaults to 24)", example="24", required=false)
    private final @Nullable Integer minimumNodeMajorVersion;

    public String getDisplayName() {
        return "Upgrade `actions/setup-node` `node-version`";
    }

    public String getDescription() {
        return "Update the Node.js version used by `actions/setup-node` if it is below the expected version number.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("github", "nodejs", "deprecation"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new UpgradeNodeVersionVisitor(this.minimumNodeMajorVersion == null ? 24 : this.minimumNodeMajorVersion));
    }

    @Generated
    public SetupNodeUpgradeNodeVersion(@Nullable Integer minimumNodeMajorVersion) {
        this.minimumNodeMajorVersion = minimumNodeMajorVersion;
    }

    @Generated
    public @Nullable Integer getMinimumNodeMajorVersion() {
        return this.minimumNodeMajorVersion;
    }

    @Generated
    public String toString() {
        return "SetupNodeUpgradeNodeVersion(minimumNodeMajorVersion=" + this.getMinimumNodeMajorVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetupNodeUpgradeNodeVersion)) {
            return false;
        }
        SetupNodeUpgradeNodeVersion other = (SetupNodeUpgradeNodeVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$minimumNodeMajorVersion = this.getMinimumNodeMajorVersion();
        Integer other$minimumNodeMajorVersion = other.getMinimumNodeMajorVersion();
        return !(this$minimumNodeMajorVersion == null ? other$minimumNodeMajorVersion != null : !((Object)this$minimumNodeMajorVersion).equals(other$minimumNodeMajorVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetupNodeUpgradeNodeVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minimumNodeMajorVersion = this.getMinimumNodeMajorVersion();
        result = result * 59 + ($minimumNodeMajorVersion == null ? 43 : ((Object)$minimumNodeMajorVersion).hashCode());
        return result;
    }

    private static class UpgradeNodeVersionVisitor
    extends YamlVisitor<ExecutionContext> {
        private static final JsonPathMatcher nodeVersion = new JsonPathMatcher("..steps[?(@.uses =~ 'actions/setup-node@v*.*')].with.node-version");
        private static final Pattern nodeVersionPattern = Pattern.compile("([0-9]+)(\\.[0-9]+)*([-+].*)?");
        private final int minimumNodeMajorVersion;

        public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            int currentMajorVersion;
            if (!nodeVersion.matches(this.getCursor())) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            Yaml.Scalar currentValue = (Yaml.Scalar)entry.getValue();
            Matcher matcher = nodeVersionPattern.matcher(currentValue.getValue());
            if (!matcher.matches()) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            try {
                currentMajorVersion = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException ex) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            if (currentMajorVersion >= this.minimumNodeMajorVersion) {
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            return super.visitMappingEntry(entry.withValue((Yaml.Block)currentValue.withValue(String.valueOf(this.minimumNodeMajorVersion))), (Object)ctx);
        }

        @Generated
        public UpgradeNodeVersionVisitor(int minimumNodeMajorVersion) {
            this.minimumNodeMajorVersion = minimumNodeMajorVersion;
        }
    }
}

