/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractFromDependenciesMojo;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.DestFileFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

public class CopyDependencyUtil
extends AbstractFromDependenciesMojo {
    protected ArtifactInstaller installer;
    protected ArtifactRepositoryFactory repositoryFactory;
    private Map repositoryLayouts;

    public ArtifactInstaller getInstaller() {
        return this.installer;
    }

    public void setInstaller(ArtifactInstaller installer) {
        this.installer = installer;
    }

    public ArtifactRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(ArtifactRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public Map getRepositoryLayouts() {
        return this.repositoryLayouts;
    }

    public void setRepositoryLayouts(Map repositoryLayouts) {
        this.repositoryLayouts = repositoryLayouts;
    }

    public void execute() throws MojoExecutionException {
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact);
        Set artifacts = dss.getResolvedDependencies();
        if (!this.useRepositoryLayout) {
            Iterator i = artifacts.iterator();
            while (i.hasNext()) {
                this.copyArtifact((Artifact)i.next(), this.stripVersion, this.prependGroupId);
            }
        } else {
            try {
                ArtifactRepository targetRepository = this.repositoryFactory.createDeploymentArtifactRepository("local", this.outputDirectory.toURI().toURL().toExternalForm(), (ArtifactRepositoryLayout)this.repositoryLayouts.get("default"), false);
                Iterator i = artifacts.iterator();
                while (i.hasNext()) {
                    this.installArtifact((Artifact)i.next(), targetRepository);
                }
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Could not create outputDirectory repository", (Exception)e);
            }
        }
        Set skippedArtifacts = dss.getSkippedDependencies();
        for (Artifact artifact : skippedArtifacts) {
            this.getLog().info((CharSequence)(artifact.getFile().getName() + " already exists in destination."));
        }
        if (this.isCopyPom()) {
            this.copyPoms(this.getOutputDirectory(), artifacts, this.stripVersion);
            this.copyPoms(this.getOutputDirectory(), skippedArtifacts, this.stripVersion);
        }
    }

    private void installArtifact(Artifact artifact, ArtifactRepository targetRepository) {
        try {
            if ("pom".equals(artifact.getType())) {
                this.installer.install(artifact.getFile(), artifact, targetRepository);
                this.installBaseSnapshot(artifact, targetRepository);
            } else {
                Artifact pomArtifact;
                this.installer.install(artifact.getFile(), artifact, targetRepository);
                this.installBaseSnapshot(artifact, targetRepository);
                if (this.isCopyPom() && (pomArtifact = this.getResolvedPomArtifact(artifact)).getFile() != null && pomArtifact.getFile().exists()) {
                    this.installer.install(pomArtifact.getFile(), pomArtifact, targetRepository);
                    this.installBaseSnapshot(pomArtifact, targetRepository);
                }
            }
        }
        catch (ArtifactInstallationException e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
    }

    private void installBaseSnapshot(Artifact artifact, ArtifactRepository targetRepository) throws ArtifactInstallationException {
        if (artifact.isSnapshot() && !artifact.getBaseVersion().equals(artifact.getVersion())) {
            Artifact baseArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getScope(), artifact.getType());
            this.installer.install(artifact.getFile(), baseArtifact, targetRepository);
        }
    }

    protected void copyArtifact(Artifact artifact, boolean removeVersion, boolean prependGroupId) throws MojoExecutionException {
        String destFileName = DependencyUtil.getFormattedFileName((Artifact)artifact, (boolean)removeVersion, (boolean)prependGroupId);
        File destDir = DependencyUtil.getFormattedOutputDirectory((boolean)this.useSubDirectoryPerScope, (boolean)this.useSubDirectoryPerType, (boolean)this.useSubDirectoryPerArtifact, (boolean)this.useRepositoryLayout, (boolean)this.stripVersion, (File)this.outputDirectory, (Artifact)artifact);
        File destFile = new File(destDir, destFileName);
        this.copyFile(artifact.getFile(), destFile);
    }

    public void copyPoms(File destDir, Set artifacts, boolean removeVersion) throws MojoExecutionException {
        for (Artifact artifact : artifacts) {
            File pomDestFile;
            Artifact pomArtifact = this.getResolvedPomArtifact(artifact);
            if (pomArtifact.getFile() == null || !pomArtifact.getFile().exists() || (pomDestFile = new File(destDir, DependencyUtil.getFormattedFileName((Artifact)pomArtifact, (boolean)removeVersion, (boolean)this.prependGroupId))).exists()) continue;
            this.copyFile(pomArtifact.getFile(), pomDestFile);
        }
    }

    protected Artifact getResolvedPomArtifact(Artifact artifact) {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        try {
            this.resolver.resolve(pomArtifact, this.remoteRepos, this.getLocal());
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)e.getMessage());
        }
        return pomArtifact;
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new DestFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, this.useSubDirectoryPerArtifact, this.useSubDirectoryPerType, this.useSubDirectoryPerScope, this.useRepositoryLayout, this.stripVersion, this.outputDirectory);
    }

    public void setProject(MavenProject pro) {
        this.project = pro;
    }
}

