/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication.synchro;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.CollectionUtil;
import org.nuiton.util.FileUtil;
import org.nuiton.util.MD5InputStream;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyLabelHelper;
import org.nuiton.wikitty.entities.WikittyLabelImpl;
import org.nuiton.wikitty.publication.AbstractWikittyFileService;
import org.nuiton.wikitty.publication.MimeTypePubHelper;
import org.nuiton.wikitty.publication.PropertiesExtended;
import org.nuiton.wikitty.publication.WikittyFileUtil;
import org.nuiton.wikitty.publication.entities.WikittyPubDataHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubDataImpl;
import org.nuiton.wikitty.publication.entities.WikittyPubTextHelper;
import org.nuiton.wikitty.publication.entities.WikittyPubTextImpl;
import org.nuiton.wikitty.publication.synchro.FileSystemWIkittyId;
import org.nuiton.wikitty.publication.synchro.WikittyPublicationSynchronize;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.TreeNodeResult;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;

public class WikittyPublicationFileSystem
extends AbstractWikittyFileService {
    static final Log log = LogFactory.getLog(WikittyPublicationFileSystem.class);
    protected File homeFile;
    protected boolean recursion;
    protected String label;
    public static String META_CURRENT_LABEL = "current.label";
    public static String META_PREFIX_KEY_VERSION = "version.";
    public static String META_PREFIX_KEY_CHECKSUM = "checksum.";
    public static String META_PREFIX_KEY_ID = "id.";
    public static String PROPERTY_DIRECTORY = ".wp";
    protected MimeTypePubHelper mimeHelper = new MimeTypePubHelper();
    protected List<String> directoryNameBlackList;

    public WikittyPublicationFileSystem(ApplicationConfig app) throws URISyntaxException, IOException {
        String url = app.getOption(WikittyConfigOption.WIKITTY_SERVER_URL.getKey());
        URI uri = new URI(url);
        this.homeFile = new File(uri.getPath());
        if (!this.homeFile.exists()) {
            File cur = FileUtil.getCurrentDirectory();
            this.homeFile = new File(cur.getAbsolutePath());
        }
        this.label = uri.getFragment();
        if (this.label == null) {
            this.label = this.homeFile.getName();
        }
        log.info((Object)("HomeDir:" + this.homeFile + "Label:" + this.label));
        this.recursion = true;
        if (app.getOptions().containsKey(WikittyPublicationSynchronize.IS_RECURSION_OPTION)) {
            this.recursion = app.getOptionAsBoolean(WikittyPublicationSynchronize.IS_RECURSION_OPTION);
        }
        this.directoryNameBlackList = new ArrayList<String>();
        this.directoryNameBlackList.add(".svn");
        this.directoryNameBlackList.add(".git");
    }

    public File getHomeFile() {
        return this.homeFile;
    }

    public void setHomeFile(File homeFile) {
        this.homeFile = homeFile;
    }

    public boolean isRecursion() {
        return this.recursion;
    }

    public void setRecursion(boolean recursion) {
        this.recursion = recursion;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void addWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void removeWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String login(String login, String password) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void logout(String securityToken) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public WikittyEvent clear(String securityToken) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public boolean canWrite(String securityToken, Wikitty wikitty) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public boolean canDelete(String securityToken, String wikittyId) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public boolean canRead(String securityToken, String wikittyId) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public boolean exists(String securityToken, String wikittyId) {
        return this.getAllWikitties().containsKey(wikittyId);
    }

    public boolean isDeleted(String securityToken, String wikittyId) {
        return !this.exists(securityToken, wikittyId);
    }

    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        WikittyEvent result;
        block9: {
            log.info((Object)("Store wikitty: " + wikitties.size() + " isForce" + force));
            result = new WikittyEvent((Object)this);
            try {
                for (Wikitty w : wikitties) {
                    File wikittyFile;
                    String extension;
                    String mime;
                    Object content;
                    String name;
                    log.debug((Object)("Works on : " + w));
                    Set set = WikittyLabelHelper.getLabels((Wikitty)w);
                    String ourDir = "";
                    log.debug((Object)("Sets of labels (isRecur" + this.recursion + " label:" + this.label + ")"));
                    for (String name2 : set) {
                        log.debug((Object)name2);
                        if (!this.recursion && name2.equalsIgnoreCase(this.label)) {
                            ourDir = name2;
                            continue;
                        }
                        if (!this.recursion || !name2.startsWith(this.label)) continue;
                        ourDir = name2;
                    }
                    if ("".equals(ourDir)) {
                        BidiMap location = this.harvestLocalWikitties(this.homeFile, true);
                        FileSystemWIkittyId idSystem = (FileSystemWIkittyId)location.get((Object)w.getId());
                        if (idSystem == null) continue;
                        File wikittyFile2 = new File(idSystem.getPath() + File.separator + idSystem.getFileName());
                        log.debug((Object)("Deleted wikitty id:" + w.getId() + " File:" + wikittyFile2));
                        if (!wikittyFile2.exists()) continue;
                        wikittyFile2.delete();
                        continue;
                    }
                    boolean pathFilecreated = WikittyFileUtil.createFilesFromLabelPath(this.homeFile, ourDir);
                    if (!pathFilecreated) continue;
                    String path = this.homeFile.getCanonicalFile() + File.separator + ourDir.replace(".", File.separator);
                    path = path.replace(File.separator + File.separator, File.separator + ".");
                    File wikittyParenFile = new File(path);
                    File propertieDirectory = new File(path + File.separator + PROPERTY_DIRECTORY);
                    if (!propertieDirectory.exists() || !propertieDirectory.isDirectory()) {
                        propertieDirectory.mkdir();
                    }
                    if (w.hasExtension("WikittyPubData")) {
                        log.debug((Object)"Wikitty has wikittyPubData Ext");
                        name = WikittyPubDataHelper.getName(w);
                        content = WikittyPubDataHelper.getContent(w);
                        mime = WikittyPubDataHelper.getMimeType(w);
                        extension = this.mimeHelper.getExtensionForMime(mime);
                        wikittyFile = new File(path + File.separator + name + "." + extension);
                        wikittyFile.createNewFile();
                        FileUtil.byteToFile((byte[])content, (File)wikittyFile);
                    } else {
                        if (!w.hasExtension("WikittyPubText")) continue;
                        log.debug((Object)"Wikitty has wikittyPubText Ext");
                        name = WikittyPubTextHelper.getName(w);
                        content = WikittyPubTextHelper.getContent(w);
                        mime = WikittyPubTextHelper.getMimeType(w);
                        extension = this.mimeHelper.getExtensionForMime(mime);
                        wikittyFile = new File(path + File.separator + name + "." + extension);
                        wikittyFile.createNewFile();
                        FileUtil.writeString((File)wikittyFile, (String)content);
                    }
                    if (wikittyFile == null) continue;
                    PropertiesExtended metaProperties = WikittyPublicationFileSystem.getWikittyPublicationProperties(wikittyParenFile, WikittyFileUtil.WIKITTY_FILE_META_PROPERTIES_FILE);
                    metaProperties.setProperty(META_CURRENT_LABEL, ourDir);
                    metaProperties.store();
                    this.writeWikittyFileProperties(wikittyFile, w.getId(), w.getVersion());
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Error while store wikitty on FS", (Throwable)e);
            }
        }
        return result;
    }

    public List<String> getAllExtensionIds(String securityToken) {
        LinkedList<String> result = new LinkedList<String>();
        result.add("WikittyPubData");
        result.add("WikittyPubText");
        result.add("WikittyLabel");
        return result;
    }

    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public WikittyExtension restoreExtension(String securityToken, String extensionId) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<Wikitty> restore(String securityToken, List<String> id) {
        ArrayList<Wikitty> result;
        block3: {
            FileSystemWIkittyId localisation = null;
            result = new ArrayList<Wikitty>();
            log.info((Object)("restore wikitty, number: " + id.size()));
            try {
                String labelToDir = WikittyFileUtil.labelToPath(this.label);
                File starts = new File(this.homeFile.getAbsolutePath() + File.separator + labelToDir);
                BidiMap locations = this.harvestLocalWikitties(starts, this.recursion);
                for (String wikid : id) {
                    Object value = locations.get((Object)wikid);
                    if (value == null) continue;
                    localisation = (FileSystemWIkittyId)value;
                    result.add(this.restore(wikid, localisation));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while restoring wikitty located:" + localisation), (Throwable)e);
            }
        }
        return result;
    }

    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        block3: {
            log.info((Object)("Delete called wikitty size:" + ids.size()));
            try {
                BidiMap location = this.harvestLocalWikitties(this.homeFile, true);
                for (String id : ids) {
                    Object value = location.get((Object)id);
                    log.debug((Object)("delete wikitty id: " + id + " corresponding file :" + value));
                    if (value == null) continue;
                    FileSystemWIkittyId localisation = (FileSystemWIkittyId)value;
                    String path = localisation.getPath();
                    String fileName = localisation.getFileName();
                    PropertiesExtended propsProperties = WikittyPublicationFileSystem.getWikittyPublicationProperties(new File(path), WikittyFileUtil.WIKITTY_FILE_META_PROPERTIES_FILE);
                    propsProperties.remove(META_PREFIX_KEY_CHECKSUM + fileName);
                    propsProperties.remove(META_PREFIX_KEY_VERSION + fileName);
                    propsProperties.remove(META_PREFIX_KEY_ID + fileName);
                    propsProperties.store();
                    PropertiesExtended idProperties = WikittyPublicationFileSystem.getWikittyPublicationProperties(new File(path), WikittyFileUtil.WIKITTY_ID_PROPERTIES_FILE);
                    idProperties.remove(id);
                    idProperties.store();
                    File wikittyFile = new File(path + File.separator + fileName);
                    if (!wikittyFile.exists()) continue;
                    wikittyFile.delete();
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Error while deleting wikitty on FS", (Throwable)e);
            }
        }
        WikittyEvent result = new WikittyEvent((Object)this);
        return result;
    }

    @Override
    protected Map<String, Wikitty> getAllWikitties() {
        HashMap<String, Wikitty> wikitties;
        block4: {
            wikitties = new HashMap<String, Wikitty>();
            try {
                String labelToDir = WikittyFileUtil.labelToPath(this.label);
                File starts = new File(this.homeFile.getAbsolutePath() + File.separator + labelToDir);
                if (starts.exists()) {
                    this.harvestNewCheckModificationsAndDeleted(starts, this.label);
                }
                BidiMap map = this.harvestLocalWikitties(starts, true);
                for (Object o : map.keySet()) {
                    String id = (String)o;
                    FileSystemWIkittyId location = (FileSystemWIkittyId)map.get((Object)id);
                    wikitties.put(id, this.restore(id, location));
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Error while search forAllWikitty on FS", (Throwable)e);
            }
        }
        return wikitties;
    }

    public WikittyEvent deleteTree(String securityToken, String treeNodeId) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public TreeNodeResult<String> findTreeNode(String securityToken, String wikittyId, int depth, boolean count, Criteria filter) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void syncSearchEngine(String securityToken) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<File> harvestPropertyDirectory(File starts, boolean recursivly) {
        log.info((Object)("harvest property directory starts:" + starts + "isRecur" + recursivly));
        ArrayList<File> result = new ArrayList<File>();
        for (File child : starts.listFiles()) {
            if (child.isDirectory() && child.getName().equals(PROPERTY_DIRECTORY)) {
                result.add(child);
                continue;
            }
            if (!child.isDirectory() || !recursivly || this.directoryNameBlackList.contains(child.getName())) continue;
            result.addAll(this.harvestPropertyDirectory(child, recursivly));
        }
        return result;
    }

    public BidiMap harvestLocalWikitties(File starts, boolean recursivly) throws IOException {
        DualHashBidiMap result = new DualHashBidiMap();
        log.info((Object)"harvest localWikitty");
        List<File> propertiesDirectory = this.harvestPropertyDirectory(starts, recursivly);
        for (File propsDir : propertiesDirectory) {
            log.debug((Object)("harvest wikitty on " + propertiesDirectory));
            Properties idProps = new Properties();
            File idFile = new File(propsDir.getCanonicalPath() + File.separator + WikittyFileUtil.WIKITTY_ID_PROPERTIES_FILE);
            if (idFile.exists()) {
                idProps.load(new FileReader(idFile));
            }
            Set<Object> ids = idProps.keySet();
            log.debug((Object)"List of file/wikitty");
            for (Object id : ids) {
                String name = idProps.getProperty((String)id);
                String path = propsDir.getParent();
                FileSystemWIkittyId value = new FileSystemWIkittyId(name, path);
                log.debug((Object)("ID:" + id + " fileInformation:" + value));
                result.put(id, (Object)value);
            }
        }
        return result;
    }

    public static PropertiesExtended getWikittyPublicationProperties(File starts, String name) throws IOException {
        log.debug((Object)("getwikittyPublicationProperties :" + name + " on dir:" + starts));
        File propertieDirectory = new File(starts.getCanonicalPath() + File.separator + PROPERTY_DIRECTORY);
        File propertieFile = new File(propertieDirectory.getCanonicalPath() + File.separator + name);
        if (!propertieFile.exists()) {
            propertieFile.createNewFile();
        }
        PropertiesExtended result = new PropertiesExtended(propertieFile);
        return result;
    }

    protected Wikitty restore(String id, FileSystemWIkittyId fileId) throws IOException {
        log.debug((Object)("restore wikitty id:" + id + " file: " + fileId));
        WikittyImpl result = new WikittyImpl(id);
        result.addExtension(WikittyLabelImpl.extensionWikittyLabel);
        String path = fileId.getPath();
        String completeName = fileId.getFileName();
        File fileToTransform = new File(path + File.separator + completeName);
        if (!fileToTransform.exists()) {
            return null;
        }
        String extension = FileUtil.extension((File)fileToTransform, (String[])new String[0]);
        String name = FileUtil.basename((String)completeName, (String[])new String[]{"." + extension});
        String mimeType = this.mimeHelper.getMimeForExtension(extension);
        File wikittyParentDir = new File(path);
        PropertiesExtended props = WikittyPublicationFileSystem.getWikittyPublicationProperties(wikittyParentDir, WikittyFileUtil.WIKITTY_FILE_META_PROPERTIES_FILE);
        WikittyLabelHelper.addLabels((Wikitty)result, (String)props.getProperty(META_CURRENT_LABEL));
        if (this.mimeHelper.isPubTextMime(mimeType)) {
            log.debug((Object)("restore wikitty id:" + id + " file: " + fileId + " pubTextType"));
            result.addExtension(WikittyPubTextImpl.extensionWikittyPubText);
            WikittyPubTextHelper.setName((Wikitty)result, name);
            WikittyPubTextHelper.setMimeType((Wikitty)result, mimeType);
            WikittyPubTextHelper.setContent((Wikitty)result, FileUtil.readAsString((File)fileToTransform));
        } else {
            log.debug((Object)("restore wikitty id:" + id + " file: " + fileId + " pubDataType"));
            result.addExtension(WikittyPubDataImpl.extensionWikittyPubData);
            WikittyPubDataHelper.setName((Wikitty)result, name);
            WikittyPubDataHelper.setMimeType((Wikitty)result, mimeType);
            WikittyPubDataHelper.setContent((Wikitty)result, FileUtil.fileToByte((File)fileToTransform));
        }
        result.setVersion(props.getProperty(META_PREFIX_KEY_VERSION + completeName));
        return result;
    }

    protected void harvestNewCheckModificationsAndDeleted(File starts, String label) throws IOException {
        log.info((Object)("Check for wikitty on disk: new, deleted and modified. Directory:" + starts + " Label:" + label));
        File propertyFile = new File(starts + File.separator + PROPERTY_DIRECTORY);
        if (!propertyFile.exists() || !propertyFile.isDirectory()) {
            propertyFile.mkdir();
        }
        PropertiesExtended ids = WikittyPublicationFileSystem.getWikittyPublicationProperties(starts, WikittyFileUtil.WIKITTY_ID_PROPERTIES_FILE);
        PropertiesExtended meta = WikittyPublicationFileSystem.getWikittyPublicationProperties(starts, WikittyFileUtil.WIKITTY_FILE_META_PROPERTIES_FILE);
        meta.put(META_CURRENT_LABEL, label);
        meta.store();
        ArrayList<String> listChildFileNonDir = new ArrayList<String>();
        for (File child : starts.listFiles()) {
            if (child.isDirectory() && !child.getName().equals(PROPERTY_DIRECTORY)) {
                this.harvestNewCheckModificationsAndDeleted(child, label + WikittyFileUtil.WIKITTY_LABEL_SEPARATOR + child.getName());
                continue;
            }
            if (child.isDirectory()) continue;
            listChildFileNonDir.add(child.getName());
            ArrayList filesWikitty = new ArrayList();
            filesWikitty.addAll(CollectionUtil.toGenericCollection(ids.values(), String.class));
            if (!filesWikitty.contains(child.getName())) {
                this.writeWikittyFileProperties(child, null, null);
                continue;
            }
            this.checkModifications(child);
        }
        ids = WikittyPublicationFileSystem.getWikittyPublicationProperties(starts, WikittyFileUtil.WIKITTY_ID_PROPERTIES_FILE);
        ArrayList filesWikitty = new ArrayList();
        filesWikitty.addAll(CollectionUtil.toGenericCollection(ids.values(), String.class));
        if (filesWikitty.size() != listChildFileNonDir.size()) {
            log.info((Object)"remove wikitty informations for deleted file");
            meta = WikittyPublicationFileSystem.getWikittyPublicationProperties(starts, WikittyFileUtil.WIKITTY_FILE_META_PROPERTIES_FILE);
            filesWikitty.removeAll(listChildFileNonDir);
            for (String fileRemoved : filesWikitty) {
                log.debug((Object)("remove wikitty informations for:" + filesWikitty));
                ids.remove(meta.get(META_PREFIX_KEY_ID + fileRemoved));
                meta.remove(META_PREFIX_KEY_CHECKSUM + fileRemoved);
                meta.remove(META_PREFIX_KEY_VERSION + fileRemoved);
                meta.remove(META_PREFIX_KEY_ID + fileRemoved);
            }
            meta.store();
        }
        ids.store();
    }

    protected void checkModifications(File child) throws IOException {
        log.info((Object)("Check if there was modification on :" + child));
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(child));
        byte[] byt = MD5InputStream.hash((InputStream)input);
        String localMd5 = StringUtil.asHex((byte[])byt);
        PropertiesExtended meta = WikittyPublicationFileSystem.getWikittyPublicationProperties(child.getParentFile(), WikittyFileUtil.WIKITTY_FILE_META_PROPERTIES_FILE);
        String registeredMD5 = meta.getProperty(META_PREFIX_KEY_CHECKSUM + child.getName());
        if (!localMd5.equals(registeredMD5)) {
            String currentVersion = meta.getProperty(META_PREFIX_KEY_VERSION + child.getName());
            meta.setProperty(META_PREFIX_KEY_VERSION + child.getName(), WikittyUtil.incrementMinorRevision((String)currentVersion));
            meta.setProperty(META_PREFIX_KEY_CHECKSUM + child.getName(), localMd5);
        }
        meta.store();
    }

    protected void writeWikittyFileProperties(File towrite, String wikittyID, String wikittyVersion) throws IOException {
        WikittyImpl wikitty;
        log.info((Object)("Write wikitty information file: " + towrite + " Id:" + wikittyID + " version:" + wikittyVersion));
        if (towrite.exists() && !towrite.isDirectory()) {
            wikitty = new WikittyImpl(wikittyID);
            if (wikittyVersion != null) {
                wikitty.setVersion(wikittyVersion);
            } else {
                wikitty.setVersion(WikittyUtil.incrementMinorRevision((String)wikitty.getVersion()));
            }
        } else {
            throw new IOException(towrite.toString() + " not exist or is a directory");
        }
        File parent = towrite.getParentFile();
        PropertiesExtended id = WikittyPublicationFileSystem.getWikittyPublicationProperties(parent, WikittyFileUtil.WIKITTY_ID_PROPERTIES_FILE);
        PropertiesExtended meta = WikittyPublicationFileSystem.getWikittyPublicationProperties(parent, WikittyFileUtil.WIKITTY_FILE_META_PROPERTIES_FILE);
        id.put(wikitty.getId(), towrite.getName());
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(towrite));
        byte[] byt = MD5InputStream.hash((InputStream)input);
        String localMd5 = StringUtil.asHex((byte[])byt);
        meta.put(META_PREFIX_KEY_VERSION + towrite.getName(), wikitty.getVersion());
        meta.put(META_PREFIX_KEY_CHECKSUM + towrite.getName(), localMd5);
        meta.put(META_PREFIX_KEY_ID + towrite.getName(), wikitty.getId());
        id.store();
        meta.store();
    }
}

