/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication.externalize;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.MD5OutputStream;
import org.nuiton.util.StringUtil;

public class JarUtil {
    public static FileFilter jarFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.isDirectory() && pathname.getName().endsWith(".jar");
        }
    };
    private static Log log = LogFactory.getLog(JarUtil.class);
    private static final int BUFFER_SIZE = 8192;
    private static final String LOCAL_SEP = File.separator;
    private static final String LOCAL_SEP_PATTERN = "\\".equals(LOCAL_SEP) ? LOCAL_SEP + LOCAL_SEP : LOCAL_SEP;
    private static final String JAR_SEP = "/";
    private static final String ZIP_SEP_PATTERN = "/";
    protected static FileFilter ALL_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    };

    public static String uncompress(File file, File targetDir) throws IOException {
        String result = JarUtil.uncompressAndRename(file, targetDir, null, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uncompressAndRename(File file, File targetDir, String renameFrom, String renameTo) throws IOException {
        JarEntry entry;
        String result = "";
        JarInputStream in = new JarInputStream(new FileInputStream(file));
        while ((entry = in.getNextJarEntry()) != null) {
            String name = entry.getName();
            if (renameFrom != null && renameTo != null) {
                name = name.replaceAll(renameFrom, renameTo);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("rename " + entry.getName() + " -> " + name));
                }
            }
            result = name;
            File target = new File(targetDir, name);
            if (entry.isDirectory()) {
                target.mkdirs();
                continue;
            }
            target.getParentFile().mkdirs();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
            try {
                int len;
                byte[] buffer = new byte[8192];
                while ((len = in.read(buffer, 0, 8192)) != -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        in.close();
        return result;
    }

    public static void compressFiles(File jarFile, File fileOrDirectory) throws IOException {
        FileFilter filter = ALL_FILE_FILTER;
        List<File> files = new ArrayList();
        if (fileOrDirectory.isDirectory()) {
            files = FileUtil.getFilteredElements((File)fileOrDirectory, (FileFilter)filter, (boolean)true);
        } else if (filter.accept(fileOrDirectory)) {
            files.add(fileOrDirectory);
        }
        JarUtil.compressFiles(jarFile, fileOrDirectory, null, files, false);
    }

    public static void compressFiles(File jarFile, File root, Collection<File> includes) throws IOException {
        JarUtil.compressFiles(jarFile, root, null, includes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFiles(File jarFile, File root, Manifest mf, Collection<File> includes, boolean createMD5) throws IOException {
        if (mf == null) {
            mf = new Manifest();
        }
        FileOutputStream oStream = new FileOutputStream(jarFile);
        if (createMD5) {
            oStream = new MD5OutputStream((OutputStream)oStream);
        }
        try {
            JarOutputStream jarOStream = new JarOutputStream((OutputStream)oStream, mf);
            for (File file : includes) {
                String entryName = JarUtil.toJarEntryName(root, file);
                JarEntry entry = new JarEntry(entryName);
                entry.setTime(file.lastModified());
                jarOStream.putNextEntry(entry);
                if (file.isFile() && file.canRead()) {
                    byte[] readBuffer = new byte[8192];
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 8192);
                    try {
                        int bytesIn;
                        while ((bytesIn = bis.read(readBuffer, 0, 8192)) != -1) {
                            jarOStream.write(readBuffer, 0, bytesIn);
                        }
                    }
                    finally {
                        bis.close();
                    }
                }
                jarOStream.closeEntry();
            }
            jarOStream.close();
            if (createMD5) {
                String md5hash = StringUtil.asHex((byte[])((MD5OutputStream)oStream).hash());
                File md5File = new File(jarFile.getAbsoluteFile() + ".md5");
                FileUtil.writeString((File)md5File, (String)md5hash);
            }
        }
        finally {
            ((OutputStream)oStream).close();
        }
    }

    public static void compress(File jarFile, File fileOrDirectory) throws IOException {
        JarUtil.compress(jarFile, fileOrDirectory, null, null, false);
    }

    public static void compress(File jarFile, File fileOrDirectory, Manifest mf) throws IOException {
        JarUtil.compress(jarFile, fileOrDirectory, mf, null, false);
    }

    public static void compress(File jarFile, File fileOrDirectory, FileFilter filter) throws IOException {
        JarUtil.compress(jarFile, fileOrDirectory, null, filter, false);
    }

    public static void compress(File jarFile, File fileOrDirectory, Manifest mf, FileFilter filter, boolean createMD5) throws IOException {
        if (filter == null) {
            filter = ALL_FILE_FILTER;
        }
        List<File> files = new ArrayList();
        if (fileOrDirectory.isDirectory()) {
            files = FileUtil.getFilteredElements((File)fileOrDirectory, (FileFilter)filter, (boolean)true);
        } else if (filter.accept(fileOrDirectory)) {
            files.add(fileOrDirectory);
        }
        JarUtil.compressFiles(jarFile, fileOrDirectory.getParentFile(), mf, files, createMD5);
    }

    private static String toJarEntryName(File root, File file) {
        String rootPath;
        String result = file.getPath();
        if (root != null && result.startsWith(rootPath = root.getPath())) {
            result = result.substring(rootPath.length());
        }
        result = result.replace('\\', '/');
        if (file.isDirectory()) {
            result = result + '/';
        }
        while (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scan(File jarFile, File targetDir, List<String> newFiles, List<String> existingFiles, FileFilter excludeFilter, String renameFrom, String renameTo) throws IOException {
        JarFile jar = new JarFile(jarFile);
        try {
            boolean findExisting = targetDir != null && targetDir.exists();
            boolean filter = findExisting && excludeFilter != null;
            boolean rename = renameFrom != null && renameTo != null;
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (rename) {
                    entryName = entryName.replaceAll(renameFrom, renameTo);
                }
                String name = JarUtil.convertToLocalEntryName(entryName);
                if (findExisting || filter) {
                    File file = new File(targetDir, name);
                    if (filter && excludeFilter.accept(file)) continue;
                    if (file.exists()) {
                        existingFiles.add(name);
                        continue;
                    }
                }
                newFiles.add(name);
            }
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    public static List<String>[] scanAndExplodeJar(File source, File root, FileFilter excludeFilter) throws IOException {
        ArrayList<String> overwrittenFiles = new ArrayList<String>();
        ArrayList<String> newFiles = new ArrayList<String>();
        JarUtil.scan(source, root, newFiles, overwrittenFiles, excludeFilter, null, null);
        return new List[]{newFiles, overwrittenFiles};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uncompress(File file, File targetDir, List<String> toTreate, String renameFrom, String renameTo) throws IOException {
        if (toTreate == null || toTreate.isEmpty()) {
            return JarUtil.uncompressAndRename(file, targetDir, renameFrom, renameTo);
        }
        boolean rename = renameFrom != null && renameTo != null;
        String result = "";
        JarInputStream in = new JarInputStream(new FileInputStream(file));
        try {
            JarEntry entry;
            while ((entry = in.getNextJarEntry()) != null) {
                String name = entry.getName();
                result = rename ? JarUtil.convertToLocalEntryName(name.replaceAll(renameFrom, renameTo)) : JarUtil.convertToLocalEntryName(name);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("open [" + name + "] : " + result));
                }
                if (!toTreate.contains(result)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("copy [" + name + "] : " + result));
                }
                File target = new File(targetDir, result);
                if (entry.isDirectory()) {
                    target.mkdirs();
                    continue;
                }
                target.getParentFile().mkdirs();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
                try {
                    int len;
                    byte[] buffer = new byte[8192];
                    while ((len = in.read(buffer, 0, 8192)) != -1) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
        }
        finally {
            in.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompressFiltred(File file, File targetDir, String ... excludes) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            boolean excludeEntry = false;
            if (excludes != null) {
                for (String exclude : excludes) {
                    if (!name.matches(exclude)) continue;
                    excludeEntry = true;
                }
            }
            if (excludeEntry) continue;
            File target = new File(targetDir, name);
            if (entry.isDirectory()) {
                target.mkdirs();
                continue;
            }
            target.getParentFile().mkdirs();
            InputStream in = jarFile.getInputStream(entry);
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
                try {
                    int len;
                    byte[] buffer = new byte[8192];
                    while ((len = in.read(buffer, 0, 8192)) != -1) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                in.close();
            }
        }
    }

    protected static String convertToLocalEntryName(String txt) {
        String s = txt.replaceAll("/", LOCAL_SEP_PATTERN);
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String getStringContent(JarFile jar, JarEntry jarEntry) throws IOException {
        BufferedReader buffer = new BufferedReader(new InputStreamReader(jar.getInputStream(jarEntry)));
        StringBuffer result = new StringBuffer();
        char[] cbuf = new char[2000];
        int nb = buffer.read(cbuf);
        while (nb != -1) {
            result.append(cbuf, 0, nb);
            nb = buffer.read(cbuf);
        }
        buffer.close();
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteContent(JarFile jar, JarEntry jarEnt) throws IOException {
        ByteArrayOutputStream content;
        BufferedInputStream in = new BufferedInputStream(jar.getInputStream(jarEnt));
        try {
            content = new ByteArrayOutputStream();
            BufferedOutputStream tmp = new BufferedOutputStream(content);
            try {
                int b = ((InputStream)in).read();
                while (b != -1) {
                    tmp.write(b);
                    b = ((InputStream)in).read();
                }
            }
            finally {
                tmp.close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return content.toByteArray();
    }
}

