/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication.externalize;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class CompileHelper {
    private static final Log log = LogFactory.getLog(CompileHelper.class);

    public static List<File> searchSrcToCompile(File srcDir, File destDir) {
        ArrayList<File> result = new ArrayList<File>();
        for (File src : srcDir.listFiles()) {
            File dest = new File(FileUtil.basename((File)src, (String[])new String[]{".java"}), ".class");
            if (!src.getName().endsWith(".java") || !FileUtil.isNewer((File)src, (File)dest)) continue;
            result.add(src);
        }
        return result;
    }

    public static int compile(List<File> addToClassPath, File rootSrc, File src, File dest, PrintWriter out) {
        int result = CompileHelper.compile(addToClassPath, rootSrc, Collections.singletonList(src), dest, out);
        return result;
    }

    public static int compile(File rootSrc, File src, File dest, PrintWriter out) {
        int result = CompileHelper.compile(null, rootSrc, Collections.singletonList(src), dest, out);
        return result;
    }

    public static int compile(List<File> addToClassPath, File rootSrc, Collection<File> src, File dest, PrintWriter out) {
        int result;
        block3: {
            result = -10000;
            try {
                ArrayList<File> classpath = new ArrayList<File>();
                if (addToClassPath != null) {
                    classpath.addAll(addToClassPath);
                }
                classpath.add(rootSrc.getAbsoluteFile());
                result = CompileHelper.compile(classpath, src, dest, out);
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"Compilation failed", (Throwable)eee);
            }
        }
        return result;
    }

    protected static int compile(List<File> classpath, Collection<File> src, File dest, PrintWriter out) {
        int result;
        block2: {
            dest.mkdirs();
            result = -1000;
            try {
                JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(src);
                String classpathAsString = CompileHelper.getClassPathAsString(classpath);
                ArrayList<String> args = new ArrayList<String>();
                args.add("-g");
                args.add("-deprecation");
                args.add("-classpath");
                args.add(classpathAsString);
                args.add("-d");
                args.add(dest.getAbsolutePath());
                boolean b = compiler.getTask(out, fileManager, null, args, null, compilationUnits).call();
                result = b ? 0 : -1;
                fileManager.close();
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't get compiler", (Throwable)eee);
            }
        }
        return result;
    }

    public static String getClassPathAsString(List<File> classpath) throws Exception {
        String[] systemClassPathes;
        String result = StringUtils.join(classpath.iterator(), (String)File.pathSeparator);
        Enumeration<URL> e = CompileHelper.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (e.hasMoreElements()) {
            String jarName;
            URL url = e.nextElement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found manifest : " + url));
            }
            if (url == null || !url.getFile().startsWith("file:/") || result.contains(jarName = url.getPath().substring(5, url.getPath().indexOf("!")))) continue;
            result = result + File.pathSeparator + jarName;
        }
        String systemClassPath = System.getProperty("java.class.path");
        for (String path : systemClassPathes = systemClassPath.split(File.pathSeparator)) {
            String absolutePath = new File(path).getCanonicalPath();
            if (result.contains(absolutePath)) continue;
            result = result + File.pathSeparator + absolutePath;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CLASSPATH : " + result));
        }
        return result;
    }
}

