/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.script.ScriptEngineManager;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.ScriptEvaluator;
import org.nuiton.wikitty.publication.CodeDecorator;

public class MimeTypePubHelper {
    private static Log log = LogFactory.getLog(MimeTypePubHelper.class);
    public static final String JAVA_TYPE = "text/java";
    public static final String JAR_TYPE = "application/jar";
    protected BidiMap bidiMap;
    protected ScriptEngineManager manager;
    public static String COMMON_MIME_SEP = "/";
    public static String PUBLICATION_MIME_SEP = ".";
    public static String PREFIX_MIME_PUB_TEXT = "text";
    public static String MIME_PROPERTIE = "mimetype.properties";
    public static String REGEX_PUB_TEXT_TRANSFORM = "text/\\w*\\.\\w*";
    public static String DEFAULT_MIME_TYPE = "application/octet-stream";

    public MimeTypePubHelper() {
        Properties mimeProps;
        block3: {
            this.bidiMap = new DualHashBidiMap();
            this.manager = ScriptEvaluator.getScriptEnginManager(null);
            InputStream input = MimeTypePubHelper.class.getResourceAsStream("/mimetype.properties");
            mimeProps = new Properties();
            try {
                mimeProps.load(input);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Error while reading properties Fie that containt mimetype mapping ", (Throwable)e);
            }
        }
        for (Map.Entry<Object, Object> en : mimeProps.entrySet()) {
            this.bidiMap.put(en.getValue(), en.getKey());
        }
    }

    public String getExtensionForMime(String mime) {
        this.bidiMap = this.bidiMap.inverseBidiMap();
        String result = (String)this.bidiMap.get((Object)mime);
        this.bidiMap = this.bidiMap.inverseBidiMap();
        return result;
    }

    public String getMimeForExtension(String ext) {
        String result = (String)this.bidiMap.get((Object)ext);
        if (result == null) {
            result = DEFAULT_MIME_TYPE;
        }
        return result;
    }

    public boolean isPubTextMime(String mimeType) {
        boolean result = mimeType.startsWith(PREFIX_MIME_PUB_TEXT);
        CodeDecorator decorator = new CodeDecorator();
        if (mimeType.matches(REGEX_PUB_TEXT_TRANSFORM)) {
            String[] mimeTab = StringUtil.split((String)mimeType, (String)COMMON_MIME_SEP);
            String originalMime = mimeTab[0];
            result = this.manager.getEngineByMimeType(originalMime = originalMime + COMMON_MIME_SEP + StringUtil.split((String)mimeType, (String)PUBLICATION_MIME_SEP)[1]) != null || originalMime.equals(JAVA_TYPE);
            result = result && decorator.isDecorated(mimeTab[1]);
        }
        return result;
    }

    public String uiMimeToFilterOptionKey(String mime) {
        String result = mime;
        if (mime.matches(REGEX_PUB_TEXT_TRANSFORM)) {
            result = StringUtil.split((String)mime, (String)COMMON_MIME_SEP)[1];
        }
        return result;
    }

    public String uiMimeContentType(String mime) {
        String result = mime;
        if (mime.matches(REGEX_PUB_TEXT_TRANSFORM)) {
            result = StringUtil.split((String)mime, (String)COMMON_MIME_SEP)[0];
        }
        return result;
    }

    public String pubUiMimeToTargetMime(String mime) {
        String result = mime;
        if (mime.matches(REGEX_PUB_TEXT_TRANSFORM)) {
            String[] mimeTab = StringUtil.split((String)mime, (String)COMMON_MIME_SEP);
            result = mimeTab[0];
            result = result + COMMON_MIME_SEP + StringUtil.split((String)mime, (String)PUBLICATION_MIME_SEP)[1];
        }
        return result;
    }

    public boolean isPubTextExtension(String extension) {
        return this.isPubTextMime(this.getMimeForExtension(extension));
    }

    public void addExtensionMime(String extension, String mime) {
        this.bidiMap.put((Object)extension, (Object)mime);
    }

    public ScriptEngineManager getManager() {
        return this.manager;
    }

    public void setManager(ScriptEngineManager manager) {
        this.manager = manager;
    }
}

