package org.nuiton.wikitty.publication.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class WikittyPubDataHelper {

    /**
     * WikittyPubDataHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyPubDataHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_NAME, name);
        return oldValue;
}

    /**
     * getMimeType :
     * @param wikitty 
     * @return String 
     */

    public static String getMimeType(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_MIMETYPE);
        return value;
}

    /**
     * setMimeType :
     * @param wikitty 
     * @param mimeType 
     * @return String 
     */

    public static String setMimeType(Wikitty wikitty, String mimeType) {
        String oldValue = getMimeType(wikitty);
        wikitty.setField(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_MIMETYPE, mimeType);
        return oldValue;
}

    /**
     * getContent :
     * @param wikitty 
     * @return byte[] 
     */

    public static byte[] getContent(Wikitty wikitty) {
        byte[] value = wikitty.getFieldAsBytes(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_CONTENT);
        return value;
}

    /**
     * setContent :
     * @param wikitty 
     * @param content 
     * @return byte[] 
     */

    public static byte[] setContent(Wikitty wikitty, byte[] content) {
        byte[] oldValue = getContent(wikitty);
        wikitty.setField(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_CONTENT, content);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_NAME);
            Object f2 = w2.getFieldAsObject(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_MIMETYPE);
            Object f2 = w2.getFieldAsObject(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_MIMETYPE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_CONTENT);
            Object f2 = w2.getFieldAsObject(WikittyPubData.EXT_WIKITTYPUBDATA, WikittyPubData.FIELD_WIKITTYPUBDATA_CONTENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyPubData.EXT_WIKITTYPUBDATA);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyPubDataAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //WikittyPubDataHelper
