/*
 * #%L
 * Wikitty :: publication
 * 
 * $Id: ActionRaw.java 650 2010-12-23 11:44:57Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0/wikitty-publication/src/main/java/org/nuiton/wikitty/publication/ActionRaw.java $
 * %%
 * Copyright (C) 2010 CodeLutin, Benjamin Poussin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.publication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.search.Criteria;

/**
 * Action permettant de retourner la valeur d'un champs d'un object.
 * Elle peut-etre utilisee pour retourner une image ou un document stocke dans
 * un champs d'un wikitty
 *
 * Cette action prend deux arguments obligatoires (si pas WikittyPub(Text|Data)
 * <li> l'argument de recherche du wikitty
 * <li> le champs qu'il faut retourner en raw
 * 
 * et un argument optionnel
 * <li> le type mime du contenu qui peut-etre un champs de l'objet
 *
 * exemple
 * <pre>
 * ram/WikittyPubData.name=MonImage.jpg
 * ram/WikittyPubText.name=Tuto
 * ram/WikittyPubData.name=MonImage.jpg/WikittyPubData.content?mimetype=WikittyPubData.mimetype
 * ram/WikittyPubData.name=MonImage.jpg/WikittyPubData.mimetype?mimetype=text/plain
 * ram/WikittyPubText.name=Tuto/WikittyPubText.content?mimetype=WikittyPubText.mimetype
 * ram/WikittyUser.login=admin/WikittyUser.password?mimetype=text/plain
 * </pre>
 *
 * @author poussin
 * @version $Revision: 650 $
 *
 * Last update: $Date: 2010-12-23 12:44:57 +0100 (jeu., 23 déc. 2010) $
 * by : $Author: sletellier $
 */
public class ActionRaw extends AbstractActionOnWikitty {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(ActionError.class);

    static final protected String exampleUsage =
            "ram/WikittyPubData.name=MonImage.jpg/WikittyPubData.content?mimetype=WikittyPubData.mimetype\n"
            + "ram/Tuto\n"
            + "ram/Tuto/WikittyPubText.content\n"
            + "ram/WikittyPubText.name=Tuto/WikittyPubText.content\n"
            + "ram/WikittyPubText.name=Tuto/WikittyPubText.content?mimetype=WikittyPubText.mimetype\n"
            + "ram/WikittyUser.login=admin/WikittyUser.password?mimetype=text/plain\n";

    protected ApplicationConfig appConfig;

    public ActionRaw(ApplicationConfig appConfig) {
        this.appConfig = appConfig;
    }

    protected String getExampleUsage() {
        return exampleUsage;
    }

    @Override
    public Object doAction(WikittyPublicationContext context) {

        log.info("args " + context.getMandatoryArguments());

        Object result;
        Criteria criteria = searchCriteria(context.getMandatoryArguments());

        if (criteria == null) {
            result = getError(context);
        } else {
            WikittyProxy proxy = context.getWikittyProxy();
            Wikitty w = proxy.findByCriteria(criteria);

            if (w == null) {
                context.setContentType("text/plain");
                result = String.format(
                        "no data found for criteria %s", criteria);
            } else {
                String contentField = getContentFieldName(context, criteria.getName(), w);

                if (contentField == null) {
                    result = getError(context);
                } else {
                    String extName = WikittyExtension.extractExtensionName(contentField);
                    String fieldName = WikittyExtension.extractFieldName(contentField);

                    String mimetype = getMimeType(context, criteria.getName(), w);
                    context.setContentType(mimetype);
                    result = w.getFieldAsObject(extName, fieldName);
                }
            }
        }

        return result;
    }

}
