/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import com.caucho.hessian.server.HessianServlet;
import java.net.URL;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.services.WikittyServiceDelegator;

public class WikittyServiceHessianServer
extends WikittyServiceDelegator {
    private static Log log = LogFactory.getLog(WikittyServiceHessianServer.class);

    public WikittyServiceHessianServer(ApplicationConfig config, WikittyService ws) {
        try {
            Server server;
            this.setDelegate(ws);
            HessianServlet servlet = new HessianServlet();
            servlet.setHomeAPI(WikittyService.class);
            servlet.setHome((Object)this);
            String jettyConfig = config.getOption(WikittyConfigOption.WIKITTY_SERVER_CONFIG.getKey());
            String urlString = config.getOption(WikittyConfigOption.WIKITTY_SERVER_URL.getKey());
            int port = 80;
            String path = "/";
            if (urlString != null && !"".equals(urlString)) {
                URL url = new URL(urlString);
                if (-1 != url.getPort()) {
                    port = url.getPort();
                }
                if (null != url.getPath() && !(path = url.getPath()).endsWith("/")) {
                    path = path + "/";
                }
            }
            if (jettyConfig != null && !"".equals(jettyConfig)) {
                Resource fileserver_xml = Resource.newSystemResource((String)jettyConfig);
                XmlConfiguration configuration = new XmlConfiguration(fileserver_xml.getInputStream());
                server = (Server)configuration.configure();
                boolean connectorPortFound = false;
                for (Connector connector : server.getConnectors()) {
                    if (!(connector instanceof SelectChannelConnector)) continue;
                    connectorPortFound = true;
                    connector.setPort(port);
                }
                if (!connectorPortFound) {
                    SelectChannelConnector connector = new SelectChannelConnector();
                    connector.setPort(port);
                    server.addConnector((Connector)connector);
                }
            } else {
                server = new Server(port);
            }
            ServletContextHandler context = new ServletContextHandler(0);
            context.setContextPath("/");
            server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)servlet), path + "*");
            server.start();
            server.join();
            log.info((Object)("Web server are running on port: " + port));
        }
        catch (Exception eee) {
            throw new WikittyException("Can't start wikitty server", (Throwable)eee);
        }
    }
}

