/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.function;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ObjectUtil;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryVisitor;
import org.nuiton.wikitty.query.WikittyQueryVisitorToString;
import org.nuiton.wikitty.query.function.FunctionAvg;
import org.nuiton.wikitty.query.function.FunctionCount;
import org.nuiton.wikitty.query.function.FunctionDistinct;
import org.nuiton.wikitty.query.function.FunctionFieldValue;
import org.nuiton.wikitty.query.function.FunctionFusion;
import org.nuiton.wikitty.query.function.FunctionMax;
import org.nuiton.wikitty.query.function.FunctionMin;
import org.nuiton.wikitty.query.function.FunctionSum;
import org.nuiton.wikitty.query.function.FunctionYear;
import org.nuiton.wikitty.query.function.WikittyQueryFunctionWrapper;

public abstract class WikittyQueryFunction {
    private static Log log = LogFactory.getLog(WikittyQueryFunction.class);
    private static final long serialVersionUID = 1L;
    protected String methodName;
    protected String name;
    protected List<WikittyQueryFunction> args = new ArrayList<WikittyQueryFunction>();
    protected int numArg = Integer.MAX_VALUE;

    public abstract List<Map<String, Object>> call(WikittyQuery var1, List<Map<String, Object>> var2);

    public static WikittyQueryFunction createFusionIfNeeded(List<WikittyQueryFunction> args) {
        WikittyQueryFunction result = args.size() == 1 ? args.get(0) : new FunctionFusion(args);
        return result;
    }

    public static WikittyQueryFunction create(String methodName, String name, List<WikittyQueryFunction> args) {
        WikittyQueryFunction result;
        if ("fieldValue".equalsIgnoreCase(methodName)) {
            result = new FunctionFieldValue(methodName, name, args);
        } else if ("Fusion".equalsIgnoreCase(methodName)) {
            result = new FunctionFusion(methodName, name, args);
        } else if ("sum".equalsIgnoreCase(methodName)) {
            result = new FunctionSum(methodName, name, args);
        } else if ("min".equalsIgnoreCase(methodName)) {
            result = new FunctionMin(methodName, name, args);
        } else if ("max".equalsIgnoreCase(methodName)) {
            result = new FunctionMax(methodName, name, args);
        } else if ("avg".equalsIgnoreCase(methodName)) {
            result = new FunctionAvg(methodName, name, args);
        } else if ("count".equalsIgnoreCase(methodName)) {
            result = new FunctionCount(methodName, name, args);
        } else if ("distinct".equalsIgnoreCase(methodName)) {
            result = new FunctionDistinct(methodName, name, args);
        } else if ("toBigDecimal".equalsIgnoreCase(methodName)) {
            result = new WikittyQueryFunctionWrapper(WikittyUtil.class.getName() + "#toBigDecimal", name, args);
        } else if ("toBoolean".equalsIgnoreCase(methodName)) {
            result = new WikittyQueryFunctionWrapper(WikittyUtil.class.getName() + "#toBoolean", name, args);
        } else if ("toString".equalsIgnoreCase(methodName)) {
            result = new WikittyQueryFunctionWrapper(WikittyUtil.class.getName() + "#toString", name, args);
        } else if ("toDate".equalsIgnoreCase(methodName)) {
            result = new WikittyQueryFunctionWrapper(WikittyUtil.class.getName() + "#toDate", name, args);
        } else if ("year".equalsIgnoreCase(methodName)) {
            result = new FunctionYear(methodName, name, args);
        } else if (StringUtils.contains((CharSequence)methodName, (CharSequence)"#")) {
            result = new WikittyQueryFunctionWrapper(methodName, name, args);
        } else {
            try {
                Class<?> c = Class.forName(methodName);
                result = (WikittyQueryFunction)ConstructorUtils.invokeConstructor(c, (Object[])new Object[]{methodName, name, args}, (Class[])new Class[]{String.class, String.class, List.class});
            }
            catch (Exception eee) {
                throw new WikittyException(String.format("Can't instantiate function '%s'", methodName), eee);
            }
        }
        return result;
    }

    public WikittyQueryFunction(String methodName, String name, List<WikittyQueryFunction> args) {
        this.methodName = methodName;
        this.name = name == null ? UUID.randomUUID().toString() : name;
        this.addArgs(args);
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == null) {
            result = false;
        } else if (this == o) {
            result = true;
        } else if (this.getClass().equals(o.getClass())) {
            WikittyQueryFunction other = (WikittyQueryFunction)o;
            result = StringUtils.equals((CharSequence)this.getMethodName(), (CharSequence)other.getMethodName()) && ObjectUtils.equals(this.getArgs(), other.getArgs());
        } else {
            return false;
        }
        return result;
    }

    public void accept(WikittyQueryVisitor visitor) {
        boolean walk = visitor.visitEnter(this);
        if (walk && this.args != null) {
            boolean notFirst = false;
            for (WikittyQueryFunction a : this.args) {
                if (notFirst) {
                    walk = visitor.visitMiddle(this);
                    if (!walk) {
                        break;
                    }
                } else {
                    notFirst = true;
                }
                a.accept(visitor);
            }
        }
        visitor.visitLeave(this, walk);
    }

    public String getName() {
        return this.name;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<WikittyQueryFunction> getArgs() {
        return this.args;
    }

    public void addArgs(List<WikittyQueryFunction> args) {
        if (args != null) {
            if (this.args.size() + args.size() <= this.getNumArg()) {
                this.args.addAll(args);
            } else {
                throw new IllegalStateException(String.format("This function '%s' can't take more arguments than %s, currently '%s', you try to add %s arguments", this.getClass().getSimpleName(), this.getNumArg(), this.args.size(), args.size()));
            }
        }
    }

    public void addArgs(WikittyQueryFunction arg) {
        if (!this.acceptMoreArgs()) {
            throw new IllegalStateException(String.format("This function '%s' can't take more arguments, currently '%s'", this.getClass().getSimpleName(), this.args.size()));
        }
        this.args.add(arg);
    }

    public int getNumArg() {
        return this.numArg;
    }

    public boolean acceptMoreArgs() {
        boolean result = this.args.size() < this.getNumArg();
        return result;
    }

    public String toString() {
        WikittyQueryVisitorToString v = new WikittyQueryVisitorToString();
        this.accept(v);
        String result = v.getText();
        return result;
    }

    protected List<Map<String, Object>> fusion(List<List<Map<String, Object>>> listData) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int size = -1;
        for (List<Map<String, Object>> e : listData) {
            if (size == -1) {
                size = e.size();
                continue;
            }
            if (size == e.size()) continue;
            throw new IllegalArgumentException(String.format("Each list must have same size %s != %s (%s)", size, e.size(), listData));
        }
        for (int i = 0; i < size; ++i) {
            result.add(new LinkedHashMap());
        }
        for (List<Map<String, Object>> e : listData) {
            int i = 0;
            for (Map<String, Object> m : e) {
                Map r = (Map)result.get(i++);
                r.putAll(m);
            }
        }
        return result;
    }

    protected Object getUniqueValue(List<Map<String, Object>> data) {
        Object result = null;
        if (data.size() != 1) {
            throw new IllegalStateException("Data don't contains 1 value exactly");
        }
        for (Map<String, Object> o : data) {
            if (o.size() != 1) {
                throw new IllegalStateException("Map don't contains 1 value exactly");
            }
            Iterator<Object> i$ = o.values().iterator();
            while (i$.hasNext()) {
                Object s;
                result = s = i$.next();
            }
        }
        return result;
    }

    protected Object getUniqueValue(Map<String, Object> o) {
        Object result = null;
        if (o.size() != 1) {
            throw new IllegalStateException("Map don't contains 1 value exactly");
        }
        Iterator<Object> i$ = o.values().iterator();
        while (i$.hasNext()) {
            Object s;
            result = s = i$.next();
        }
        return result;
    }

    protected Object getFirstFieldName(List<Map<String, Object>> data) {
        for (Map<String, Object> o : data) {
            Iterator<String> i$ = o.keySet().iterator();
            if (!i$.hasNext()) continue;
            String s = i$.next();
            return s;
        }
        return null;
    }

    protected Method getMethod(String fqMethod) {
        List methods = ObjectUtil.getMethod((String)fqMethod, (boolean)true);
        if (methods.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't find method '%s'", fqMethod));
        }
        if (methods.size() > 1) {
            log.warn((Object)String.format("More than one method found for '%s', used the first: %s", fqMethod, methods));
        }
        Method result = (Method)methods.get(0);
        return result;
    }
}

