/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyGroupImpl;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyLabelImpl;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.storage.WikittySearchEngineInMemory;
import org.nuiton.wikitty.storage.WikittyStorageInMemory;

public class WikittySearchEngineInMemoryTest {
    private static Log log = LogFactory.getLog(WikittySearchEngineInMemoryTest.class);

    @Test
    public void testfindAllByQuery() throws Exception {
        WikittyLabelImpl l1 = new WikittyLabelImpl((Wikitty)new WikittyImpl("l1"));
        l1.addLabels(new String[]{"toutou"});
        l1.addLabels(new String[]{"titi"});
        WikittyLabelImpl l2 = new WikittyLabelImpl((Wikitty)new WikittyImpl("l2"));
        WikittyGroupImpl g1 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g1"));
        g1.setName("MonGroup1");
        g1.addMembers(new String[]{l1.getWikittyId()});
        WikittyGroupImpl g2 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g2"));
        g2.setName("MonGroup2");
        g2.addMembers(new String[]{l2.getWikittyId()});
        WikittyGroupImpl g3 = new WikittyGroupImpl((Wikitty)new WikittyImpl("g3"));
        g3.setName("MonGroup3");
        g3.addMembers(new String[]{l1.getWikittyId()});
        g3.addMembers(new String[]{l2.getWikittyId()});
        LinkedList<Wikitty> wikitties = new LinkedList<Wikitty>();
        wikitties.add(l1.getWikitty());
        wikitties.add(l2.getWikitty());
        wikitties.add(g1.getWikitty());
        wikitties.add(g2.getWikitty());
        wikitties.add(g3.getWikitty());
        WikittyStorageInMemory storage = new WikittyStorageInMemory();
        storage.store(null, wikitties, false);
        WikittySearchEngineInMemory se = new WikittySearchEngineInMemory(storage);
        WikittyQuery q = ((WikittyQueryMaker)new WikittyQueryMaker().eq("WikittyLabel.labels", (Object)"toutou")).end();
        WikittyQueryResult result = se.findAllByQuery(null, q).convertMapToSimple();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)l1.getWikittyId(), (Object)result.peek());
        q = ((WikittyQueryMaker)new WikittyQueryMaker().keyword((Object)"i")).end();
        result = se.findAllByQuery(null, q).convertMapToSimple();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)l1.getWikittyId(), (Object)result.peek());
        q = ((WikittyQueryMaker)new WikittyQueryMaker().keyword((Object)"ou")).end();
        result = se.findAllByQuery(null, q).convertMapToSimple();
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertTrue((boolean)result.getAll().containsAll(Arrays.asList(l1.getWikittyId(), g1.getWikittyId(), g2.getWikittyId(), g3.getWikittyId())));
        q = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).exteq("WikittyGroup")).keyword((Object)"ou")).end();
        result = se.findAllByQuery(null, q).convertMapToSimple();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)result.getAll().containsAll(Arrays.asList(g1.getWikittyId(), g2.getWikittyId(), g3.getWikittyId())));
        q = ((WikittyQueryMaker)new WikittyQueryMaker().isNull("WikittyLabel.labels")).end();
        result = se.findAllByQuery(null, q).convertMapToSimple();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)l2.getWikittyId(), (Object)result.peek());
        q = ((WikittyQueryMaker)new WikittyQueryMaker().like("WikittyGroup.name", (Object)"*P2")).end();
        result = se.findAllByQuery(null, q).convertMapToSimple();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)g2.getWikittyId(), (Object)result.peek());
        q = ((WikittyQueryMaker)new WikittyQueryMaker().ew("WikittyGroup.name", (Object)"p2")).end();
        result = se.findAllByQuery(null, q).convertMapToSimple();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)g2.getWikittyId(), (Object)result.peek());
        q = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().containsOne("WikittyGroup.members")).select((Element)Element.ID)).eq("WikittyLabel.labels", (Object)"titi")).end();
        result = se.findAllByQuery(null, q).convertMapToSimple();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.getAll().containsAll(Arrays.asList(g1.getWikittyId(), g3.getWikittyId())));
        q = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().or()).ideq((Object)g2.getWikittyId())).containsOne("WikittyGroup.members")).select((Element)Element.ID)).eq("WikittyLabel.labels", (Object)"titi")).end();
        result = se.findAllByQuery(null, q).convertMapToSimple();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)result.getAll().containsAll(Arrays.asList(g1.getWikittyId(), g2.getWikittyId(), g3.getWikittyId())));
        q = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).not()).ideq((Object)g1.getWikittyId())).containsOne("WikittyGroup.members")).select((Element)Element.ID)).eq("WikittyLabel.labels", (Object)"titi")).end();
        result = se.findAllByQuery(null, q).convertMapToSimple();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.getAll().containsAll(Arrays.asList(g3.getWikittyId())));
        q = ((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().select("WikittyGroup.name")).eq("WikittyGroup.members", (Object)l1)).end();
        result = se.findAllByQuery(null, q).convertMapToSimple();
        System.out.println("dd:" + result.getAll());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.getAll().containsAll(Arrays.asList(g1.getName(), g3.getName())));
    }

    @Test
    public void findAllChildrenCount() throws Exception {
    }
}

