/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: BusinessEntityImplTest.java 641 2010-12-21 15:34:09Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.1/wikitty-api/src/test/java/org/nuiton/wikitty/entities/BusinessEntityImplTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

/**
 *
 * @author poussin
 * @version $Revision: 641 $
 *
 * Last update: $Date: 2010-12-21 16:34:09 +0100 (mar., 21 déc. 2010) $
 * by : $Author: sletellier $
 */
public class BusinessEntityImplTest {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(BusinessEntityImplTest.class);

    @Test
    public void testCopyFrom() throws Exception {
        WikittyLabel source = new WikittyLabelImpl();
        source.addLabels("1erLabel");
        source.addLabels("2emeLabel");

        WikittyLabel dest = new WikittyLabelImpl();

        dest.copyFrom(source);
        Assert.assertFalse(source.getWikittyId().equals(dest.getWikittyId()));
        Assert.assertEquals(source.getWikittyVersion(), dest.getWikittyVersion());
        Assert.assertEquals(source.getLabels(), dest.getLabels());
    }
    
}
