/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: ExtensionFactory.java 461 2010-10-29 15:19:55Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.1/wikitty-api/src/main/java/org/nuiton/wikitty/entities/ExtensionFactory.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.LinkedHashMap;

import org.nuiton.wikitty.entities.FieldType.TYPE;

public class ExtensionFactory {
    
    protected String name;
    protected String version;
    protected String requiredExtension;

    protected LinkedHashMap<String, FieldType> fields;
    
    protected ExtensionFactory(String name, String version) {
        this.name = name;
        this.version = version;
        this.fields = new LinkedHashMap<String, FieldType>();
    }
    
    public static ExtensionFactory create(String name, String version) {
        return new ExtensionFactory(name, version);
    }
    
    public FieldFactory addField(String name, TYPE fieldType) {
        return new FieldFactory(this, name, fieldType);
    }
    
    public WikittyExtension extension() {
        WikittyExtension ext = new WikittyExtension(name, version, requiredExtension, fields);
        return ext;
    }
    
    protected void add(String fieldName, FieldType fieldType) {
        fields.put(fieldName, fieldType);
    }

}
