package org.nuiton.wikitty.search;

import java.io.Serializable;
import java.util.List;

/**
 * Or operator is used to build disjunctive restriction for request on content.
 * It take at least 2 args. <br>
 * <br>
 * For example, use:
 * <ul>
 * <li>RestrictionHelper.or( restriction1, restriction2 )</li>
 * <li>RestrictionHelper.or( restriction1, restriction2, restriction3 )</li>
 * <li>RestrictionHelper.or(
 * my_JavaUtilList_Of_Restriction_Witch_Size_Is_Upper_Than2 )</li>
 * </ul>
 */
public class Or extends Restriction implements Serializable {

    // serialVersionUID is used for serialization.
    private static final long serialVersionUID = 1L;

    protected List<Restriction> restrictions;

    /**
     * Default constructor
     */
    public Or() {
        super();
    }

    /**
     * Constructor with all parameters initialized
     * 
     * @param restrictions
     */
    public Or(List<Restriction> restrictions) {
        this.restrictions = restrictions;
    }

    /**
     * Return restrictions
     * 
     * @return
     */
    public List<Restriction> getRestrictions() {
        return restrictions;
    }

    /**
     * Set a value to parameter restrictions.
     * 
     * @param restrictions
     */
    public void setRestrictions(List<Restriction> restrictions) {
        this.restrictions = restrictions;
    }

    /**
     * Equality test based attributes values
     * 
     * @param other Value to compare
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Or)) {
            return false;
        }

        final Or or = (Or) other;

        if ((restrictions == null && or.getRestrictions() != null)
                || (restrictions != null && !restrictions.equals(or
                        .getRestrictions())))
            return false;

        return true;
    }

    public int hashCode() {
        // equals use objects that are not constant through time
        // then, unable to create hashCode from those objects 
        // returning a constant hash-code
        return Or.class.hashCode();
    }

}