/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public interface WikittyAuthorisation extends BusinessEntity {     String EXT_WIKITTYAUTHORISATION = "WikittyAuthorisation";
     String FIELD_WIKITTYAUTHORISATION_OWNER = "owner";
     String FQ_FIELD_WIKITTYAUTHORISATION_OWNER = EXT_WIKITTYAUTHORISATION + ".owner";
     String FIELD_WIKITTYAUTHORISATION_ADMIN = "admin";
     String FQ_FIELD_WIKITTYAUTHORISATION_ADMIN = EXT_WIKITTYAUTHORISATION + ".admin";
     String FIELD_WIKITTYAUTHORISATION_WRITER = "writer";
     String FQ_FIELD_WIKITTYAUTHORISATION_WRITER = EXT_WIKITTYAUTHORISATION + ".writer";
     String FIELD_WIKITTYAUTHORISATION_READER = "reader";
     String FQ_FIELD_WIKITTYAUTHORISATION_READER = EXT_WIKITTYAUTHORISATION + ".reader";
     String FIELD_WIKITTYAUTHORISATION_PARENT = "parent";
     String FQ_FIELD_WIKITTYAUTHORISATION_PARENT = EXT_WIKITTYAUTHORISATION + ".parent";
    /**
     * getOwner :
     * @return String 
     */

     String getOwner();

    /**
     * setOwner :
     * @param owner 
     */

     void setOwner(String owner);

    /**
     * getAdmin :
     * @return Set<String> 
     */

     Set<String> getAdmin();

    /**
     * addAdmin :
     * @param element 
     */

     void addAdmin(String element);

    /**
     * removeAdmin :
     * @param element 
     */

     void removeAdmin(String element);

    /**
     * clearAdmin :
     */

     void clearAdmin();

    /**
     * getWriter :
     * @return Set<String> 
     */

     Set<String> getWriter();

    /**
     * addWriter :
     * @param element 
     */

     void addWriter(String element);

    /**
     * removeWriter :
     * @param element 
     */

     void removeWriter(String element);

    /**
     * clearWriter :
     */

     void clearWriter();

    /**
     * getReader :
     * @return Set<String> 
     */

     Set<String> getReader();

    /**
     * addReader :
     * @param element 
     */

     void addReader(String element);

    /**
     * removeReader :
     * @param element 
     */

     void removeReader(String element);

    /**
     * clearReader :
     */

     void clearReader();

    /**
     * getParent :
     * Pointe sur un autre WikittyAuthorisation qui permet d'indiquer que les droits de l'objet courant sont les mêmes que l'objet pointée. Les droits de l'objet courant s'ajoute au droit de l'objet pointé
     * @return String 
     */

     String getParent();

    /**
     * setParent :
     * @param parent 
     */

     void setParent(String parent);


} //WikittyAuthorisation
