package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  abstract class WikittyAuthorisationAbstract extends BusinessEntityWikitty implements WikittyAuthorisation {

    /**
     * the metaExtension operations target this extension, may be null
     */
    protected WikittyExtension extensionForMetaExtension;
    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionWikittyAuthorisation;
    /**
     * addMetaExtension :
     * add WikittyAuthorisation meta-extension on given extension to this entity
     * @param extension 
     */

    @Override
    public void addMetaExtension(WikittyExtension extension) {
        extensionForMetaExtension = extension;
        WikittyAuthorisationHelper.addMetaExtension(extension, getWikitty());
}

    /**
     * getOwner :
     * @return String 
     */

    @Override
    public String getOwner() {
        String value;
        if (extensionForMetaExtension == null) {
            value = WikittyAuthorisationHelper.getOwner(getWikitty());
        } else {
            value = WikittyAuthorisationHelper.getOwner(extensionForMetaExtension.getName(), getWikitty());
        }
        return value;
}

    /**
     * setOwner :
     * @param Owner 
     */

    @Override
    public void setOwner(String Owner) {
        String oldValue;
        if (extensionForMetaExtension == null) {
            oldValue = getOwner();
            WikittyAuthorisationHelper.setOwner(getWikitty(), Owner);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_OWNER, oldValue, getOwner());
        } else {
            oldValue = getOwner();
            WikittyAuthorisationHelper.setOwner(extensionForMetaExtension.getName(), getWikitty(), Owner);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "Owner");
            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getOwner());
        }
}

    /**
     * getAdmin :
     * @return Set<String> 
     */

    @Override
    public Set<String> getAdmin() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyAuthorisationHelper.getAdmin(getWikitty());
        } else {
            result = WikittyAuthorisationHelper.getAdmin(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    /**
     * addAdmin :
     * @param element 
     */

    @Override
    public void addAdmin(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addAdmin(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
        } else {
            WikittyAuthorisationHelper.addAdmin(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "Admin");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getAdmin());
        }
}

    /**
     * removeAdmin :
     * @param element 
     */

    @Override
    public void removeAdmin(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.removeAdmin(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
        } else {
            WikittyAuthorisationHelper.removeAdmin(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "Admin");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getAdmin());
        }
}

    /**
     * clearAdmin :
     */

    @Override
    public void clearAdmin() {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.clearAdmin(getWikitty());
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_ADMIN, null, getAdmin());
        } else {
            WikittyAuthorisationHelper.clearAdmin(extensionForMetaExtension.getName(), getWikitty());
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "Admin");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getAdmin());
        }
}

    /**
     * getWriter :
     * @return Set<String> 
     */

    @Override
    public Set<String> getWriter() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyAuthorisationHelper.getWriter(getWikitty());
        } else {
            result = WikittyAuthorisationHelper.getWriter(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    /**
     * addWriter :
     * @param element 
     */

    @Override
    public void addWriter(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addWriter(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
        } else {
            WikittyAuthorisationHelper.addWriter(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "Writer");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getWriter());
        }
}

    /**
     * removeWriter :
     * @param element 
     */

    @Override
    public void removeWriter(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.removeWriter(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
        } else {
            WikittyAuthorisationHelper.removeWriter(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "Writer");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getWriter());
        }
}

    /**
     * clearWriter :
     */

    @Override
    public void clearWriter() {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.clearWriter(getWikitty());
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_WRITER, null, getWriter());
        } else {
            WikittyAuthorisationHelper.clearWriter(extensionForMetaExtension.getName(), getWikitty());
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "Writer");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getWriter());
        }
}

    /**
     * getReader :
     * @return Set<String> 
     */

    @Override
    public Set<String> getReader() {
        Set<String> result;
        if (extensionForMetaExtension == null) {
            result = WikittyAuthorisationHelper.getReader(getWikitty());
        } else {
            result = WikittyAuthorisationHelper.getReader(extensionForMetaExtension.getName(), getWikitty());
        }
        return result;
}

    /**
     * addReader :
     * @param element 
     */

    @Override
    public void addReader(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.addReader(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
        } else {
            WikittyAuthorisationHelper.addReader(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "Reader");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getReader());
        }
}

    /**
     * removeReader :
     * @param element 
     */

    @Override
    public void removeReader(String element) {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.removeReader(getWikitty(), element);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
        } else {
            WikittyAuthorisationHelper.removeReader(extensionForMetaExtension.getName(), getWikitty(), element);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "Reader");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getReader());
        }
}

    /**
     * clearReader :
     */

    @Override
    public void clearReader() {
        if (extensionForMetaExtension == null) {
            WikittyAuthorisationHelper.clearReader(getWikitty());
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_READER, null, getReader());
        } else {
            WikittyAuthorisationHelper.clearReader(extensionForMetaExtension.getName(), getWikitty());
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "Reader");
            getPropertyChangeSupport().firePropertyChange(fieldName, null, getReader());
        }
}

    /**
     * getParent :
     * @return String 
     */

    @Override
    public String getParent() {
        String value;
        if (extensionForMetaExtension == null) {
            value = WikittyAuthorisationHelper.getParent(getWikitty());
        } else {
            value = WikittyAuthorisationHelper.getParent(extensionForMetaExtension.getName(), getWikitty());
        }
        return value;
}

    /**
     * setParent :
     * @param parent 
     */

    @Override
    public void setParent(String parent) {
        String oldValue;
        if (extensionForMetaExtension == null) {
            oldValue = getParent();
            WikittyAuthorisationHelper.setParent(getWikitty(), parent);
            getPropertyChangeSupport().firePropertyChange(WikittyAuthorisation.FIELD_WIKITTYAUTHORISATION_PARENT, oldValue, getParent());
        } else {
            oldValue = getParent();
            WikittyAuthorisationHelper.setParent(extensionForMetaExtension.getName(), getWikitty(), parent);
            String fieldName = WikittyAuthorisationHelper.getMetaFieldName(extensionForMetaExtension, "parent");
            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, getParent());
        }
}

    /**
     * WikittyAuthorisationAbstract :
     */

    public WikittyAuthorisationAbstract() {
        super();
}

    /**
     * WikittyAuthorisationAbstract :
     * @param wikitty 
     */

    public WikittyAuthorisationAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * WikittyAuthorisationAbstract :
     * @param businessEntityWikitty 
     */

    public WikittyAuthorisationAbstract(BusinessEntityWikitty businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionWikittyAuthorisation =
                new WikittyExtension(EXT_WIKITTYAUTHORISATION,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Wikitty Owner unique=true", 
                                             "Wikitty Admin[0-*] unique=true", 
                                             "Wikitty Writer[0-*] unique=true", 
                                             "Wikitty Reader[0-*] unique=true", 
                                             "Wikitty parent[0-1] unique=true documentation=\"Pointe sur un autre WikittyAuthorisation qui permet d'indiquer que les droits de l'objet courant sont les mêmes que l'objet pointée. Les droits de l'objet courant s'ajoute au droit de l'objet pointé\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyAuthorisation);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //WikittyAuthorisationAbstract
