package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class WikittyGroupAbstract extends BusinessEntityWikitty implements WikittyGroup {

    private static final long serialVersionUID = 1375406597L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionWikittyGroup =
        new WikittyExtension(EXT_WIKITTYGROUP, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String name",
				"String members[0-*] unique=true"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionWikittyGroup);

        extensions = Collections.unmodifiableList(exts);
    }

	public WikittyGroupAbstract() {
		super();
	}

    public WikittyGroupAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public WikittyGroupAbstract(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        Object oldValue = getField(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_NAME);
        getWikitty().setField(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_NAME, name);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYGROUP_NAME, oldValue, name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_NAME);
        return result;
    }

    public Set<String> getMembers() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_MEMBERS, String.class);
        return result;
    }

    public void addMembers(String element) {
        getWikitty().addToField(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_MEMBERS, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYGROUP_MEMBERS, null, getMembers());
    }
    
    public void removeMembers(String element) {
        getWikitty().removeFromField(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_MEMBERS, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYGROUP_MEMBERS, null, getMembers());
    }
    
    public void clearMembers() {
        getWikitty().clearField(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_MEMBERS);
        getPropertyChangeSupport().firePropertyChange(FIELD_WIKITTYGROUP_MEMBERS, null, getMembers());
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_NAME);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_MEMBERS);
            Object f2 = w2.getFieldAsObject(EXT_WIKITTYGROUP, FIELD_WIKITTYGROUP_MEMBERS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //WikittyGroupAbstract
