/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityUser;

public abstract class SecurityUserAbstract
extends AbstractTopiaEntity
implements SecurityUser {
    protected String login;
    protected String password;
    protected String externalId;
    protected Collection<SecurityRole> securityRole;
    private static final long serialVersionUID = 3631647531095843635L;

    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "login", String.class, (Object)this.login);
        visitor.visit((TopiaEntity)this, "password", String.class, (Object)this.password);
        visitor.visit((TopiaEntity)this, "externalId", String.class, (Object)this.externalId);
        visitor.visit((TopiaEntity)this, "securityRole", Collection.class, SecurityRole.class, this.securityRole);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        this.fireOnPreWrite("login", oldValue, login);
        this.login = login;
        this.fireOnPostWrite("login", oldValue, login);
    }

    @Override
    public String getLogin() {
        this.fireOnPreRead("login", this.login);
        String result = this.login;
        this.fireOnPostRead("login", this.login);
        return result;
    }

    @Override
    public void setPassword(String password) {
        String oldValue = this.password;
        this.fireOnPreWrite("password", oldValue, password);
        this.password = password;
        this.fireOnPostWrite("password", oldValue, password);
    }

    @Override
    public String getPassword() {
        this.fireOnPreRead("password", this.password);
        String result = this.password;
        this.fireOnPostRead("password", this.password);
        return result;
    }

    @Override
    public void setExternalId(String externalId) {
        String oldValue = this.externalId;
        this.fireOnPreWrite("externalId", oldValue, externalId);
        this.externalId = externalId;
        this.fireOnPostWrite("externalId", oldValue, externalId);
    }

    @Override
    public String getExternalId() {
        this.fireOnPreRead("externalId", this.externalId);
        String result = this.externalId;
        this.fireOnPostRead("externalId", this.externalId);
        return result;
    }

    @Override
    public void addSecurityRole(SecurityRole securityRole) {
        this.fireOnPreWrite("securityRole", null, securityRole);
        if (this.securityRole == null) {
            this.securityRole = new ArrayList<SecurityRole>();
        }
        this.securityRole.add(securityRole);
        this.fireOnPostWrite("securityRole", this.securityRole.size(), null, securityRole);
    }

    @Override
    public void addAllSecurityRole(Collection<SecurityRole> securityRole) {
        if (securityRole == null) {
            return;
        }
        for (SecurityRole item : securityRole) {
            this.addSecurityRole(item);
        }
    }

    @Override
    public void setSecurityRole(Collection<SecurityRole> securityRole) {
        ArrayList<SecurityRole> oldValue = this.securityRole != null ? new ArrayList<SecurityRole>(this.securityRole) : null;
        this.fireOnPreWrite("securityRole", oldValue, securityRole);
        this.securityRole = securityRole;
        this.fireOnPostWrite("securityRole", oldValue, securityRole);
    }

    @Override
    public void removeSecurityRole(SecurityRole securityRole) {
        this.fireOnPreWrite("securityRole", securityRole, null);
        if (this.securityRole == null || !this.securityRole.remove(securityRole)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("securityRole", this.securityRole.size() + 1, securityRole, null);
    }

    @Override
    public void clearSecurityRole() {
        if (this.securityRole == null) {
            return;
        }
        ArrayList<SecurityRole> oldValue = new ArrayList<SecurityRole>(this.securityRole);
        this.fireOnPreWrite("securityRole", oldValue, this.securityRole);
        this.securityRole.clear();
        this.fireOnPostWrite("securityRole", oldValue, this.securityRole);
    }

    @Override
    public Collection<SecurityRole> getSecurityRole() {
        return this.securityRole;
    }

    @Override
    public SecurityRole getSecurityRoleByTopiaId(String topiaId) {
        return (SecurityRole)TopiaEntityHelper.getEntityByTopiaId(this.securityRole, (String)topiaId);
    }

    @Override
    public Collection<String> getSecurityRoleTopiaIds() {
        ArrayList<String> topiaIds = new ArrayList<String>();
        Collection<SecurityRole> tmp = this.getSecurityRole();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSecurityRole() {
        if (this.securityRole == null) {
            return 0;
        }
        return this.securityRole.size();
    }

    @Override
    public boolean isSecurityRoleEmpty() {
        int size = this.sizeSecurityRole();
        return size == 0;
    }

    @Override
    public boolean isSecurityRoleNotEmpty() {
        boolean empty = this.isSecurityRoleEmpty();
        return !empty;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("login", (Object)this.login).append("password", (Object)this.password).append("externalId", (Object)this.externalId).append("securityRole", this.securityRole).toString();
        return result;
    }
}

