/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch;

import com.google.common.collect.ImmutableSet;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.service.sql.batch.actions.AbstractSchemaRequest;
import org.nuiton.topia.service.sql.batch.actions.AbstractSqlRequest;
import org.nuiton.topia.service.sql.batch.actions.AbstractTablesRequest;
import org.nuiton.topia.service.sql.batch.actions.CreateSchemaRequest;
import org.nuiton.topia.service.sql.batch.actions.DeleteTablesRequest;
import org.nuiton.topia.service.sql.batch.actions.DropSchemaRequest;
import org.nuiton.topia.service.sql.batch.actions.ReplicateTablesRequest;
import org.nuiton.topia.service.sql.batch.actions.TopiaSqlTableSelectArgument;
import org.nuiton.topia.service.sql.batch.actions.UpdateTablesRequest;
import org.nuiton.topia.service.sql.batch.tables.TopiaSqlTables;

public class SqlRequests
implements Iterable<AbstractSqlRequest> {
    protected final ImmutableSet<AbstractSqlRequest> requests;

    protected SqlRequests(ImmutableSet<AbstractSqlRequest> requests) {
        this.requests = requests;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static <R extends AbstractSqlRequest> SqlRequests of(R request) {
        return SqlRequests.builder().from(request.getSourceTopiaApplicationContext()).to(request.getTargetTopiaApplicationContext()).to(request.getWriter()).addRequest(request).build();
    }

    @Override
    public Iterator<AbstractSqlRequest> iterator() {
        return this.requests.iterator();
    }

    protected static class AbstractTablesRequestBuilder<R extends AbstractTablesRequest.AbstractTablesRequestBuilder, B extends AbstractTablesRequestBuilder>
    extends RequestBuilderImpl<R, B> {
        protected AbstractTablesRequestBuilder(BuilderImpl builder, R delegate) {
            super(builder, delegate);
        }

        public B setTables(TopiaSqlTables tables) {
            ((AbstractTablesRequest.AbstractTablesRequestBuilder)this.delegate).setTables(tables);
            return (B)((AbstractTablesRequestBuilder)this.returnThis());
        }

        public B setFetchSize(int fetchSize) {
            ((AbstractTablesRequest.AbstractTablesRequestBuilder)this.delegate).setReadFetchSize(fetchSize);
            return (B)((AbstractTablesRequestBuilder)this.returnThis());
        }

        public B setSelectArgument(TopiaSqlTableSelectArgument arg) {
            ((AbstractTablesRequest.AbstractTablesRequestBuilder)this.delegate).setSelectArgument(arg);
            return (B)((AbstractTablesRequestBuilder)this.returnThis());
        }
    }

    protected static class AbstractSchemaRequestBuilder<R extends AbstractSchemaRequest.AbstractSchemaRequestBuilder, B extends AbstractSchemaRequestBuilder>
    extends RequestBuilderImpl<R, B> {
        protected AbstractSchemaRequestBuilder(BuilderImpl builder, R delegate) {
            super(builder, delegate);
        }

        public B forH2() {
            ((AbstractSchemaRequest.AbstractSchemaRequestBuilder)this.delegate).forH2();
            return (B)((AbstractSchemaRequestBuilder)this.returnThis());
        }

        public B forPostgres() {
            ((AbstractSchemaRequest.AbstractSchemaRequestBuilder)this.delegate).forPostgres();
            return (B)((AbstractSchemaRequestBuilder)this.returnThis());
        }

        public B setDialect(Class<? extends Dialect> dialectType) {
            ((AbstractSchemaRequest.AbstractSchemaRequestBuilder)this.delegate).setDialect(dialectType);
            return (B)((AbstractSchemaRequestBuilder)this.returnThis());
        }

        public B setTemporaryPath(Path temporaryPath) {
            ((AbstractSchemaRequest.AbstractSchemaRequestBuilder)this.delegate).setTemporaryPath(temporaryPath);
            return (B)((AbstractSchemaRequestBuilder)this.returnThis());
        }
    }

    protected static abstract class RequestBuilderImpl<R extends AbstractSqlRequest.AbstractSqlRequestBuilder, B extends RequestBuilderImpl>
    implements BuilderAddRequestStep {
        protected final Builder builder;
        protected final R delegate;

        protected RequestBuilderImpl(BuilderImpl builder, R delegate) {
            this.builder = builder;
            this.delegate = delegate;
        }

        @Override
        public CreateSchemaRequestBuilder createSchemaBuilder() {
            return this.flush().createSchemaBuilder();
        }

        @Override
        public DropSchemaRequestBuilder dropSchemaBuilder() {
            return this.flush().dropSchemaBuilder();
        }

        @Override
        public ReplicateTablesRequestBuilder replicateTablesBuilder() {
            return this.flush().replicateTablesBuilder();
        }

        @Override
        public UpdateTablesRequestBuilder updateTablesBuilder() {
            return this.flush().updateTablesBuilder();
        }

        @Override
        public DeleteTablesRequestBuilder deleteTablesBuilder() {
            return this.flush().deleteTablesBuilder();
        }

        @Override
        public BuilderAddRequestStep addCreateSchema(CreateSchemaRequest request) {
            return this.flush().addRequest(request);
        }

        @Override
        public BuilderAddRequestStep addDropSchema(DropSchemaRequest request) {
            return this.flush().addRequest(request);
        }

        @Override
        public BuilderAddRequestStep addReplicateTables(ReplicateTablesRequest request) {
            return this.flush().addRequest(request);
        }

        @Override
        public BuilderAddRequestStep addUpdateTables(UpdateTablesRequest request) {
            return this.flush().addRequest(request);
        }

        @Override
        public BuilderAddRequestStep addDeleteTables(DeleteTablesRequest request) {
            return this.addRequest(request);
        }

        @Override
        public <R extends AbstractSqlRequest> BuilderAddRequestStep addRequest(R request) {
            return this.builder.addRequest(request);
        }

        @Override
        public SqlRequests build() {
            return this.flush().build();
        }

        @Override
        public Builder flush() {
            this.addRequest(((AbstractSqlRequest.AbstractSqlRequestBuilder)this.delegate).build());
            return this.builder;
        }

        protected B returnThis() {
            return (B)this;
        }
    }

    public static class DeleteTablesRequestBuilder
    extends AbstractTablesRequestBuilder<DeleteTablesRequest.Builder, DeleteTablesRequestBuilder> {
        public DeleteTablesRequestBuilder(BuilderImpl builder, DeleteTablesRequest.Builder delegate) {
            super(builder, delegate);
        }
    }

    public static class UpdateTablesRequestBuilder
    extends AbstractTablesRequestBuilder<UpdateTablesRequest.Builder, UpdateTablesRequestBuilder> {
        public UpdateTablesRequestBuilder(BuilderImpl builder, UpdateTablesRequest.Builder delegate) {
            super(builder, delegate);
        }
    }

    public static class ReplicateTablesRequestBuilder
    extends AbstractTablesRequestBuilder<ReplicateTablesRequest.Builder, ReplicateTablesRequestBuilder> {
        public ReplicateTablesRequestBuilder(BuilderImpl builder, ReplicateTablesRequest.Builder delegate) {
            super(builder, delegate);
        }
    }

    public static class DropSchemaRequestBuilder
    extends AbstractSchemaRequestBuilder<DropSchemaRequest.Builder, DropSchemaRequestBuilder> {
        public DropSchemaRequestBuilder(BuilderImpl builder, DropSchemaRequest.Builder delegate) {
            super(builder, delegate);
        }

        public DropSchemaRequestBuilder setDropSchema(boolean dropSchema) {
            ((DropSchemaRequest.Builder)this.delegate).setDropSchema(dropSchema);
            return this;
        }
    }

    public static class CreateSchemaRequestBuilder
    extends AbstractSchemaRequestBuilder<CreateSchemaRequest.Builder, CreateSchemaRequestBuilder> {
        public CreateSchemaRequestBuilder(BuilderImpl builder, CreateSchemaRequest.Builder delegate) {
            super(builder, delegate);
        }

        public CreateSchemaRequestBuilder setAddSchema(boolean addSchema) {
            ((CreateSchemaRequest.Builder)this.delegate).setAddSchema(addSchema);
            return this;
        }
    }

    protected static class BuilderImpl
    implements Builder {
        protected final ImmutableSet.Builder<AbstractSqlRequest> requestsBuilder = ImmutableSet.builder();
        protected TopiaApplicationContext sourceTopiaApplicationContext;
        protected TopiaApplicationContext targetTopiaApplicationContext;
        protected Writer writer;

        protected BuilderImpl() {
        }

        @Override
        public Builder from(TopiaApplicationContext sourceTopiaApplicationContext) {
            this.sourceTopiaApplicationContext = sourceTopiaApplicationContext;
            return this;
        }

        @Override
        public Builder to(TopiaApplicationContext targetTopiaApplicationContext) {
            this.targetTopiaApplicationContext = targetTopiaApplicationContext;
            return this;
        }

        @Override
        public Builder to(Writer writer) {
            this.writer = writer;
            return this;
        }

        @Override
        public SqlRequests build() {
            return new SqlRequests((ImmutableSet<AbstractSqlRequest>)this.requestsBuilder.build());
        }

        @Override
        public <R extends AbstractSqlRequest> Builder addRequest(R request) {
            this.requestsBuilder.add(request);
            return this;
        }

        @Override
        public CreateSchemaRequestBuilder createSchemaBuilder() {
            return new CreateSchemaRequestBuilder(this, this.initBuilder(CreateSchemaRequest.builder()));
        }

        @Override
        public DropSchemaRequestBuilder dropSchemaBuilder() {
            return new DropSchemaRequestBuilder(this, this.initBuilder(DropSchemaRequest.builder()));
        }

        @Override
        public ReplicateTablesRequestBuilder replicateTablesBuilder() {
            return new ReplicateTablesRequestBuilder(this, this.initBuilder(new ReplicateTablesRequest.Builder()));
        }

        @Override
        public UpdateTablesRequestBuilder updateTablesBuilder() {
            return new UpdateTablesRequestBuilder(this, this.initBuilder(new UpdateTablesRequest.Builder()));
        }

        @Override
        public DeleteTablesRequestBuilder deleteTablesBuilder() {
            return new DeleteTablesRequestBuilder(this, this.initBuilder(new DeleteTablesRequest.Builder()));
        }

        @Override
        public BuilderAddRequestStep addCreateSchema(CreateSchemaRequest request) {
            return this.addRequest(request);
        }

        @Override
        public BuilderAddRequestStep addDropSchema(DropSchemaRequest request) {
            return this.addRequest(request);
        }

        @Override
        public BuilderAddRequestStep addReplicateTables(ReplicateTablesRequest request) {
            return this.addRequest(request);
        }

        @Override
        public BuilderAddRequestStep addUpdateTables(UpdateTablesRequest request) {
            return this.addRequest(request);
        }

        @Override
        public BuilderAddRequestStep addDeleteTables(DeleteTablesRequest request) {
            return this.addRequest(request);
        }

        @Override
        public Builder flush() {
            return this;
        }

        protected <B extends AbstractSqlRequest.AbstractSqlRequestBuilder<B, ?>> B initBuilder(B builder) {
            return ((AbstractSqlRequest.AbstractSqlRequestBuilder)((AbstractSqlRequest.AbstractSqlRequestBuilder)builder.from(this.sourceTopiaApplicationContext)).to(this.targetTopiaApplicationContext)).to(this.writer);
        }
    }

    static interface BuilderAddRequestStep {
        public CreateSchemaRequestBuilder createSchemaBuilder();

        public DropSchemaRequestBuilder dropSchemaBuilder();

        public ReplicateTablesRequestBuilder replicateTablesBuilder();

        public UpdateTablesRequestBuilder updateTablesBuilder();

        public DeleteTablesRequestBuilder deleteTablesBuilder();

        public BuilderAddRequestStep addCreateSchema(CreateSchemaRequest var1);

        public BuilderAddRequestStep addDropSchema(DropSchemaRequest var1);

        public BuilderAddRequestStep addReplicateTables(ReplicateTablesRequest var1);

        public BuilderAddRequestStep addUpdateTables(UpdateTablesRequest var1);

        public BuilderAddRequestStep addDeleteTables(DeleteTablesRequest var1);

        public <R extends AbstractSqlRequest> BuilderAddRequestStep addRequest(R var1);

        public Builder flush();

        public SqlRequests build();
    }

    public static interface Builder
    extends BuilderAddRequestStep {
        public Builder from(TopiaApplicationContext var1);

        public Builder to(TopiaApplicationContext var1);

        public Builder to(Writer var1);
    }
}

