/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.replication.TopiaReplicationContext;
import org.nuiton.topia.replication.TopiaReplicationModelBuilder;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.TopiaReplicationOperationUndoable;
import org.nuiton.topia.replication.TopiaReplicationService;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;

public class TopiaReplicationServiceImpl
implements TopiaReplicationService {
    private static final Log log = LogFactory.getLog(TopiaReplicationServiceImpl.class);
    protected TopiaApplicationContext context;
    protected TopiaReplicationModelBuilder modelBuilder;

    public void initTopiaService(TopiaApplicationContext topiaApplicationContext, Map<String, String> serviceConfiguration) {
        if (!serviceConfiguration.isEmpty() && log.isWarnEnabled()) {
            log.warn((Object)"no configuration expected for replication service");
        }
        this.context = topiaApplicationContext;
    }

    @Override
    public ReplicationModel prepare(TopiaEntityEnum[] contracts, boolean computeOrder, String ... topiaIds) throws TopiaException {
        ReplicationModel model = this.getModelBuilder().prepare(this.context, contracts, computeOrder, topiaIds);
        return model;
    }

    @Override
    public ReplicationModel prepareForAll(TopiaEntityEnum[] contracts) throws TopiaException {
        ReplicationModel model = this.getModelBuilder().prepareForAll(contracts);
        return model;
    }

    @Override
    public TopiaReplicationModelBuilder getModelBuilder() {
        if (this.modelBuilder == null) {
            this.modelBuilder = new TopiaReplicationModelBuilder();
        }
        return this.modelBuilder;
    }

    @Override
    public void doReplicate(ReplicationModel model, TopiaApplicationContext targetTx) throws Exception {
        TopiaEntityHelper.checkNotNull((String)"doReplicate", (String)"model", (Object)model);
        TopiaEntityHelper.checkNotNull((String)"doReplicate", (String)"dstCtxt", (Object)targetTx);
        TopiaReplicationContext replicationContext = new TopiaReplicationContext(this.getModelBuilder().getOperationProvider(), model, this.context, targetTx);
        replicationContext.init();
        ReplicationNode currentNode = null;
        try {
            Iterator<ReplicationNode> i$ = model.getOrder().iterator();
            while (i$.hasNext()) {
                ReplicationNode node;
                currentNode = node = i$.next();
                this.doReplicateNode(replicationContext, node);
                replicationContext.addTreatedNode(node);
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not replicate node " + currentNode), (Throwable)e);
            }
            this.doRollback(replicationContext);
            throw e;
        }
        finally {
            replicationContext.clear();
        }
    }

    @Override
    public void doRollback(TopiaReplicationContext replicationContext) throws Exception {
        TopiaEntityHelper.checkNotNull((String)"doRollback", (String)"replicationContext", (Object)replicationContext);
        ReplicationNode[] treated = replicationContext.getReverseTreated();
        if (treated.length == 0) {
            return;
        }
        log.info((Object)("Will rollback " + treated.length + " nodes..."));
        for (ReplicationNode node : treated) {
            try {
                this.doRollbackNode(replicationContext, node);
            }
            catch (Exception e) {
                log.error((Object)("Could not rollback node " + node), (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReplicateNode(TopiaReplicationContext replicationContext, ReplicationNode node) throws Exception {
        ReplicationOperationDef[] defs = node.getOperations();
        if (defs.length == 0) {
            log.info((Object)("skip node " + node + " - no operation detected."));
            return;
        }
        TopiaPersistenceContext dstCtxt = null;
        TopiaPersistenceContext srcCtxt = replicationContext.newSourceTx();
        try {
            log.info((Object)("start replication for " + node + " : " + defs.length + " operation(s)"));
            List<? extends TopiaEntity> entities = replicationContext.getEntities(srcCtxt, node);
            if (log.isInfoEnabled()) {
                log.info((Object)("will replicate on " + entities.size() + " entity(ies)"));
            }
            if (log.isDebugEnabled()) {
                for (TopiaEntity topiaEntity : entities) {
                    log.debug((Object)topiaEntity.getTopiaId());
                }
            }
            dstCtxt = replicationContext.newTargetTx();
            for (ReplicationOperationDef def : defs) {
                log.info((Object)("start operation " + def));
                TopiaReplicationOperation operation = replicationContext.getOperation(def);
                if (!node.equals(def.getNode())) {
                    entities = replicationContext.getEntities(srcCtxt, def.getNode());
                }
                operation.run(replicationContext, def, srcCtxt, dstCtxt, entities);
            }
        }
        catch (Throwable throwable) {
            try {
                TopiaReplicationContext.close(srcCtxt, true);
            }
            finally {
                if (dstCtxt != null) {
                    TopiaReplicationContext.close(dstCtxt, true);
                }
            }
            throw throwable;
        }
        try {
            TopiaReplicationContext.close(srcCtxt, true);
        }
        finally {
            if (dstCtxt != null) {
                TopiaReplicationContext.close(dstCtxt, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRollbackNode(TopiaReplicationContext replicationContext, ReplicationNode node) throws Exception {
        ReplicationOperationDef[] defs = node.getUndoableOperations();
        if (defs.length == 0) {
            log.info((Object)("skip node " + node + " - no reversible operation detected."));
            return;
        }
        log.info((Object)("start rollback for " + node + " : " + defs.length + " reversible operation(s)"));
        TopiaPersistenceContext dstCtxt = replicationContext.newTargetTx();
        try {
            for (ReplicationOperationDef def : defs) {
                log.info((Object)("start rollback operation " + def));
                TopiaReplicationOperationUndoable operation = replicationContext.getUndoableOperation(def);
                operation.rollback(def, replicationContext, dstCtxt);
            }
        }
        finally {
            if (dstCtxt != null) {
                TopiaReplicationContext.close(dstCtxt, true);
            }
        }
    }

    public void close() {
    }
}

