/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication.operation;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.TopiaReplicationDestination;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContext;
import org.nuiton.topia.replication.TopiaReplicationContext;
import org.nuiton.topia.replication.TopiaReplicationOperationUndoable;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;

public class Duplicate
implements TopiaReplicationOperationUndoable {
    private static final Log log = LogFactory.getLog(Duplicate.class);

    @Override
    public void register(ReplicationModel model, ReplicationNode ownerNode, ReplicationOperationPhase phase, Object ... parameters) throws UnsupportedOperationException {
    }

    @Override
    public void run(TopiaReplicationContext replicationContext, ReplicationOperationDef operationDef, TopiaPersistenceContext srcCtxt, TopiaPersistenceContext dstCtxt, List<? extends TopiaEntity> entities) throws TopiaException {
        if (srcCtxt instanceof AbstractTopiaPersistenceContext) {
            ((AbstractTopiaPersistenceContext)srcCtxt).getHibernateSupport().getHibernateSession().clear();
        }
        srcCtxt.replicateEntities((TopiaReplicationDestination)dstCtxt, entities);
        dstCtxt.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(ReplicationOperationDef operationDef, TopiaReplicationContext replicationContext, TopiaPersistenceContext dstCtxt) throws Exception {
        List<String> ids = replicationContext.getEntityIds(operationDef.getNode());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Class<? extends TopiaEntity> entityClass = operationDef.getEntityType();
        TopiaDao dao = dstCtxt.getDao(entityClass);
        List allIds = dao.findAllIds();
        try {
            for (String id : ids) {
                if (!allIds.contains(id)) continue;
                log.info((Object)("Will delete " + id));
                TopiaEntity entity = dao.findByTopiaId(id);
                dao.delete(entity);
            }
        }
        finally {
            allIds.clear();
            dstCtxt.commit();
        }
    }
}

