package org.nuiton.topia.history.entities;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class HistoryDAOAbstract<E extends History> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)History.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByActionDate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut actionDate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByActionDate(Date v) throws TopiaException {
        E result = findByProperty("actionDate", v);
        return result;
    }

    /**
     * findAllByActionDate :
     * Retourne les éléments ayant comme valeur pour l'attribut actionDate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByActionDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty("actionDate", v);
        return result;
    }

    /**
     * findByUserId :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut userId le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByUserId(String v) throws TopiaException {
        E result = findByProperty("userId", v);
        return result;
    }

    /**
     * findAllByUserId :
     * Retourne les éléments ayant comme valeur pour l'attribut userId le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByUserId(String v) throws TopiaException {
        List<E> result = findAllByProperty("userId", v);
        return result;
    }

    /**
     * findByAction :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut action le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAction(int v) throws TopiaException {
        E result = findByProperty("action", v);
        return result;
    }

    /**
     * findAllByAction :
     * Retourne les éléments ayant comme valeur pour l'attribut action le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAction(int v) throws TopiaException {
        List<E> result = findAllByProperty("action", v);
        return result;
    }

    /**
     * findByType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut type le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByType(String v) throws TopiaException {
        E result = findByProperty("type", v);
        return result;
    }

    /**
     * findAllByType :
     * Retourne les éléments ayant comme valeur pour l'attribut type le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByType(String v) throws TopiaException {
        List<E> result = findAllByProperty("type", v);
        return result;
    }

    /**
     * findByTarget :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut target le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByTarget(String v) throws TopiaException {
        E result = findByProperty("target", v);
        return result;
    }

    /**
     * findAllByTarget :
     * Retourne les éléments ayant comme valeur pour l'attribut target le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByTarget(String v) throws TopiaException {
        List<E> result = findAllByProperty("target", v);
        return result;
    }


} //HistoryDAOAbstract<E extends History>
