/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import jakarta.persistence.FlushModeType;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.query.Query;
import org.nuiton.topia.persistence.QueryMissingOrderException;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaNonUniqueResultException;
import org.nuiton.topia.persistence.TopiaQueryException;
import org.nuiton.topia.persistence.internal.support.SlowQueryWatcher;
import org.nuiton.topia.persistence.internal.support.TopiaFiresSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.support.TopiaJpaSupport;

public class HibernateTopiaJpaSupport
implements TopiaJpaSupport {
    private static final Log log = LogFactory.getLog(HibernateTopiaJpaSupport.class);
    protected TopiaHibernateSupport hibernateSupport;
    protected TopiaFiresSupport firesSupport;
    protected boolean useFlushMode = true;
    protected Optional<Duration> slowQueriesThreshold;

    public HibernateTopiaJpaSupport(TopiaHibernateSupport hibernateSupport, TopiaFiresSupport firesSupport, Optional<Duration> slowQueriesThreshold) {
        this.hibernateSupport = hibernateSupport;
        this.firesSupport = firesSupport;
        this.slowQueriesThreshold = slowQueriesThreshold;
    }

    public TopiaHibernateSupport getHibernateSupport() {
        return this.hibernateSupport;
    }

    @Override
    public void setUseFlushMode(boolean useFlushMode) {
        this.useFlushMode = useFlushMode;
    }

    @Override
    public void setSlowQueriesThreshold(Duration slowQueriesThreshold) {
        this.slowQueriesThreshold = Optional.ofNullable(slowQueriesThreshold);
    }

    protected Query prepareQuery(String jpaql, Map<String, Object> parameters) {
        this.checkHqlParameters(parameters);
        Query query = this.hibernateSupport.getHibernateSession().createQuery(jpaql);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            Object unproxyfied = Hibernate.unproxy((Object)value);
            if (value.getClass().isArray()) {
                query.setParameterList(name, (Object[])unproxyfied);
                continue;
            }
            if (value instanceof Collection) {
                query.setParameterList(name, (Collection)unproxyfied);
                continue;
            }
            query.setParameter(name, unproxyfied);
        }
        if (this.useFlushMode) {
            query.setFlushMode(FlushModeType.AUTO);
        }
        return query;
    }

    protected void checkHqlParameters(Map<String, Object> parameters) {
        Preconditions.checkArgument((!parameters.containsKey("object") ? 1 : 0) != 0, (Object)"'object' is not a valid parameter name in HQL");
    }

    @Override
    public <T> List<T> findAll(String jpaql, Map<String, Object> parameters) {
        Query query = this.prepareQuery(jpaql, parameters);
        SlowQueryWatcher ignored = this.monitorQuery(query, parameters);
        try {
            List result = query.list();
            List list = result = this.firesSupport.fireEntitiesLoad(this, result);
            if (ignored != null) {
                ignored.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MultipleBagFetchException mbfe) {
                throw new TopiaQueryException("unable to fetch multiple bags during findAll: " + String.valueOf(mbfe.getBagRoles()), (Throwable)mbfe, jpaql, parameters);
            }
            catch (HibernateException he) {
                throw new TopiaQueryException("unable to findAll", (Throwable)he, jpaql, parameters);
            }
            catch (RuntimeException re) {
                throw new TopiaQueryException("unable to findAll", (Throwable)re, jpaql, parameters);
            }
        }
    }

    @Override
    public <T> Stream<T> stream(String jpaql, Map<String, Object> parameters) {
        try {
            Query query = this.prepareQuery(jpaql, parameters);
            Stream result = query.stream();
            Consumer<Object> consumer = row -> {
                List<Object> singleton = Collections.singletonList(row);
                this.firesSupport.fireEntitiesLoad(this, singleton);
            };
            return result.peek(consumer);
        }
        catch (MultipleBagFetchException mbfe) {
            throw new TopiaQueryException("unable to fetch multiple bags during " + String.valueOf(mbfe.getBagRoles()), (Throwable)mbfe, jpaql, parameters);
        }
        catch (HibernateException he) {
            throw new TopiaQueryException("unable to stream", (Throwable)he, jpaql, parameters);
        }
        catch (RuntimeException re) {
            throw new TopiaQueryException("unable to stream", (Throwable)re, jpaql, parameters);
        }
    }

    @Override
    public <T> T findAny(String jpaql, Map<String, Object> parameters) {
        List<T> results = this.find0(jpaql, 0, 0, parameters);
        Object result = Iterables.getOnlyElement(results, null);
        return (T)result;
    }

    @Override
    public <T> T findUnique(String jpaql, Map<String, Object> parameters) {
        List<T> results = this.find0(jpaql, 0, 1, parameters);
        if (results.size() > 1) {
            String message = String.format("Query '%s' returns more than 1 unique result", jpaql);
            throw new TopiaNonUniqueResultException(message, parameters);
        }
        Object result = Iterables.getOnlyElement(results, null);
        return (T)result;
    }

    protected boolean hqlContainsOrderBy(String hql) {
        return hql.toLowerCase().contains("order by");
    }

    @Override
    public <T> List<T> find(String jpaql, int startIndex, int endIndex, Map<String, Object> parameters) throws QueryMissingOrderException {
        if (!this.hqlContainsOrderBy(jpaql)) {
            throw new QueryMissingOrderException(jpaql, parameters);
        }
        List<T> result = this.find0(jpaql, startIndex, endIndex, parameters);
        return result;
    }

    protected <T> List<T> find0(String jpaql, int startIndex, int endIndex, Map<String, Object> parameters) {
        Query query = this.prepareQuery(jpaql, parameters);
        query.setFirstResult(startIndex);
        if (endIndex >= 0 && endIndex != Integer.MAX_VALUE) {
            Preconditions.checkArgument((startIndex <= endIndex ? 1 : 0) != 0, (Object)("startIndex " + startIndex + " > endIndex" + endIndex));
            query.setMaxResults(endIndex - startIndex + 1);
        }
        SlowQueryWatcher ignored = this.monitorQuery(query, parameters);
        try {
            List result = query.list();
            List list = result = this.firesSupport.fireEntitiesLoad(this, result);
            if (ignored != null) {
                ignored.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MultipleBagFetchException mbfe) {
                throw new TopiaQueryException("unable to fetch multiple bags during find page startIndex=" + startIndex + ", endIndex=" + endIndex + ": " + String.valueOf(mbfe.getBagRoles()), (Throwable)mbfe, jpaql, parameters);
            }
            catch (HibernateException e) {
                throw new TopiaQueryException("unable to find page startIndex=" + startIndex + ", endIndex=" + endIndex, (Throwable)e, jpaql, parameters);
            }
            catch (RuntimeException e) {
                throw new TopiaQueryException("unable to find page startIndex=" + startIndex + ", endIndex=" + endIndex, (Throwable)e, jpaql, parameters);
            }
        }
    }

    @Override
    public int execute(String jpaql, Map<String, Object> parameters) {
        Query query = this.prepareQuery(jpaql, parameters);
        SlowQueryWatcher ignored = this.monitorQuery(query, parameters);
        try {
            int result;
            int n = result = query.executeUpdate();
            if (ignored != null) {
                ignored.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MultipleBagFetchException mbfe) {
                throw new TopiaQueryException("unable to fetch multiple bags during execute: " + String.valueOf(mbfe.getBagRoles()), (Throwable)mbfe, jpaql, parameters);
            }
            catch (HibernateException e) {
                throw new TopiaQueryException("unable to execute query", (Throwable)e, jpaql, parameters);
            }
            catch (RuntimeException e) {
                throw new TopiaQueryException("unable to execute query", (Throwable)e, jpaql, parameters);
            }
        }
    }

    @Override
    public void save(Object object) {
        try {
            this.hibernateSupport.getHibernateSession().save(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'save' instance", eee);
        }
    }

    @Override
    public void update(Object object) {
        try {
            this.hibernateSupport.getHibernateSession().update(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'update' instance", eee);
        }
    }

    @Override
    public void saveOrUpdate(Object object) {
        try {
            this.hibernateSupport.getHibernateSession().saveOrUpdate(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'saveOrUpdate' instance", eee);
        }
    }

    @Override
    public void delete(Object object) {
        try {
            this.hibernateSupport.getHibernateSession().delete(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'delete' instance", eee);
        }
    }

    protected SlowQueryWatcher monitorQuery(Query query, Map<String, Object> args) {
        if (!this.slowQueriesThreshold.isPresent()) {
            return null;
        }
        Supplier<String> descriptionSupplier = () -> {
            String description = "HQL query: " + query.getQueryString();
            if (MapUtils.isNotEmpty((Map)args)) {
                Map<String, Object> notTooLongArgs = this.truncateLongArgs(args, 100);
                description = description + " -- with args: " + String.valueOf(notTooLongArgs);
            }
            return description;
        };
        long thresholdMillis = this.slowQueriesThreshold.get().toMillis();
        SlowQueryWatcher result = SlowQueryWatcher.start(descriptionSupplier, thresholdMillis);
        return result;
    }

    protected Map<String, Object> truncateLongArgs(Map<String, Object> args, int truncateSize) {
        Preconditions.checkNotNull(args);
        Map result = Maps.transformValues(args, value -> {
            Collection collection;
            int size;
            if (value instanceof Collection && (size = (collection = (Collection)value).size()) > truncateSize) {
                Iterable limited = Iterables.limit((Iterable)collection, (int)truncateSize);
                String limitedString = limited.toString();
                String valueAsString = String.format("%s ... and %d more]", StringUtils.removeEnd((String)limitedString, (String)"]"), size - truncateSize);
                return valueAsString;
            }
            return value;
        });
        return result;
    }
}

