/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.sql.Driver;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.BeanTopiaConfiguration;
import org.nuiton.topia.persistence.HibernateTopiaMigrationService;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaMisconfigurationException;
import org.nuiton.topia.persistence.TopiaService;
import org.nuiton.topia.persistence.jdbc.JdbcConfiguration;
import org.nuiton.topia.persistence.jdbc.JdbcConfigurationBuilder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class TopiaConfigurationBuilder {
    protected JdbcConfigurationBuilder jdbcConfigurationBuilder = new JdbcConfigurationBuilder();
    protected static final String TOPIA_SERVICE_CONFIGURATION_PREFIX = "topia.service.";
    protected static final String CONFIG_DEFAULT_SCHEMA = "hibernate.default_schema";
    protected static final String CONFIG_USER = "jakarta.persistence.jdbc.user";
    protected static final String CONFIG_PASS = "jakarta.persistence.jdbc.password";
    protected static final String CONFIG_DRIVER = "jakarta.persistence.jdbc.driver";
    protected static final String CONFIG_URL = "jakarta.persistence.jdbc.url";
    protected static final String CONFIG_PERSISTENCE_TOPIA_ID_FACTORY_CLASS_NAME = "topia.persistence.topiaIdFactoryClassName";
    protected static final String CONFIG_PERSISTENCE_INIT_SCHEMA = "topia.persistence.initSchema";
    protected static final String CONFIG_PERSISTENCE_VALIDATE_SCHEMA = "topia.persistence.validateSchema";
    protected static final String CONFIG_PERSISTENCE_USE_HIKARI_FOR_JDBC_CONNECTION_POOLING = "topia.persistence.useHikariForJdbcConnectionPooling";
    protected static final String CONFIG_PERSISTENCE_MONITORING_SLOW_QUERY_THRESHOLD = "topia.persistence.monitoring.slowQueryThreshold";
    protected static final ImmutableSet<String> MAIN_CONFIGURATION = ImmutableSet.of((Object)"hibernate.connection.url", (Object)"hibernate.connection.username", (Object)"hibernate.connection.password", (Object)"hibernate.connection.driver_class", (Object)"jakarta.persistence.jdbc.driver", (Object)"jakarta.persistence.jdbc.url", (Object[])new String[]{"jakarta.persistence.jdbc.user", "jakarta.persistence.jdbc.password"});

    public void check(TopiaConfiguration topiaConfiguration) throws TopiaMisconfigurationException {
        if (StringUtils.isBlank((CharSequence)topiaConfiguration.getJdbcConnectionUrl())) {
            throw new TopiaMisconfigurationException("you must provide JDBC connection URL", topiaConfiguration);
        }
        if (StringUtils.isBlank((CharSequence)topiaConfiguration.getJdbcConnectionUser())) {
            throw new TopiaMisconfigurationException("you must provide JDBC connection user", topiaConfiguration);
        }
        if (topiaConfiguration.getJdbcConnectionPassword() == null) {
            throw new TopiaMisconfigurationException("you must provide JDBC connection password", topiaConfiguration);
        }
        if (topiaConfiguration.getJdbcDriverClass() == null) {
            throw new TopiaMisconfigurationException("you must provide JDBC connection driver", topiaConfiguration);
        }
        Map<String, String> hibernateExtraConfiguration = topiaConfiguration.getHibernateExtraConfiguration();
        if (hibernateExtraConfiguration.containsKey("hibernate.hbm2ddl.auto")) {
            throw new TopiaMisconfigurationException("you must not use hibernate.hbm2ddl.auto configuration directive, if you want Hibernate to update the schema, use " + HibernateTopiaMigrationService.class.getName(), topiaConfiguration);
        }
        for (Map.Entry<String, String> entry : hibernateExtraConfiguration.entrySet()) {
            String key = entry.getKey();
            boolean keyIsOnTopic = key.startsWith("hibernate.") || key.startsWith("javax.persistence.") || key.startsWith("jakarta.persistence.");
            boolean entryIsOk = keyIsOnTopic && !MAIN_CONFIGURATION.contains((Object)key);
            if (entryIsOk) continue;
            throw new TopiaMisconfigurationException("hibernate extra configuration is " + hibernateExtraConfiguration + " but it should not contains a key " + key, topiaConfiguration);
        }
        Optional<Duration> slowQueriesThreshold = topiaConfiguration.getSlowQueriesThreshold();
        if (slowQueriesThreshold.isPresent() && slowQueriesThreshold.get().isNegative()) {
            throw new TopiaMisconfigurationException("slow queries threshold can't be negative", topiaConfiguration);
        }
    }

    public BeanTopiaConfiguration readProperties(File propertiesFile) {
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("topia configuration file cannot be found " + propertiesFile, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("unable to read " + propertiesFile, e);
        }
        return this.readProperties(properties);
    }

    public BeanTopiaConfiguration readProperties(Properties properties) {
        return this.readMap((Map<String, String>)ImmutableMap.copyOf((Map)properties));
    }

    public BeanTopiaConfiguration readMap(Map<String, String> configuration) {
        String url = configuration.get(CONFIG_URL);
        String user = configuration.get(CONFIG_USER);
        String password = configuration.get(CONFIG_PASS);
        String driverName = configuration.get(CONFIG_DRIVER);
        JdbcConfiguration jdbcConfiguration = StringUtils.isBlank((CharSequence)driverName) ? this.jdbcConfigurationBuilder.forDatabase(url, user, password) : this.jdbcConfigurationBuilder.forDatabase(url, user, password, driverName);
        BeanTopiaConfiguration result = new BeanTopiaConfiguration(jdbcConfiguration);
        String initSchemaConfigValue = configuration.get(CONFIG_PERSISTENCE_INIT_SCHEMA);
        boolean initSchema = StringUtils.isBlank((CharSequence)initSchemaConfigValue) || Boolean.parseBoolean(initSchemaConfigValue);
        result.setInitSchema(initSchema);
        String validateSchemaConfigValue = configuration.get(CONFIG_PERSISTENCE_VALIDATE_SCHEMA);
        boolean validateSchema = StringUtils.isBlank((CharSequence)validateSchemaConfigValue) || Boolean.parseBoolean(validateSchemaConfigValue);
        result.setValidateSchema(validateSchema);
        String useHikariForJdbcConnectionPoolingConfigValue = configuration.get(CONFIG_PERSISTENCE_USE_HIKARI_FOR_JDBC_CONNECTION_POOLING);
        boolean useHikariForJdbcConnectionPooling = StringUtils.isBlank((CharSequence)useHikariForJdbcConnectionPoolingConfigValue) || Boolean.parseBoolean(useHikariForJdbcConnectionPoolingConfigValue);
        result.setUseHikariForJdbcConnectionPooling(useHikariForJdbcConnectionPooling);
        String slowQueryThresholdString = configuration.get(CONFIG_PERSISTENCE_MONITORING_SLOW_QUERY_THRESHOLD);
        Duration slowQueryThreshold = StringUtils.isBlank((CharSequence)slowQueryThresholdString) ? null : Duration.parse(slowQueryThresholdString);
        result.setSlowQueriesThreshold(slowQueryThreshold);
        String topiaIdFactoryClassName = configuration.get(CONFIG_PERSISTENCE_TOPIA_ID_FACTORY_CLASS_NAME);
        if (!Strings.isNullOrEmpty((String)topiaIdFactoryClassName)) {
            result.setTopiaIdFactoryClassName(topiaIdFactoryClassName);
        }
        result.setSchemaName(configuration.get(CONFIG_DEFAULT_SCHEMA));
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            String key = entry.getKey();
            boolean keyMustBeIncludedInHibernateExtraConfiguration = !MAIN_CONFIGURATION.contains((Object)key) && (key.startsWith("hibernate.") || key.startsWith("javax.persistence."));
            if (!keyMustBeIncludedInHibernateExtraConfiguration) continue;
            result.getHibernateExtraConfiguration().put(key, entry.getValue());
        }
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            String prefixedConfigurationKey = entry.getKey();
            String configurationValue = entry.getValue();
            if (!prefixedConfigurationKey.startsWith(TOPIA_SERVICE_CONFIGURATION_PREFIX)) continue;
            String configurationKey = StringUtils.removeStart((String)prefixedConfigurationKey, (String)TOPIA_SERVICE_CONFIGURATION_PREFIX);
            String[] split = StringUtils.split((String)configurationKey, (char)'.');
            Preconditions.checkState((split.length > 0 ? 1 : 0) != 0, (Object)("'" + prefixedConfigurationKey + "' is not a valid configuration key"));
            String serviceName = split[0];
            if (split.length == 1) {
                try {
                    Class<?> loadedClass = Class.forName(configurationValue);
                    if (TopiaService.class.isAssignableFrom(loadedClass)) {
                        Class<?> serviceClass = loadedClass;
                        result.getDeclaredServices().put(serviceName, serviceClass);
                        continue;
                    }
                    throw new TopiaMisconfigurationException("class " + configurationValue + " is not a topia service, it does not implement " + TopiaService.class.getName(), null);
                }
                catch (ClassNotFoundException e) {
                    throw new TopiaMisconfigurationException("unable to find class " + configurationValue + " in classpath", null);
                }
            }
            Map serviceConfiguration = result.getDeclaredServicesConfiguration().computeIfAbsent(serviceName, aServiceName -> new LinkedHashMap());
            String serviceConfigurationKey = StringUtils.removeStart((String)configurationKey, (String)(serviceName + "."));
            serviceConfiguration.put(serviceConfigurationKey, configurationValue);
        }
        this.check(result);
        return result;
    }

    public Map<String, String> toMap(TopiaConfiguration topiaConfiguration) {
        this.check(topiaConfiguration);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(CONFIG_URL, topiaConfiguration.getJdbcConnectionUrl());
        map.put(CONFIG_USER, topiaConfiguration.getJdbcConnectionUser());
        map.put(CONFIG_PASS, topiaConfiguration.getJdbcConnectionPassword());
        map.put(CONFIG_DRIVER, topiaConfiguration.getJdbcDriverClass().getName());
        if (!topiaConfiguration.isInitSchema()) {
            map.put(CONFIG_PERSISTENCE_INIT_SCHEMA, String.valueOf(topiaConfiguration.isInitSchema()));
        }
        if (!topiaConfiguration.isValidateSchema()) {
            map.put(CONFIG_PERSISTENCE_VALIDATE_SCHEMA, String.valueOf(topiaConfiguration.isValidateSchema()));
        }
        if (!topiaConfiguration.isUseHikariForJdbcConnectionPooling()) {
            map.put(CONFIG_PERSISTENCE_USE_HIKARI_FOR_JDBC_CONNECTION_POOLING, String.valueOf(topiaConfiguration.isUseHikariForJdbcConnectionPooling()));
        }
        topiaConfiguration.getSlowQueriesThreshold().map(Duration::toString).ifPresent(threshold -> map.put(CONFIG_PERSISTENCE_MONITORING_SLOW_QUERY_THRESHOLD, (String)threshold));
        map.put(CONFIG_PERSISTENCE_TOPIA_ID_FACTORY_CLASS_NAME, topiaConfiguration.getTopiaIdFactory().getClass().getName());
        if (topiaConfiguration.getSchemaName() != null) {
            map.put(CONFIG_DEFAULT_SCHEMA, topiaConfiguration.getSchemaName());
        }
        map.putAll(topiaConfiguration.getHibernateExtraConfiguration());
        for (Map.Entry<String, Class<? extends TopiaService>> entry : topiaConfiguration.getDeclaredServices().entrySet()) {
            String serviceName = entry.getKey();
            String serviceDeclaration = "topia.service.." + serviceName;
            String serviceClassName = entry.getValue().getName();
            Map<String, String> serviceConfiguration = topiaConfiguration.getDeclaredServicesConfiguration().get(serviceName);
            map.put(serviceDeclaration, serviceClassName);
            if (serviceConfiguration == null) continue;
            for (Map.Entry<String, String> serviceConfigurationEntry : serviceConfiguration.entrySet()) {
                map.put(serviceDeclaration + "." + serviceConfigurationEntry.getKey(), serviceConfigurationEntry.getValue());
            }
        }
        return map;
    }

    public Properties toProperties(TopiaConfiguration topiaConfiguration) {
        Map<String, String> map = this.toMap(topiaConfiguration);
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    public ConfigureInitSchemaStep forDatabase(JdbcConfiguration jdbcConfiguration) {
        BeanTopiaConfiguration beanTopiaConfiguration = new BeanTopiaConfiguration(jdbcConfiguration);
        return new ConfigureInitSchemaStep(beanTopiaConfiguration);
    }

    public BeanTopiaConfiguration forTest(Class<?> testClass, String methodName) {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forTestDatabase(testClass, methodName);
        BeanTopiaConfiguration configuration = this.forDatabase(jdbcConfiguration).onlyCreateSchemaIfDatabaseIsEmpty().validateSchemaOnStartup().useDefaultConnectionPool().build();
        return configuration;
    }

    public BeanTopiaConfiguration copyOf(TopiaConfiguration topiaConfiguration) {
        BeanTopiaConfiguration copy = new BeanTopiaConfiguration();
        Binder binder = BinderFactory.newBinder(TopiaConfiguration.class, BeanTopiaConfiguration.class);
        binder.copy((Object)topiaConfiguration, (Object)copy, new String[0]);
        return copy;
    }

    public ConfigureInitSchemaStep forInMemoryH2Database() {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forInMemoryH2Database();
        return this.forDatabase(jdbcConfiguration);
    }

    public ConfigureInitSchemaStep forDatabase(String jdbcConnectionUrl, String jdbcConnectionUser, String jdbcConnectionPassword, String jdbcDriverClassName) {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forDatabase(jdbcConnectionUrl, jdbcConnectionUser, jdbcConnectionPassword, jdbcDriverClassName);
        return this.forDatabase(jdbcConfiguration);
    }

    public ConfigureInitSchemaStep forDatabase(String jdbcConnectionUrl, String jdbcConnectionUser, String jdbcConnectionPassword, Class<? extends Driver> jdbcDriverClass) {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forDatabase(jdbcConnectionUrl, jdbcConnectionUser, jdbcConnectionPassword, jdbcDriverClass);
        return this.forDatabase(jdbcConfiguration);
    }

    public ConfigureInitSchemaStep forDatabase(String jdbcConnectionUrl, String jdbcConnectionUser, String jdbcConnectionPassword) {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forDatabase(jdbcConnectionUrl, jdbcConnectionUser, jdbcConnectionPassword);
        return this.forDatabase(jdbcConfiguration);
    }

    public ConfigureInitSchemaStep forPostgresqlDatabase(String jdbcConnectionUrl, String jdbcConnectionUser, String jdbcConnectionPassword) {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forPostgresqlDatabase(jdbcConnectionUrl, jdbcConnectionUser, jdbcConnectionPassword);
        return this.forDatabase(jdbcConfiguration);
    }

    public ConfigureInitSchemaStep forH2Database(String jdbcConnectionUrl, String jdbcConnectionUser, String jdbcConnectionPassword) {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forH2Database(jdbcConnectionUrl, jdbcConnectionUser, jdbcConnectionPassword);
        return this.forDatabase(jdbcConfiguration);
    }

    public ConfigureInitSchemaStep forH2Database(String jdbcConnectionUrl) {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forH2Database(jdbcConnectionUrl);
        return this.forDatabase(jdbcConfiguration);
    }

    public ConfigureInitSchemaStep forH2Database(File file) {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forH2Database(file);
        return this.forDatabase(jdbcConfiguration);
    }

    public ConfigureInitSchemaStep forH2DatabaseInTempDirectory() {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forH2DatabaseInTempDirectory();
        return this.forDatabase(jdbcConfiguration);
    }

    public ConfigureInitSchemaStep forTestDatabase(Class<?> testClass, String methodName) {
        JdbcConfiguration jdbcConfiguration = this.jdbcConfigurationBuilder.forTestDatabase(testClass, methodName);
        return this.forDatabase(jdbcConfiguration);
    }

    public class ConfigureInitSchemaStep {
        protected BeanTopiaConfiguration beanTopiaConfiguration;

        public ConfigureInitSchemaStep(BeanTopiaConfiguration beanTopiaConfiguration) {
            this.beanTopiaConfiguration = beanTopiaConfiguration;
        }

        public ConfigureValidateSchemaStep onlyCreateSchemaIfDatabaseIsEmpty() {
            this.beanTopiaConfiguration.setInitSchema(true);
            return this.nextStep();
        }

        public ConfigureValidateSchemaStep useAlreadyExistingDatabaseAsIs() {
            this.beanTopiaConfiguration.setInitSchema(false);
            return this.nextStep();
        }

        public ConfigureValidateSchemaStep useHibernateUpdate() {
            this.beanTopiaConfiguration.setInitSchema(true);
            this.beanTopiaConfiguration.addDeclaredService("migration", HibernateTopiaMigrationService.class, new LinkedHashMap<String, String>());
            return this.nextStep();
        }

        public ConfigureValidateSchemaStep useFlyway() {
            this.beanTopiaConfiguration.setInitSchema(true);
            this.beanTopiaConfiguration.addDeclaredService("migration", "org.nuiton.topia.flyway.TopiaFlywayServiceImpl", new LinkedHashMap<String, String>());
            return this.nextStep();
        }

        public ConfigureValidateSchemaStep useLiquibase() {
            this.beanTopiaConfiguration.setInitSchema(true);
            this.beanTopiaConfiguration.addDeclaredService("migration", "org.nuiton.topia.flyway.TopiaLiquibaseServiceImpl", new LinkedHashMap<String, String>());
            return this.nextStep();
        }

        protected ConfigureValidateSchemaStep nextStep() {
            return new ConfigureValidateSchemaStep(this.beanTopiaConfiguration);
        }
    }

    public class ConfigureValidateSchemaStep {
        protected BeanTopiaConfiguration beanTopiaConfiguration;

        public ConfigureValidateSchemaStep(BeanTopiaConfiguration beanTopiaConfiguration) {
            this.beanTopiaConfiguration = beanTopiaConfiguration;
        }

        public ConfigureJdbcConnectionPoolingStep validateSchemaOnStartup() {
            this.beanTopiaConfiguration.setValidateSchema(true);
            return new ConfigureJdbcConnectionPoolingStep(this.beanTopiaConfiguration);
        }

        public ConfigureJdbcConnectionPoolingStep doNotValidateSchemaOnStartup() {
            this.beanTopiaConfiguration.setValidateSchema(false);
            return new ConfigureJdbcConnectionPoolingStep(this.beanTopiaConfiguration);
        }
    }

    public class ConfigureJdbcConnectionPoolingStep {
        protected BeanTopiaConfiguration beanTopiaConfiguration;

        public ConfigureJdbcConnectionPoolingStep(BeanTopiaConfiguration beanTopiaConfiguration) {
            this.beanTopiaConfiguration = beanTopiaConfiguration;
        }

        public BuildStep useDefaultConnectionPool() {
            return this.useHikariConnectionPool();
        }

        public BuildStep useHikariConnectionPool() {
            this.beanTopiaConfiguration.setUseHikariForJdbcConnectionPooling(true);
            return new BuildStep(this.beanTopiaConfiguration);
        }

        public BuildStep useC3p0ConnectionPool() {
            this.beanTopiaConfiguration.setUseHikariForJdbcConnectionPooling(false);
            return new BuildStep(this.beanTopiaConfiguration);
        }
    }

    public class BuildStep {
        protected BeanTopiaConfiguration beanTopiaConfiguration;

        public BuildStep(BeanTopiaConfiguration beanTopiaConfiguration) {
            this.beanTopiaConfiguration = beanTopiaConfiguration;
        }

        public BeanTopiaConfiguration build() {
            BeanTopiaConfiguration built = TopiaConfigurationBuilder.this.copyOf(this.beanTopiaConfiguration);
            TopiaConfigurationBuilder.this.check(built);
            return built;
        }

        public Properties buildProperties() {
            return TopiaConfigurationBuilder.this.toProperties(this.beanTopiaConfiguration);
        }

        public Map<String, String> buildMap() {
            return TopiaConfigurationBuilder.this.toMap(this.beanTopiaConfiguration);
        }
    }
}

