/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.TopiaReplicationDestination;
import org.nuiton.topia.persistence.internal.AbstractTopiaDao;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContextConstructorParameter;
import org.nuiton.topia.persistence.internal.HibernateProvider;
import org.nuiton.topia.persistence.internal.TopiaHibernateSessionRegistry;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaReplicationSupport;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaSqlSupport;
import org.nuiton.topia.persistence.internal.support.TopiaFiresSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.support.TopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;

public abstract class AbstractTopiaPersistenceContext
implements TopiaPersistenceContext {
    private static final Log log = LogFactory.getLog(AbstractTopiaPersistenceContext.class);
    protected Map<Class<? extends TopiaEntity>, TopiaDao<? extends TopiaEntity>> daoCache = Maps.newConcurrentMap();
    protected HibernateTopiaReplicationSupport hibernateTopiaReplicationSupport;
    protected TopiaIdFactory topiaIdFactory;
    protected TopiaHibernateSessionRegistry sessionRegistry;
    protected TopiaFiresSupport firesSupport;
    protected InternalTopiaHibernateSupport hibernateSupport;
    protected TopiaJpaSupport jpaSupport;
    protected TopiaSqlSupport sqlSupport;
    protected boolean closed = false;

    public AbstractTopiaPersistenceContext(AbstractTopiaPersistenceContextConstructorParameter parameter) {
        this.topiaIdFactory = parameter.getTopiaIdFactory();
        this.sessionRegistry = parameter.getSessionRegistry();
        this.firesSupport = new TopiaFiresSupport(parameter.getApplicationFiresSupport());
        this.hibernateSupport = new InternalTopiaHibernateSupport(parameter.getHibernateProvider());
        this.startTransaction();
        this.jpaSupport = new HibernateTopiaJpaSupport(this.hibernateSupport, this.firesSupport);
        this.sqlSupport = new HibernateTopiaSqlSupport(this.hibernateSupport);
    }

    public TopiaHibernateSupport getHibernateSupport() {
        return this.hibernateSupport;
    }

    public TopiaSqlSupport getSqlSupport() {
        return this.sqlSupport;
    }

    @Override
    public TopiaIdFactory getTopiaIdFactory() {
        return this.topiaIdFactory;
    }

    @Override
    public TopiaFiresSupport getTopiaFiresSupport() {
        return this.firesSupport;
    }

    protected void startTransaction() throws TopiaException {
        SessionFactory factory = this.hibernateSupport.getHibernateFactory();
        Session result = factory.openSession();
        this.hibernateSupport.setHibernateSession(result);
        result.setFlushMode(FlushMode.MANUAL);
        this.sessionRegistry.register(result, this);
        try {
            result.beginTransaction();
        }
        catch (Exception eee) {
            block4: {
                try {
                    result.close();
                    this.sessionRegistry.unregister(result);
                }
                catch (HibernateException e1) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not close hibernate session", (Throwable)e1);
                }
            }
            String message = String.format("An error occurs while asking a new transaction: %1$s", eee.getMessage());
            throw new TopiaException(message, eee);
        }
        this.getTopiaFiresSupport().fireOnBeginTransaction(this);
    }

    protected void checkNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)("persistence context " + this + " is closed"));
    }

    @Override
    public <E extends TopiaEntity> E findByTopiaId(String topiaId) {
        this.checkNotClosed();
        Class entityClass = this.getTopiaIdFactory().getClassName(topiaId);
        TopiaDao dao = this.getDao(entityClass);
        Object result = dao.forTopiaIdEquals(topiaId).findUnique();
        return result;
    }

    @Override
    public void update(TopiaEntity entity) {
        this.checkNotClosed();
        String topiaId = entity.getTopiaId();
        Class entityClass = this.getTopiaIdFactory().getClassName(topiaId);
        TopiaDao<TopiaEntity> dao = this.getDao(entityClass);
        dao.update(entity);
    }

    @Override
    public void delete(TopiaEntity entity) {
        this.checkNotClosed();
        String topiaId = entity.getTopiaId();
        Class entityClass = this.getTopiaIdFactory().getClassName(topiaId);
        TopiaDao<TopiaEntity> dao = this.getDao(entityClass);
        dao.delete(entity);
    }

    @Override
    public <E extends TopiaEntity> void deleteAll(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    public <E extends TopiaEntity> TopiaDao<E> getDao(Class<E> entityClass) {
        Preconditions.checkArgument((entityClass != null ? 1 : 0) != 0, (Object)"The method 'getDao' requires a non null 'entityClass' parameter");
        SessionFactory hibernateFactory = this.hibernateSupport.getHibernateFactory();
        Preconditions.checkState((hibernateFactory != null ? 1 : 0) != 0, (Object)"The Hibernate SessionFactory is null, please initialize");
        if (hibernateFactory.getClassMetadata(entityClass) == null && hibernateFactory.getClassMetadata(entityClass.getName() + "Impl") == null && hibernateFactory.getClassMetadata(entityClass.getName() + "Abstract") == null) {
            String message;
            String format;
            if (log.isInfoEnabled()) {
                format = "List of supported persistence classes: %s";
                message = String.format(format, hibernateFactory.getAllClassMetadata().keySet());
                log.info((Object)message);
            }
            format = "The following entity type %s is not managed by this context, you probably forgot to declare it.";
            message = String.format(format, entityClass.getName());
            throw new TopiaException(message);
        }
        TopiaDao dao = this.daoCache.get(entityClass);
        if (dao == null) {
            String daoClassName = entityClass.getName() + "TopiaDao";
            try {
                Class<?> daoClass = Class.forName(daoClassName);
                dao = (TopiaDao)daoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                log.fatal((Object)("Unable to instantiate DAO class " + daoClassName), (Throwable)e);
                throw new TopiaException("unable to instantiate DAO class " + daoClassName, e);
            }
            catch (IllegalAccessException e) {
                log.fatal((Object)("Unable to instantiate DAO class " + daoClassName), (Throwable)e);
                throw new TopiaException("unable to instantiate DAO class " + daoClassName, e);
            }
            catch (InvocationTargetException e) {
                log.fatal((Object)("Unable to instantiate DAO class " + daoClassName), (Throwable)e);
                throw new TopiaException("unable to instantiate DAO class " + daoClassName, e);
            }
            catch (NoSuchMethodException e) {
                log.fatal((Object)("Unable to instantiate DAO class " + daoClassName), (Throwable)e);
                throw new TopiaException("unable to instantiate DAO class " + daoClassName, e);
            }
            catch (ClassNotFoundException e) {
                log.fatal((Object)("Unable to find DAO class " + daoClassName), (Throwable)e);
                throw new TopiaException("unable to find DAO class " + daoClassName, e);
            }
            if (dao instanceof AbstractTopiaDao) {
                AbstractTopiaDao abstractTopiaDao = (AbstractTopiaDao)dao;
                abstractTopiaDao.init(this.jpaSupport, this.hibernateSupport, this.sqlSupport, this.topiaIdFactory, this.firesSupport, this);
            }
            this.daoCache.put(entityClass, dao);
        }
        return dao;
    }

    @Override
    public <E extends TopiaEntity, D extends TopiaDao<E>> D getDao(Class<E> entityClass, Class<D> daoClass) {
        TopiaDao<E> dao;
        TopiaDao<E> result = dao = this.getDao(entityClass);
        return (D)result;
    }

    @Override
    public void commit() {
        this.checkNotClosed();
        try {
            Session hibernateSession = this.hibernateSupport.getHibernateSession();
            Transaction transaction = hibernateSession.getTransaction();
            hibernateSession.flush();
            transaction.commit();
            this.getTopiaFiresSupport().fireOnPostCommit(this);
            hibernateSession.beginTransaction();
        }
        catch (Exception eee) {
            String message = String.format("An error occurred during commit operation: %1$s", eee.getMessage());
            throw new TopiaException(message, eee);
        }
    }

    @Override
    public void rollback() {
        this.checkNotClosed();
        this.rollback0(true);
    }

    protected void rollback0(boolean beginAfterRollback) {
        try {
            Session hibernateSession = this.hibernateSupport.getHibernateSession();
            Transaction transaction = hibernateSession.getTransaction();
            hibernateSession.clear();
            transaction.rollback();
            hibernateSession.close();
            this.sessionRegistry.unregister(hibernateSession);
            if (beginAfterRollback) {
                hibernateSession = this.hibernateSupport.getHibernateFactory().openSession();
                this.hibernateSupport.setHibernateSession(hibernateSession);
                hibernateSession.setFlushMode(FlushMode.MANUAL);
                this.sessionRegistry.register(hibernateSession, this);
                hibernateSession.beginTransaction();
            }
            this.getTopiaFiresSupport().fireOnPostRollback(this);
        }
        catch (HibernateException eee) {
            String message = String.format("An error occurred during rollback operation: %1$s", eee.getMessage());
            throw new TopiaException(message, eee);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.checkNotClosed();
        if (log.isDebugEnabled()) {
            log.debug((Object)("will close " + this));
        }
        this.closed = true;
        this.rollback0(false);
        Session hibernateSession = this.hibernateSupport.getHibernateSession();
        Preconditions.checkState((!hibernateSession.isOpen() ? 1 : 0) != 0, (Object)"Session should be closed after rollback0(false)");
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " closed"));
        }
    }

    protected HibernateTopiaReplicationSupport getHibernateTopiaReplicationSupport() {
        if (this.hibernateTopiaReplicationSupport == null) {
            this.hibernateTopiaReplicationSupport = new HibernateTopiaReplicationSupport(this.hibernateSupport);
        }
        return this.hibernateTopiaReplicationSupport;
    }

    @Override
    public void replicate(TopiaEntity entity) {
        this.getHibernateTopiaReplicationSupport().replicate(entity);
    }

    @Override
    public <T extends TopiaEntity> void replicateEntities(TopiaReplicationDestination topiaReplicationDestination, List<T> entities) throws IllegalArgumentException {
        this.getHibernateTopiaReplicationSupport().replicateEntities(topiaReplicationDestination, entities);
    }

    @Override
    public <T extends TopiaEntity> void replicateEntity(TopiaReplicationDestination topiaReplicationDestination, T entity) throws IllegalArgumentException {
        this.getHibernateTopiaReplicationSupport().replicateEntity(topiaReplicationDestination, entity);
    }

    @Override
    public void replicate(TopiaReplicationDestination topiaReplicationDestination, Object ... entityAndCondition) throws IllegalArgumentException {
        this.getHibernateTopiaReplicationSupport().replicate(topiaReplicationDestination, entityAndCondition);
    }

    protected class InternalTopiaHibernateSupport
    implements TopiaHibernateSupport {
        protected HibernateProvider hibernateProvider;
        protected Session hibernateSession;

        protected InternalTopiaHibernateSupport(HibernateProvider hibernateProvider) {
            this.hibernateProvider = hibernateProvider;
        }

        public void setHibernateSession(Session hibernateSession) {
            this.hibernateSession = hibernateSession;
        }

        @Override
        public Session getHibernateSession() {
            Preconditions.checkState((this.hibernateSession != null ? 1 : 0) != 0, (Object)"Session is not yet initialized");
            return this.hibernateSession;
        }

        @Override
        public SessionFactory getHibernateFactory() {
            return this.hibernateProvider.getSessionFactory();
        }

        @Override
        public Configuration getHibernateConfiguration() {
            return this.hibernateProvider.getHibernateConfiguration();
        }
    }
}

