/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaDAOLegacy.java 2055 2010-07-09 14:01:56Z fdesbois $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaDAOLegacy.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/* *
 * TopiaDAOAbstract.java
 *
 * Created: 31 déc. 2005 13:10:34
 *
 * @author poussin
 * @version $Revision: 2055 $
 *
 * Last update: $Date: 2010-07-09 16:01:56 +0200 (ven., 09 juil. 2010) $
 * by : $Author: fdesbois $
 */

package org.nuiton.topia.persistence;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.nuiton.topia.framework.TopiaQuery;

/**
 * Cette classe permet d'avoir un ensemble de méthode implantée de façon 
 * standard et plus spécifiquement pour Hibernate.
 *
 * Certains accès à Hibernate sont tout de même fait ici, car on a pris le
 * choix de se baser entièrement sur hibernate pour la persistence, et il
 * est ainsi possible d'accèder au meta information hibernate sur les classes
 * lorque l'on en a besoin. 
 * 
 * @param <E> le type de l'entite
 * @author poussin
 *
 */

public class TopiaDAOLegacy<E extends TopiaEntity> extends TopiaDAOImpl<E> { // TopiaDAOImpl
    /** to use log facility, just put in your code: log.info(\"...\"); */
    private static Log log = LogFactory.getLog(TopiaDAOImpl.class);

    protected Class<E> entityClass = null;

    protected TopiaContextImplementor context = null;

    @Override
    public Class<E> getEntityClass() {
        throw new UnsupportedOperationException(
                "This method must be overided in generated DAO");
    }

    /**
     * Retourne l'id de l'entity
     * @param e l'entity
     * @return l'id de l'entity ou null si pas trouvé
     * @throws TopiaException Si une erreur survient durant la recherche
     */
    protected Serializable getId(E e) throws TopiaException {
        ClassMetadata meta = getClassMetadata();
        String idPropName = meta.getIdentifierPropertyName();

        Serializable result;
        try {
            result = (Serializable) PropertyUtils.getSimpleProperty(e,
                    idPropName);
        } catch (IllegalAccessException eee) {
            throw new TopiaException("Impossible de récuperer l'identifiant "
                    + idPropName + " de l'entite: " + e);
        } catch (InvocationTargetException eee) {
            throw new TopiaException("Impossible de récuperer l'identifiant "
                    + idPropName + " de l'entite: " + e);
        } catch (NoSuchMethodException eee) {
            throw new TopiaException("Impossible de récuperer l'identifiant "
                    + idPropName + " de l'entite: " + e);
        }
        return result;
    }

    /**
     * Retourne l'id de l'entity representer comme une map
     * @param map l'entity en representation map
     * @return l'id de l'entity ou null si pas trouvé
     * @throws TopiaException Si une erreur survient durant la recherche
     */
    protected Serializable getId(Map map) throws TopiaException {
        try {
            ClassMetadata meta = getClassMetadata();
            String idPropName = meta.getIdentifierPropertyName();

            Serializable id = (Serializable) map.get(idPropName);
            return id;
        } catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    /**
     * When TopiaContextImpl create the TopiaDAOHibernate, it must call this method just
     * after
     *
     * @param entityClass
     */
    public void init(TopiaContextImplementor context, Class<E> entityClass)
            throws TopiaException {
        log.debug("init dao for " + entityClass.getName());
        this.context = context;
        this.entityClass = entityClass;
    }

    @Override
    public TopiaContextImplementor getContext() {
        return context;
    }

    @SuppressWarnings("unchecked")
    protected E instanciateNew() throws TopiaException {
        E result = null;
        if (log.isDebugEnabled()) {
            log.debug("entityClass = " + entityClass);
        }
        String classname = entityClass.getName();
        try {
            // on commence par essayer d'instancier le Impl
            result = ((Class<E>) Class.forName(classname + "Impl"))
                    .newInstance();
            if (log.isDebugEnabled()) {
                log.debug("Utilisation de la classe " + classname + "Impl"
                        + " pour " + classname);
            }
        } catch (InstantiationException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Impossible d'instancier " + classname + "Impl");
            }
            if (log.isDebugEnabled()) {
                log.debug("StackTrace", eee);
            }
        } catch (IllegalAccessException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Impossible d'instancier " + classname + "Impl");
            }
            if (log.isDebugEnabled()) {
                log.debug("StackTrace", eee);
            }
        } catch (ClassNotFoundException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Impossible de trouver la classe " + classname
                        + "Impl");
            }
            if (log.isDebugEnabled()) {
                log.debug("StackTrace", eee);
            }
        }

        if (result == null) {
            // le impl n'est pas trouvé on essai avec la classe elle meme
            try {
                result = entityClass.newInstance();
                if (log.isDebugEnabled()) {
                    log.debug("Utilisation de la classe " + classname
                            + " pour " + classname);
                }
            } catch (InstantiationException eee) {
                if (log.isWarnEnabled()) {
                    log.warn("Impossible d'instancier " + classname);
                }
                if (log.isDebugEnabled()) {
                    log.debug("StackTrace", eee);
                }
            } catch (IllegalAccessException eee) {
                if (log.isWarnEnabled()) {
                    log.warn("Impossible d'instancier " + classname);
                }
                if (log.isDebugEnabled()) {
                    log.debug("StackTrace", eee);
                }
            }
        }

        if (result == null) {
            throw new TopiaException(
                    "Impossible de trouver ou d'instancier la classe "
                            + classname);
        }

        return result;
    }

    @Override
    public E create(Object... properties) throws TopiaException {
        Map<String, Object> map = new HashMap<String, Object>();
        Object propertyName = null;
        Object value = null;
        try {
            for (int i = 0; i < properties.length;) {
                propertyName = properties[i++];
                value = properties[i++];
                map.put((String) propertyName, value);
            }
        } catch (ArrayIndexOutOfBoundsException eee) {
            throw new IllegalArgumentException("Wrong number of argument "
                    + properties.length
                    + ", you must have even number. Last property name read: "
                    + propertyName);
        } catch (ClassCastException eee) {
            throw new IllegalArgumentException(
                    "Wrong argument type, wait property name as String and have "
                            + propertyName.getClass().getName());
        }

        E result = create(map);
        return result;
    }

    @Override
    public E findByPrimaryKey(Map<String, Object> keys)
            throws TopiaException {
        try {
            // we used hibernate meta information for all persistence type
            // it's more easy than create different for all persistence
            ClassMetadata meta = getClassMetadata();
            if (meta.hasNaturalIdentifier()) {
                E result = findByProperties(keys);
                return result;
            }
        } catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
        throw new TopiaException("La classe " + entityClass.getName()
                + " n'a pas de cle primaire naturelle");

    }

    /**
     * private method because this is hibernate specific method and we don't
     * want expose it
     *
     * @return the meta-data of the entity
     * @throws TopiaException if any pb
     */
    private ClassMetadata getClassMetadata() throws TopiaException {
        ClassMetadata meta = getContext().getHibernateFactory()
                .getClassMetadata(entityClass);
        if (meta == null) {
            meta = getContext().getHibernateFactory().getClassMetadata(
                    entityClass.getName() + "Impl");
        }
        return meta;
    }

    @Override
    public E findByPrimaryKey(Object... k) throws TopiaException {
        // TODO pour une meilleur gestion des problemes a la compilation
        // mettre un premier couple (propName, value) en argument ca evitera
        // de pouvoir appeler cette methode sans argument
        try {
            ClassMetadata meta = getClassMetadata();
            if (meta.hasNaturalIdentifier()) {
                int[] ikeys = meta.getNaturalIdentifierProperties();
                String[] pnames = meta.getPropertyNames();

                Map<String, Object> keys = new HashMap<String, Object>();
                for (int ikey : ikeys) {
                    keys.put(pnames[ikey], k[ikey]);
                }

                E result = findByProperties(keys);
                return result;
            }
        } catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
        throw new TopiaException("La classe " + entityClass.getName()
                + " n'a pas de cle primaire naturelle");

    }

    @Override
    public E findByProperties(String propertyName, Object value,
            Object... others) throws TopiaException {
        Map<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        Object name = null;
        for (int i = 0; i < others.length;) {
            try {
                name = others[i++];
                value = others[i++];
                properties.put((String) name, value);
            } catch (ClassCastException eee) {
                throw new IllegalArgumentException(
                        "Les noms des propriétés doivent être des chaines et non pas "
                                + propertyName.getClass().getName(), eee);
            } catch (ArrayIndexOutOfBoundsException eee) {
                throw new IllegalArgumentException(
                        "Le nombre d'argument n'est pas un nombre pair: "
                                + (others.length + 2)
                                + " La dernière propriété était: " + name, eee);
            }
        }
        E result = findByProperties(properties);
        return result;
    }

    @Override
    public List<E> findAllByProperties(String propertyName, Object value,
            Object... others) throws TopiaException {
        Map<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        Object name = null;
        for (int i = 0; i < others.length;) {
            try {
                name = others[i++];
                value = others[i++];
                properties.put((String) name, value);
            } catch (ClassCastException eee) {
                throw new IllegalArgumentException(
                        "Les noms des propriétés doivent être des chaines et non pas "
                                + propertyName.getClass().getName(), eee);
            } catch (ArrayIndexOutOfBoundsException eee) {
                throw new IllegalArgumentException(
                        "Le nombre d'argument n'est pas un nombre pair: "
                                + (others.length + 2)
                                + " La dernière propriété était: " + name, eee);
            }
        }
        List<E> result = findAllByProperties(properties);
        return result;
    }

//    @Override
//    public E findContainsProperties(Map<String, Collection<?>> properties)
//            throws TopiaException {
//        List<E> results = findAllContainsProperties(properties);
//        E result = null;
//        if (results.size() > 0) {
//            result = results.get(0);
//        }
//        return result;
//    }
//
//    @Override
//    public E findContainsProperties(String propertyName,
//            Collection values, Object... others) throws TopiaException {
//        Map<String, Collection<?>> properties = new HashMap<String, Collection<?>>();
//        properties.put(propertyName, values);
//        Object name = null;
//        for (int i = 0; i < others.length;) {
//            try {
//                name = others[i++];
//                values = (Collection) others[i++];
//                properties.put((String) name, values);
//            } catch (ClassCastException eee) {
//                throw new IllegalArgumentException(
//                        "Les noms des propriétés doivent être des chaines et non pas "
//                                + propertyName.getClass().getName(), eee);
//            } catch (ArrayIndexOutOfBoundsException eee) {
//                throw new IllegalArgumentException(
//                        "Le nombre d'argument n'est pas un nombre pair: "
//                                + (others.length + 2)
//                                + " La dernière propriété était: " + name, eee);
//            }
//        }
//        E result = findContainsProperties(properties);
//        return result;
//    }
//
//    /**
//     * Find all entities with a specific rule :
//     * When the entity have a Collection type property, you want to find all entites where some values are
//     * contained in the collection type property.
//     * Example entity parameter : private Collection<Date> historicalDates;
//     * You want some dates to be contained in historicalDates.
//     * Collection<Date> myDates...
//     * myDates.add(date1) ...
//     * Map<String, Collection> properties = new HashMap<String,Collection>();
//     * properties.put("historicalDates",myDates);
//     * findAllContainsProperties(properties);
//     * @param properties
//     * @return the list of entities corresponding to the request
//     * @throws org.nuiton.topia.TopiaException  if any pb
//     */
//    @Override
//    public List<E> findAllContainsProperties(Map<String, Collection<?>> properties) throws TopiaException {
//        List<E> all = findAll();
//        List<E> result = new ArrayList<E>();
//        for (E e : all) {
//            boolean ok = true;
//            try {
//                for (Entry<String, Collection<?>> kv : properties.entrySet()) {
//                    Collection entityValues = (Collection) PropertyUtils
//                            .getProperty(e, kv.getKey());
//                    Collection values = kv.getValue();
//                    if (!entityValues.containsAll(values)) {
//                        ok = false;
//                        break;
//                    }
//                }
//            } catch (IllegalAccessException eee) {
//                ok = false;
//                if (log.isWarnEnabled()) {
//                    log.warn(
//                            "Impossible d'acceder a la methode demandé pour l'obbjet "
//                                    + e, eee);
//                }
//            } catch (InvocationTargetException eee) {
//                ok = false;
//                if (log.isWarnEnabled()) {
//                    log.warn(
//                            "Impossible d'acceder a la methode demandé pour l'obbjet "
//                                    + e, eee);
//                }
//            } catch (NoSuchMethodException eee) {
//                ok = false;
//                if (log.isWarnEnabled()) {
//                    log.warn(
//                            "Impossible d'acceder a la methode demandé pour l'obbjet "
//                                    + e, eee);
//                }
//            }
//            if (ok) {
//                result.add(e);
//            }
//        }
//        return result;
//    }
//
//    @Override
//    public List<E> findAllContainsProperties(String propertyName,
//            Collection values, Object... others) throws TopiaException {
//        Map<String, Collection<?>> properties = new HashMap<String, Collection<?>>();
//        properties.put(propertyName, values);
//        Object name = null;
//        for (int i = 0; i < others.length;) {
//            try {
//                name = others[i++];
//                values = (Collection) others[i++];
//                properties.put((String) name, values);
//            } catch (ClassCastException eee) {
//                throw new IllegalArgumentException(
//                        "Les noms des propriétés doivent être des chaines et non pas "
//                                + propertyName.getClass().getName(), eee);
//            } catch (ArrayIndexOutOfBoundsException eee) {
//                throw new IllegalArgumentException(
//                        "Le nombre d'argument n'est pas un nombre pair: "
//                                + (others.length + 2)
//                                + " La dernière propriété était: " + name, eee);
//            }
//        }
//        List<E> result = findAllContainsProperties(properties);
//        return result;
//    }

    @Override
    public List<E> findAllByProperty(String propertyName, Object value)
            throws TopiaException {
        Map<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        List<E> result = findAllByProperties(properties);
        return result;
    }

    @Override
    public E findByProperty(String propertyName, Object value)
            throws TopiaException {
        Map<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        E result = findByProperties(properties);
        return result;
    }

    @Deprecated
    private Criterion computeCriterions(Object... values) {
        if (values == null) {
            return null;
        }
        Criterion criterion = null;
        for (Object value : values) {
            criterion = or(criterion, computeCriterion(value));
        }
        return criterion;
    }

    @Deprecated
    private Criterion computeCriterion(Object value) {
        Criterion criterion = null;
        SearchFields fields = entityClass.getAnnotation(SearchFields.class);
        String textValue = "%" + value + "%";
        //textFields
        String[] textFields = fields.txtFields();
        for (String propName : textFields) {
            criterion = or(criterion, Restrictions.like(propName, textValue));
        }
        //numFields
        boolean isNumber = (value instanceof Number);
        if (value instanceof String) {
            try {
                Double.parseDouble((String) value);
                isNumber = true;
            } catch (NumberFormatException nfe) {
                isNumber = false;
            }

        }
        if (isNumber) {
            String[] numFields = fields.numFields();
            for (String propName : numFields) {
                criterion = or(criterion, Restrictions.sqlRestriction(propName
                        + " like '" + textValue + "'"));
            }
        }
        //boolFields
        boolean isBoolean = (value instanceof Boolean);
        if (value instanceof String) {
            isBoolean |= ("true".equalsIgnoreCase((String) value) || "false"
                    .equalsIgnoreCase((String) value));
        }
        if (isBoolean) {
            Boolean booleanValue;
            if (value instanceof String) {
                booleanValue = Boolean.valueOf((String) value);
            } else {
                booleanValue = (Boolean) value;
            }
            String[] boolFields = fields.numFields();
            for (String propName : boolFields) {
                criterion = or(criterion, Restrictions.eq(propName,
                        booleanValue));
            }
        }
        //timeFields
        String[] timeFields = fields.dateFields();
        for (String propName : timeFields) {
            criterion = or(criterion, Restrictions.sqlRestriction(propName
                    + " like '" + textValue + "'"));
        }
        return criterion;
    }

    @Deprecated
    private Criterion or(Criterion crit1, Criterion crit2) {
        if (crit1 == null) {
            return crit2;
        }
        if (crit2 == null) {
            return crit1;
        }
        return Restrictions.or(crit1, crit2);
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        getContext().addTopiaEntityListener(entityClass,listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        getContext().addTopiaEntityVetoable(entityClass,vetoable);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        getContext().removeTopiaEntityListener(entityClass, listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        getContext().removeTopiaEntityVetoable(entityClass, vetoable);
    }

    /**
     * Cette methode appelle fireVetoableCreate et fireOnCreated
     * Si vous la surchargé, faites attention a appeler le super
     * ou a appeler vous aussi ces deux methodes.
     */
    @Override
    public E create(Map<String, Object> properties) throws TopiaException {
        E result = instanciateNew();

        // TODO reflechir s'il ne faudrait pas creer l'id avant l'event precedent
        // reflechir toujours dans un context on les E pourrait ne pas
        // etre des TopiaEntity
        if (result instanceof TopiaEntity) {
            String topiaId = TopiaId.create(entityClass);
            TopiaEntityAbstract entity = (TopiaEntityAbstract) result;
            entity.setTopiaId(topiaId);
            entity.setTopiaContext(getContext());
        }
        try {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                String propertyName = e.getKey();
                Object value = e.getValue();
                PropertyUtils.setProperty(result, propertyName, value);
            }
        } catch (IllegalAccessException eee) {
            throw new IllegalArgumentException(
                    "Can't put properties on new Object", eee);
        } catch (InvocationTargetException eee) {
            throw new IllegalArgumentException(
                    "Can't put properties on new Object", eee);
        } catch (NoSuchMethodException eee) {
            throw new IllegalArgumentException(
                    "Can't put properties on new Object", eee);
        }

        // on fait un save maintenant, car puisqu'on a creer l'entity au
        // travers du DAO, on s'attend a l'avoir a disposition tout de
        // suite pour les requetes sans avoir a faire un update dessus
        getSession().save(result);
        getContext().getFiresSupport().warnOnCreateEntity(result);
        return result;
    }

    @Override
    public E update(E e) throws TopiaException {
        try {
            getSession().saveOrUpdate(e);
            getContext().getFiresSupport().warnOnUpdateEntity(e);
            return e;
        } catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public void delete(E e) throws TopiaException {
        try {
            getSession().delete(e);
            getContext().getFiresSupport().warnOnDeleteEntity(e);
        } catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public E findByTopiaId(String k) throws TopiaException {
        return query(Restrictions.idEq(k));
    }

    @Override
    public List<E> findAll() throws TopiaException {
        try {
            Criteria criteria = createCriteria(FlushMode.AUTO);
            List<E> result = (List<E>) criteria.list();
            result = getContext().getFiresSupport().fireEntitiesLoad(context,
                    result);
            return result;
        } catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public List<String> findAllIds() throws TopiaException {
        List<String> find = context.find("select src.topiaId from " + entityClass.getSimpleName() + "Impl src");
        return find;
    }



    @Override
    public List<E> findAllWithOrder(String... propertyNames)
            throws TopiaException {
        try {
            Criteria criteria = createCriteria(FlushMode.AUTO);
            for (String propertyName : propertyNames) {
                criteria.addOrder(Order.asc(propertyName));
            }
            List<E> result = (List<E>) criteria.list();
            result = getContext().getFiresSupport().fireEntitiesLoad(context,
                    result);
            return result;
        } catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    /**
     * Count number of existing entities using {@link org.nuiton.topia.framework.TopiaQuery#executeCount(org.nuiton.topia.TopiaContext) }
     * FIXME-FD20091224 change type to int like in 2.2.2 version
     *
     * @return a long for the number of entities in database
     */
    @Override
    public long size() throws TopiaException {
        //int result = findAll().size();
//        List result = this.getContext().find("SELECT count(*) FROM " + getEntityClass().getName() + "Impl");
//        return (Long)result.get(0);
        return new TopiaQuery(getEntityClass()).executeCount(context);
    }

    @Override
    public E findByProperties(Map<String, Object> properties)
            throws TopiaException {
        return query(Restrictions.allEq(properties));
    }

    @Override
    public List<E> findAllByProperties(Map<String, Object> properties)
            throws TopiaException {
        return queryAll(Restrictions.allEq(properties));
    }

    private List<E> queryAll(Criterion criterion) throws TopiaException {
        try {
            Criteria criteria = createCriteria(FlushMode.AUTO);
            criteria.add(criterion);
            List<E> result = (List<E>) criteria.list();
            result = getContext().getFiresSupport().fireEntitiesLoad(context,
                    result);
            return result;
        } catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    private E query(Criterion criterion) throws TopiaException {
        try {
            Criteria criteria = createCriteria(FlushMode.AUTO);
            criteria.add(criterion);
            criteria.setMaxResults(1);
            List<E> result = (List<E>) criteria.list();
            int sizeBefore = (result != null ? result.size() : 0);
            result = getContext().getFiresSupport().fireEntitiesLoad(context,
                    result);
            int sizeAfter = (result != null ? result.size() : 0);
            if (sizeAfter < sizeBefore) {
                if (log.isDebugEnabled()) {
                    log.debug((sizeBefore - sizeAfter)
                            + " element(s) removed. Filter entity: "
                            + entityClass.getName() + " - criterion: "
                            + criterion);
                }
            }
            if (result != null && result.size() > 0) {
                E elem = result.get(0);
                return elem;
            }
            return null;
        } catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    //FIXME : Commenté car impossible de trouver le bon Criterion
    // ATTENTION ancienne methode du TopiaDAOAbstract deja presente dans le fichier

    //    /* (non-Javadoc)
    //     * @see org.nuiton.topia.persistence.TopiaDAO#findContainsProperties(java.util.Map)
    //     */
    //    public E findContainsProperties(Map<String, Collection> properties) throws TopiaException {
    //        try {
    //            Criteria criteria = createCriteria(FlushMode.AUTO);
    //            for (Entry<String, Collection> entry : properties.entrySet()) {
    //                for (Object value : entry.getValue()) {
    //                    criteria.add(Restrictions.eq(entry.getKey(), value));
    //                }
    //            }
    //            criteria.setMaxResults(1);
    //            List<E> results = (List<E>)criteria.list();
    //            if (results.size() > 0) {
    //                return (E)results.get(0);
    //            } else {
    //                return null;
    //            }
    //        } catch (HibernateException eee) {
    //            throw new TopiaException(eee);
    //        }
    //    }
    //
    //    /* (non-Javadoc)
    //     * @see org.nuiton.topia.persistence.TopiaDAO#findAllContainsProperties(java.util.Map)
    //     */
    //    public List<E> findAllContainsProperties(Map<String, Collection> properties) throws TopiaException {
    //        try {
    //            Criteria criteria = createCriteria(FlushMode.AUTO);
    //            for (Entry<String, Collection> entry : properties.entrySet()) {
    //                for (Object value : entry.getValue()) {
    //                    criteria.add(Restrictions.eq(entry.getKey(), value));
    //                }
    //            }
    //            List<E> result = (List<E>)criteria.list();
    //            return result;
    //        } catch (HibernateException eee) {
    //            throw new TopiaException(eee);
    //        }
    //    }

    /**
     * Renvoie un Criteria créé avec l'entityClass
     * @param mode le FlushMode du Criteria
     * @return le Criteria nouvellement créé
     * @throws org.nuiton.topia.TopiaException if any pb
     */
    private Criteria createCriteria(FlushMode mode) throws TopiaException {
        Criteria criteria = getSession().createCriteria(entityClass);
        criteria.setFlushMode(mode);
        return criteria;
    }

    /**
     * Renvoie la Session contenue dans le contexte
     * @return hibernate session
     * @throws org.nuiton.topia.TopiaException if any pb
     */
    private Session getSession() throws TopiaException {
        return getContext().getHibernate();
    }

    @Override
    public List<Permission> getRequestPermission(String topiaId, int actions)
            throws TopiaException {
        return null;
    }


} //TopiaDAOImpl
