/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.junit.After;
import org.junit.Assert;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.persistence.util.TopiaEntityRef;

public abstract class TopiaEntityRefTester<T extends TopiaEntityEnum> {
    protected SortedMap<TopiaEntity, List<TopiaEntityRef>> detected;
    protected Iterator<Map.Entry<TopiaEntity, List<TopiaEntityRef>>> itr;
    protected Map.Entry<TopiaEntity, List<TopiaEntityRef>> entry;
    protected List<TopiaEntityRef> refs;
    protected T[] contracts;
    protected int index;

    protected T[] getContracts() {
        if (this.contracts == null) {
            this.contracts = this.getContracts0();
        }
        return this.contracts;
    }

    protected abstract T[] getContracts0();

    @After
    public void after() {
        this.itr = null;
        this.entry = null;
        this.refs = null;
        this.detected = null;
        this.index = 0;
    }

    protected <T extends TopiaEntity> T newEntity(TopiaEntityEnum constant, String topiaId) throws IllegalAccessException, InstantiationException {
        Class impl = constant.getImplementation();
        TopiaEntity topiaEntity = (TopiaEntity)impl.newInstance();
        topiaEntity.setTopiaId(topiaId);
        return (T)topiaEntity;
    }

    protected String getAssociationRef(String associationName, TopiaEntity e) {
        return this.getAssociationRef(associationName, e.getTopiaId());
    }

    protected String getAssociationRef(String associationName, String e) {
        String s = String.format("%1$s[@topiaId=\"%2$s\"]", associationName, e);
        return s;
    }

    protected void nextEntry() {
        if (!this.itr.hasNext()) {
            throw new IllegalStateException("no more entry to get...");
        }
        this.entry = this.itr.next();
        this.index = 0;
    }

    protected void detectReferences(TopiaEntity entity, int nb, String ... ids) throws TopiaException {
        this.detected = TopiaEntityHelper.detectReferences((TopiaEntityEnum[])this.getContracts(), (String[])ids, (TopiaEntity)entity);
        this.assertDetected(nb);
    }

    protected void detectReferences(Collection<? extends TopiaEntity> entity, int nb, String ... ids) throws TopiaException {
        this.detected = TopiaEntityHelper.detectReferences((TopiaEntityEnum[])this.getContracts(), (String[])ids, entity);
        this.assertDetected(nb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectTypes(Class<?>[] expected, TopiaEntity ... data) throws TopiaException {
        HashSet<String> fqns = new HashSet<String>(expected.length);
        Set actual = null;
        for (Class<?> c : expected) {
            fqns.add(c.getName());
        }
        try {
            actual = TopiaEntityHelper.detectTypes((TopiaEntityEnum[])this.getContracts(), (TopiaEntity[])data);
            Assert.assertEquals((long)expected.length, (long)actual.size());
            for (Class c : actual) {
                Assert.assertTrue((boolean)fqns.contains(c.getName()));
            }
        }
        finally {
            fqns.clear();
            if (actual != null) {
                actual.clear();
            }
        }
    }

    protected void assertNextEntityRef(TopiaEntity invoker, String invokerProperty, TopiaEntity ... expected) {
        this.assertEntityRef(this.index, invoker, invokerProperty, expected);
        ++this.index;
    }

    protected void assertNextAssociationEntityRef(TopiaEntity invoker, String association, String id, TopiaEntity ... expected) {
        String invokerProperty = this.getAssociationRef(association, id);
        this.assertNextEntityRef(invoker, invokerProperty, expected);
    }

    protected void assertEntityRef(int index, TopiaEntity invoker, String invokerProperty, TopiaEntity ... expected) {
        Assert.assertNotNull(this.refs);
        Assert.assertTrue((String)("no index [" + index + "] in refs of size " + this.refs.size()), (index < this.refs.size() ? 1 : 0) != 0);
        TopiaEntityRef actual = this.refs.get(index);
        Assert.assertEquals((Object)actual.getInvoker(), (Object)invoker);
        Assert.assertEquals((Object)actual.getInvokerProperty(), (Object)invokerProperty);
        TopiaEntity[] path = actual.getPath();
        Assert.assertEquals((long)expected.length, (long)path.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i].getTopiaId(), (Object)path[i].getTopiaId());
        }
    }

    protected void assertCurrentEntry(TopiaEntity expected, int nbPath) {
        this.assertEntry(expected, nbPath, this.entry);
    }

    private void assertEntry(TopiaEntity expected, int nbPath, Map.Entry<TopiaEntity, List<TopiaEntityRef>> entry) {
        Assert.assertNotNull(entry);
        Assert.assertEquals((Object)expected, (Object)entry.getKey());
        this.refs = entry.getValue();
        Assert.assertEquals((long)nbPath, (long)this.refs.size());
    }

    protected void assertDetected(int size) {
        Assert.assertNotNull(this.detected);
        Assert.assertEquals((long)size, (long)this.detected.size());
        this.itr = this.detected.entrySet().iterator();
    }
}

