package org.nuiton.topiatest.deletetest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class Party2DAOAbstract<E extends Party2> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Party2.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<Contact2> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from contact2 main, contacts_party2 secondary " +
                    "where main.topiaid=secondary.contacts" +
                    " and secondary.party2='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaTestDAOHelper.getImplementationClass(Contact2.class)).list();

            for (Contact2 item : list) {
                item.removeParty2(entity);
            }
        }

        super.delete(entity);
    }

    /**
     * findContainsContacts :
     * Retourne le premier élément trouvé dont l'attribut contacts contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsContacts(Contact2... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Party2.CONTACTS, Arrays.asList(v));
        E result = findContainsProperties("contacts", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsContacts :
     * Retourne les éléments trouvé dont l'attribut contacts contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsContacts(Contact2... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Party2.CONTACTS, Arrays.asList(v));
        List<E> results = findAllContainsProperties("contacts", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Contact2.class) {
            Contact2DAO dao = (Contact2DAO)
                getContext().getDAO(Contact2.class);
            tmp = dao.findAllContainsParty2(entity);
//            tmp = dao.findAllByProperties(Contact2.PARTY2, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Contact2.class, entity);
        if (!list.isEmpty()) {
            result.put(Contact2.class, list);
        }

        return result;
    }


} //Party2DAOAbstract<E extends Party2>
