/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.Collector;
import org.nuiton.topiatest.CompanyImpl;
import org.nuiton.topiatest.DepartmentImpl;
import org.nuiton.topiatest.EmployeImpl;

public class CollectorTest {
    static TopiaEntityEnum[] contracts;

    @BeforeClass
    public static void setUpClass() throws Exception {
        contracts = TopiaTestDAOHelper.getContracts();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        contracts = null;
    }

    @Test
    public void testCollector() throws Exception {
        Collector<Integer> detector = new Collector<Integer>(contracts){
            int hits;

            protected void beforeAll(Collector.CollectorVisitor visitor, TopiaEntity ... entities) {
                super.beforeAll(visitor, entities);
                this.hits = 0;
            }

            protected Integer afterAll(Collector.CollectorVisitor visitor, TopiaEntity ... entities) {
                return this.hits;
            }

            protected void onStarted(TopiaEntity e, boolean enter) {
                super.onStarted(e, enter);
                int level = this.stackSize();
                System.out.println(String.format("(%1$2d) %2$" + level * 2 + "s %3$s", level, ">>", this.getStack()));
                ++this.hits;
            }

            protected void onEnded(TopiaEntity e, boolean enter) {
                super.onEnded(e, enter);
                int level = this.stackSize() + 1;
                System.out.println(String.format("(%1$2d) %2$" + level * 2 + "s %3$s", level, "<<", this.getStack()));
            }
        };
        CompanyImpl company = new CompanyImpl();
        EmployeImpl employe = new EmployeImpl();
        DepartmentImpl department = new DepartmentImpl();
        this.detect(detector, 1, company);
        company.addEmploye(employe);
        this.detect(detector, 2, company);
        company.addDepartment(department);
        this.detect(detector, 3, company);
        company.removeEmploye(employe);
        this.detect(detector, 2, company);
        company.removeDepartment(department);
        this.detect(detector, 1, company);
    }

    protected void detect(Collector<Integer> detector, int expectedResult, TopiaEntity ... entities) throws TopiaException {
        Integer result = (Integer)detector.detect(entities);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)expectedResult, (long)result.intValue());
    }
}

