/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topiatest.Bill;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.Store;

public abstract class CompanyAbstract
extends TopiaEntityAbstract
implements Company {
    public String name;
    public Collection<Employe> employe;
    public Collection<Bill> storeBill;
    public Collection<Department> department;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Company.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Company.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "employe", Collection.class, Employe.class, this.employe);
        visitor.visit((TopiaEntity)this, "storeBill", Collection.class, Bill.class, this.storeBill);
        visitor.visit((TopiaEntity)this, "department", Collection.class, Department.class, this.department);
        visitor.end((TopiaEntity)this);
    }

    public List<TopiaEntity> accept() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList<Department> tmp = new ArrayList<Department>();
        TopiaDAO dao = ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Bill.class);
        List findAllByProperties = dao.findAllByProperties("company", (Object)this, new Object[0]);
        if (findAllByProperties != null) {
            tmp.addAll(findAllByProperties);
        }
        if (this.getDepartment() != null) {
            tmp.addAll(this.getDepartment());
        }
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity topiaEntity : tmp) {
            if (topiaEntity == null) continue;
            result.add(topiaEntity);
            result.addAll(topiaEntity.getComposite());
        }
        return result;
    }

    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        this.fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        this.fireOnPostWrite("name", _oldValue, value);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void addEmploye(Employe employe) {
        this.fireOnPreWrite("employe", null, employe);
        if (this.employe == null) {
            this.employe = new ArrayList<Employe>();
        }
        this.employe.add(employe);
        this.fireOnPostWrite("employe", this.employe.size(), null, employe);
    }

    @Override
    public void addAllEmploye(Collection<Employe> values) {
        if (values == null) {
            return;
        }
        for (Employe item : values) {
            this.addEmploye(item);
        }
    }

    @Override
    public Employe getEmployeByTopiaId(String topiaId) {
        return (Employe)TopiaEntityHelper.getEntityByTopiaId(this.employe, (String)topiaId);
    }

    @Override
    public void setEmploye(Collection<Employe> values) {
        Collection<Employe> _oldValue = this.employe;
        this.fireOnPreWrite("employe", _oldValue, values);
        this.employe = values;
        this.fireOnPostWrite("employe", _oldValue, values);
    }

    @Override
    public void removeEmploye(Employe value) {
        this.fireOnPreWrite("employe", value, null);
        if (this.employe == null || !this.employe.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("employe", this.employe.size() + 1, value, null);
    }

    @Override
    public void clearEmploye() {
        if (this.employe == null) {
            return;
        }
        ArrayList<Employe> _oldValue = new ArrayList<Employe>(this.employe);
        this.fireOnPreWrite("employe", _oldValue, this.employe);
        this.employe.clear();
        this.fireOnPostWrite("employe", _oldValue, this.employe);
    }

    @Override
    public Collection<Employe> getEmploye() {
        return this.employe;
    }

    @Override
    public int sizeEmploye() {
        if (this.employe == null) {
            return 0;
        }
        return this.employe.size();
    }

    @Override
    public boolean isEmployeEmpty() {
        int size = this.sizeEmploye();
        return size == 0;
    }

    @Override
    public void addStoreBill(Bill value) {
        this.fireOnPreWrite("storeBill", null, value);
        if (this.storeBill == null) {
            this.storeBill = new ArrayList<Bill>();
        }
        this.storeBill.add(value);
        this.fireOnPostWrite("storeBill", this.storeBill.size(), null, value);
    }

    @Override
    public Bill getStoreBillByTopiaId(String topiaId) {
        return (Bill)TopiaEntityHelper.getEntityByTopiaId(this.storeBill, (String)topiaId);
    }

    @Override
    public void addAllStoreBill(Collection<Bill> values) {
        if (values == null) {
            return;
        }
        for (Bill item : values) {
            this.addStoreBill(item);
        }
    }

    @Override
    public void setStoreBill(Collection<Bill> values) {
        Collection<Bill> _oldValue = this.storeBill;
        this.fireOnPreWrite("storeBill", _oldValue, values);
        this.storeBill = values;
        this.fireOnPostWrite("storeBill", _oldValue, values);
    }

    @Override
    public void removeStoreBill(Bill value) {
        this.fireOnPreWrite("storeBill", value, null);
        if (this.storeBill == null || !this.storeBill.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("storeBill", this.storeBill.size() + 1, value, null);
    }

    @Override
    public void clearStoreBill() {
        if (this.storeBill == null) {
            return;
        }
        ArrayList<Bill> _oldValue = new ArrayList<Bill>(this.storeBill);
        this.fireOnPreWrite("storeBill", _oldValue, null);
        this.storeBill.clear();
        this.fireOnPostWrite("storeBill", _oldValue, null);
    }

    @Override
    public Collection<Bill> getStoreBill() {
        return this.storeBill;
    }

    @Override
    public Bill getStoreBill(Store value) {
        if (value == null || this.storeBill == null) {
            return null;
        }
        for (Bill item : this.storeBill) {
            if (!value.equals(item.getStore())) continue;
            return item;
        }
        return null;
    }

    @Override
    public int sizeStoreBill() {
        if (this.storeBill == null) {
            return 0;
        }
        return this.storeBill.size();
    }

    @Override
    public boolean isStoreBillEmpty() {
        int size = this.sizeStoreBill();
        return size == 0;
    }

    @Override
    public void addDepartment(Department department) {
        this.fireOnPreWrite("department", null, department);
        if (this.department == null) {
            this.department = new ArrayList<Department>();
        }
        department.setCompany(this);
        this.department.add(department);
        this.fireOnPostWrite("department", this.department.size(), null, department);
    }

    @Override
    public void addAllDepartment(Collection<Department> values) {
        if (values == null) {
            return;
        }
        for (Department item : values) {
            this.addDepartment(item);
        }
    }

    @Override
    public Department getDepartmentByTopiaId(String topiaId) {
        return (Department)TopiaEntityHelper.getEntityByTopiaId(this.department, (String)topiaId);
    }

    @Override
    public void setDepartment(Collection<Department> values) {
        Collection<Department> _oldValue = this.department;
        this.fireOnPreWrite("department", _oldValue, values);
        this.department = values;
        this.fireOnPostWrite("department", _oldValue, values);
    }

    @Override
    public void removeDepartment(Department value) {
        this.fireOnPreWrite("department", value, null);
        if (this.department == null || !this.department.remove(value)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setCompany(null);
        this.fireOnPostWrite("department", this.department.size() + 1, value, null);
    }

    @Override
    public void clearDepartment() {
        if (this.department == null) {
            return;
        }
        for (Department item : this.department) {
            item.setCompany(null);
        }
        ArrayList<Department> _oldValue = new ArrayList<Department>(this.department);
        this.fireOnPreWrite("department", _oldValue, this.department);
        this.department.clear();
        this.fireOnPostWrite("department", _oldValue, this.department);
    }

    @Override
    public Collection<Department> getDepartment() {
        return this.department;
    }

    @Override
    public int sizeDepartment() {
        if (this.department == null) {
            return 0;
        }
        return this.department.size();
    }

    @Override
    public boolean isDepartmentEmpty() {
        int size = this.sizeDepartment();
        return size == 0;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("employe", this.employe).toString();
        return result;
    }

    static {
        I18n.n_((String)"topia.test.common.company");
        I18n.n_((String)"topia.test.common.name");
        I18n.n_((String)"topia.test.common.employe");
        I18n.n_((String)"topia.test.common.store");
        I18n.n_((String)"topia.test.common.department");
    }
}

