package org.nuiton.topiatest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class AddressAbstract extends TopiaEntityAbstract implements Address {

    public String city;
    public String adress;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Address.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Address.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "city", String.class, city);
        visitor.visit(this, "adress", String.class, adress);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setCity :
     * @param value 
     */

    public void setCity(String value) {
        String _oldValue = this.city;
        fireOnPreWrite("city", _oldValue, value);
        this.city = value;
        fireOnPostWrite("city", _oldValue, value);
}

    /**
     * getCity :
     * @return String 
     */

    public String getCity() {
        fireOnPreRead("city", city);
        String result = this.city;
        fireOnPostRead("city", city);
        return result;
}

    /**
     * setAdress :
     * @param value 
     */

    public void setAdress(String value) {
        String _oldValue = this.adress;
        fireOnPreWrite("adress", _oldValue, value);
        this.adress = value;
        fireOnPostWrite("adress", _oldValue, value);
}

    /**
     * getAdress :
     * @return String 
     */

    public String getAdress() {
        fireOnPreRead("adress", adress);
        String result = this.adress;
        fireOnPostRead("adress", adress);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("city", this.city).
            append("adress", this.adress).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.address");
    org.nuiton.i18n.I18n.n_("topia.test.common.city");
    org.nuiton.i18n.I18n.n_("topia.test.common.adress");
    org.nuiton.i18n.I18n.n_("topia.test.common.personne");
    }

} //AddressAbstract
