package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class NaturalizedEntityAbstract extends TopiaEntityAbstract implements NaturalizedEntity {

    /**
     * Nom de l'attribut en BD : naturalIdNotNull
     */
    protected Integer naturalIdNotNull;

    /**
     * Nom de l'attribut en BD : naturalIdNull
     */
    protected String naturalIdNull;

    private static final long serialVersionUID = 7364006844154918197L;

    static {
    
        I18n.n("topia.test.common.naturalizedEntity");
        I18n.n("topia.test.common.naturalIdNotNull");
        I18n.n("topia.test.common.naturalIdNull");
    }

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NATURAL_ID_NOT_NULL, Integer.class, naturalIdNotNull);
        visitor.visit(this, PROPERTY_NATURAL_ID_NULL, String.class, naturalIdNull);
    }

    @Override
    public void setNaturalIdNotNull(Integer naturalIdNotNull) {
        Integer oldValue = this.naturalIdNotNull;
        fireOnPreWrite(PROPERTY_NATURAL_ID_NOT_NULL, oldValue, naturalIdNotNull);
        this.naturalIdNotNull = naturalIdNotNull;
        fireOnPostWrite(PROPERTY_NATURAL_ID_NOT_NULL, oldValue, naturalIdNotNull);
    }

    @Override
    public Integer getNaturalIdNotNull() {
        fireOnPreRead(PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull);

        Integer result = this.naturalIdNotNull;

        fireOnPostRead(PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull);

        return result;
    }

    @Override
    public void setNaturalIdNull(String naturalIdNull) {
        String oldValue = this.naturalIdNull;
        fireOnPreWrite(PROPERTY_NATURAL_ID_NULL, oldValue, naturalIdNull);
        this.naturalIdNull = naturalIdNull;
        fireOnPostWrite(PROPERTY_NATURAL_ID_NULL, oldValue, naturalIdNull);
    }

    @Override
    public String getNaturalIdNull() {
        fireOnPreRead(PROPERTY_NATURAL_ID_NULL, naturalIdNull);

        String result = this.naturalIdNull;

        fireOnPostRead(PROPERTY_NATURAL_ID_NULL, naturalIdNull);

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NATURAL_ID_NOT_NULL, this.naturalIdNotNull).
            append(PROPERTY_NATURAL_ID_NULL, this.naturalIdNull).
         toString();
        return result;
    }

} //NaturalizedEntityAbstract
