/*
 * Decompiled with CFR 0.152.
 */
package sdoc;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import sdoc.SyntaxSupport;
import sdoc.SyntaxView;

public class SyntaxTextUI
extends BasicTextAreaUI {
    private JTextComponent comp;
    int selectedIndex = 0;

    @Override
    public View create(Element elem) {
        return new SyntaxView(elem);
    }

    @Override
    public void installUI(JComponent c) {
        this.comp = (JTextComponent)c;
        if (SyntaxSupport.getInstance().getShouldHighlightCurrentLine()) {
            this.comp.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    Document doc = SyntaxTextUI.this.comp.getDocument();
                    Element map = doc.getDefaultRootElement();
                    int index = map.getElementIndex(e.getDot());
                    if (index == SyntaxTextUI.this.selectedIndex) {
                        return;
                    }
                    try {
                        Rectangle rec;
                        Element previous = map.getElement(SyntaxTextUI.this.selectedIndex);
                        if (previous != null && (rec = SyntaxTextUI.this.comp.modelToView(previous.getStartOffset())) != null) {
                            rec.width = SyntaxTextUI.this.comp.getWidth();
                            SyntaxTextUI.this.comp.repaint(rec);
                        }
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    SyntaxTextUI.this.selectedIndex = index;
                    Element selected = map.getElement(index);
                    SyntaxTextUI.this.damageRange(SyntaxTextUI.this.comp, selected.getStartOffset(), selected.getEndOffset() - 1);
                }
            });
        }
        super.installUI(c);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    protected void paintSafely(Graphics g) {
        super.paintSafely(g);
        SyntaxSupport config = SyntaxSupport.getInstance();
        if (config.getShouldDrawPrintMargin()) {
            int charWidth = g.getFontMetrics(this.comp.getFont()).charWidth('S');
            int linex = charWidth * config.getPringMarginWidth();
            Rectangle rec = this.comp.getVisibleRect();
            g.setColor(Color.GRAY.brighter());
            g.drawLine(linex, rec.y, linex, rec.y + rec.height);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.comp.getInputMap().put(KeyStroke.getKeyStroke("control D"), "lineDel");
        this.comp.getActionMap().put("lineDel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyntaxTextUI.this.lineDel();
            }
        });
    }

    private void lineDel() {
        int postion = this.comp.getCaret().getDot();
        Element map = this.comp.getDocument().getDefaultRootElement();
        int index = map.getElementIndex(postion);
        Element line = map.getElement(index);
        try {
            int offs = Math.max(0, line.getStartOffset());
            int len = line.getEndOffset() - offs;
            int max = this.comp.getDocument().getLength();
            if (offs + len > max) {
                if (offs == 0) {
                    --len;
                } else {
                    --offs;
                }
            }
            this.comp.getDocument().remove(offs, len);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

